#!/bin/sh
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
# $Header: /sys/dist/etc/RCS/whichdev.sh,v 1.1 1988/12/09 22:53:30 md Exp $ 
# $ACIS:whichdev.sh 12.0$ 
# $Source: /sys/dist/etc/RCS/whichdev.sh,v $ 
# usage: whichdev host partition
#	echo the device associated with partition on host
CMD=`basename $0` 

case $# in
1)	PART=$1;;
*)	echo "usage: $CMD partition" >&2
	exit 1;;
esac

case "$PART" in
hd?[a-h] | sc?[a-h])
	exec echo /dev/r"$PART";;

root)	exec echo /;;
user)	exec echo /usr;;
source)	exec echo /usr/src;;
minimal|site)
	exec echo /minroot;;
nfsreduced)
	exec echo /usr;;

*[\ \	]*)
	# check for space or tab, fall through to usage message
	;;

/*)	exec echo "$PART";;
esac

echo "$CMD:$PART:invalid partition
	valid partitions are: hd?? sc?? root user source minimal /*" >&2
exit 1
