/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtdist/glob/RCS/main.c,v 1.3 1994/02/28 14:54:55 md Exp $ */
/* $ACIS:xxxfs.c 12.0$ */
/* $Source: /usr/src/sys/rtdist/glob/RCS/main.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /usr/src/sys/rtdist/glob/RCS/main.c,v 1.3 1994/02/28 14:54:55 md Exp $";
#endif

/*
 * merged mkfs/newfs front end for miniroot
 * usage:
 *	newfs newfs_parameters
 */

#include <stdio.h>

char *basename(c)
char *c;
{
	char *p;
	p=c;
	while (*c) if (*c++ == '/') p=c;
	return(p);
}

main (argc,argv)

int argc;
char **argv;

{
	int retval = 0;
	char *basename(),*name;

	/* figure out who we think we are */
	name=basename(argv[0]);

	/* the first few are sources developed for miniroot */

#ifndef GLOB_BUILTINS
	if (0) {	/* dummy */
		;
	}
#else
	if (strcmp(name,"dtype")==0) {
		main_dtype(argc,argv);
	}
#ifdef MAIN_SYSCALL
	else if (strcmp(name,"syscall")==0) {
		main_syscall(argc,argv);
	}
#endif
#ifdef MAIN_ONECHAR
	else if (strcmp(name,"onechar")==0) {
		main_onechar(argc,argv);
	}
#endif
#endif

	/* now begins the optional section */

#ifdef MAIN_FTC
	else if (strcmp(name,"ftc")==0) {
		retval = main_ftc(argc,argv);
	}
#endif
#ifdef MAIN_INIT
	else if (strcmp(name,"init")==0) {
		retval = main_init(argc,argv);
	}
#endif
#ifdef MAIN_NEWFS
	else if (strcmp(name,"newfs")==0) {
		retval = main_newfs(argc,argv);
	}
	else if (strcmp(name,"mfs")==0) {
		retval = main_newfs(argc,argv);
	}
#endif
#ifdef MAIN_IFCONFIG
	else if (strcmp(name,"ifconfig")==0) {
		retval = main_ifconfig(argc,argv);
	}
#endif
#ifdef MAIN_ROUTE
	/* XXX: this version currently doesn't work */
	else if (strcmp(name,"route")==0) {
		retval = main_route(argc,argv);
	}
#endif
#ifdef MAIN_MOUNT
	else if (strcmp(name,"mount")==0) {
		retval = main_mount(argc,argv);
	}
#endif
#ifdef MAIN_RSH
	else if (strcmp(name,"rsh")==0) {
		retval = main_rsh(argc,argv);
	}
#endif
#ifdef MAIN_DD
	else if (strcmp(name,"dd")==0) {
		retval = main_dd(argc,argv);
	}
#endif
#ifdef MAIN_TEST
	else if (strcmp(name,"test")==0) {
		retval = main_test(argc,argv);
	}
	else if (strcmp(name,"[")==0) {
		retval = main_test(argc,argv);
	}
#endif
#ifdef MAIN_EXPR
	else if (strcmp(name,"expr")==0) {
		retval = main_expr(argc,argv);
	}
#endif
#ifdef MAIN_STTY
	else if (strcmp(name,"stty")==0) {
		retval = main_stty(argc,argv);
	}
#endif
#ifdef MAIN_CP
	else if (strcmp(name,"cp")==0) {
		retval = main_cp(argc,argv);
	}
#endif
#ifdef MAIN_RM
	else if (strcmp(name,"rm")==0) {
		retval = main_rm(argc,argv);
	}
#endif
#ifdef MAIN_DATE
	else if (strcmp(name,"date")==0) {
		retval = main_date(argc,argv);
	}
#endif
#ifdef MAIN_TAR
	else if (strcmp(name,"tar")==0) {
		retval = main_tar(argc,argv);
	}
#endif
#ifdef MAIN_RESTORE
	else if (strcmp(name,"restore")==0) {
		retval = main_restore(argc,argv);
	}
#endif
#ifdef MAIN_LS
	else if (strcmp(name,"ls")==0) {
		retval = main_ls(argc,argv);
	}
#endif
	else {
		fprintf(stderr,"%s:unknown program\n",name);
		exit (-1);
	}
	return (retval);
}
