#!/bin/sh
# $Header: /sys/rtdist/lib/RCS/install.driver.sh,v 1.5 1993/05/20 21:04:00 md Exp $ 
# $Source: /sys/rtdist/lib/RCS/install.driver.sh,v $ 

ask=/etc/ask
root="hd0a"
usr="hd0g"
var="hd0e"

echo "\
	Default setup is the following:

	    /	  on  /dev/${root}
	    /var  on  /dev/${var}
	    /usr  on  /dev/${usr}

";

ROOT=`$ask "Install root on"  "$root"`
USR=`$ask "Install usr on"  "$usr"`
VAR=`$ask "Install var on"  "$var"`
# disk=`$ask "Install boot block on"  "$disk"`

# only tape installs right now.
tape=1

while :
do
	echo -n "Perform installation? [y/n] "

	case "`onechar`" in
	[Yy])	break;;
	[Nn])	exit 1;;

	*)	echo "\
Press 'y' to perform installation, or
      'n' to abort installation.";;
	esac
done

# disks="root=$root usr=$usr var=$var disk=$disk"
# disks="root=$root usr=$usr var=$var"
export ROOT USR VAR

case $tape in
0)	Command="restore.net -config $config -fstab"
	NetOptions="'$NET' -s '$shost' -d '$thost' -ifconfig '$ifconfig' -fsck"
	masks="$masks -m nosupport -m noserver -m nomailconf -m nolocal";;
1)	Command="restore.tape"
esac

if eval $Command 
then
	echo "Installation was successful"
else
	echo "Installation was NOT successful"
fi
exit 0
