#!/bin/sh
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
# $Header: /sys/dist/lib/RCS/install.options.sh,v 1.1 1988/12/09 22:53:37 md Exp $ 
# $ACIS:install.options.sh 12.0$ 
# $Source: /sys/dist/lib/RCS/install.options.sh,v $ 
echo "\
The following options may be changed by the user:

'root device'		Specifies the hard disk to use as the root device
			for $NAME.

`case $ATR in 0|1) echo \"\
'system configuration'	Specifies the nature of the root and usr
			partitions on this system.\";;
esac`

'optional system	Specifies any components to be installed in
 components'		addition to the base system.

`case $tape in 0) echo \"\
'source host'		The machine from which $NAME is to be downloaded.

'target host'		The machine onto which $NAME is to be installed.

'network preference'	Specifies preference for the ethernet or token ring.

'additional parameters	These parameters will be passed to ifconfig when it
 for ifconfig'		configures the network adapter.\";;
esac`

'output'		Specifies either verbose or terse output.



The 'root device' option specifies the hard disk (normally hd0) to use
as the root device for $NAME.`

case $ATR in
0)	echo		    \"  Installing $NAME onto hd1 or hd2 can be
useful when installing $NAME for coresidence with Advanced Interactive
Executive (AIX).  Please refer to the article 'Installing and Operating
Academic Operating System 4.3.'\";;
esac`

`case $ATR in 0|1) echo \"\
The 'system configuration' may be full, reduced, nfsreduced, minimal, or
nfsminimal.  A 'full' configuration has the root and usr partitions on
the local hard disk.  A 'reduced' configuration has the root partition
on the local hard disk, while the Andrew File System (AFS) is used for
the usr partition.  An 'nfsreduced' configuration has its root partition
on the local hard disk, and uses the Network File System (NFS) for the usr
partition.  A 'minimal' configuration uses NFS for the root partition, and
the Andrew File System (AFS) for the usr partition.  An nfsminimal
configuration uses NFS for both the root and usr partitions.\";;
esac`

The 'optional system components' specified will be installed in addition
to the base $NAME system.  One or more of the following may be selected:

	Name		Description`
case $ATR in 0) echo \"
	 kernel		 The kernel source in /usr/sys.
	 utility	 The utility source in /usr/src.\";;
esac`
	 doc		 The documentation source in /usr/doc.
	 man		 The on-line man pages in /usr/man.
	 font		 The 3812 font libraries in /usr/lib/font.
	 learn		 The learn database library in /usr/lib/learn.
	 notes		 The notes system in /usr/spool/notes.`
case $tape in 0) echo \"
	 x11		 The X11 source code and binaries.\";;
esac`
	 all		 All of the above.
	 none		 None of the above.

`case $tape in 0) echo \"
The 'source host' and 'target host' options specify the hostnames
(eg, 'master' or 'slave') or internet addresses (eg, '46.0.0.1' or
'46.0.0.2') of the machines involved in the network installation.
The installation will download $NAME from the 'source host' onto
this system, which is 'target host.'

The 'network preference' option specifies whether the installation
procedure attempts to configure the ethernet or token ring adapter
first.  If your system has only one network adapter, then this
option is irrelevant.

Specifying 'additional parameters for ifconfig' is useful if your
network is not running the default configuration.  For example, the
parameter 'broadcast 46.0.0.0' could be used to override the default
broadcast address of 46.255.255.255.  Refer to the ifconfig(8) man
page for further information.

Note that entering incorrect information into the 'source host',
'destination host', or 'addition parameters for ifconfig' may force
you to reboot the miniroot diskette and try again.  This problem
is more likely to happen if you are net installing through a
gateway.\"
esac`

The 'output' option specifies either verbose or terse output.
Note that terse output causes long periods of time with no activity
on the screen.
"
