#!/bin/sh
# $Header: /sys/rt/dist/RCS/restore.net.sh,v 1.4 1994/05/23 15:05:57 roger Exp $ 
# $Source: /sys/rt/dist/RCS/restore.net.sh,v $ 

#set -x

root=${ROOT-"hd0a"}
var=${VAR-"hd0e"}
usr=${USR-"hd0g"}
disk=`expr $root : '\(.*\)a'`c
swap=`expr $root : '\(.*\)a'`b
# disk=${disk-"hd0c"}

# XXX: the following line depends on ksh
# disk=${root%a}c

trap "exit 1" 0 2

# need a writable /tmp with lots of space for restore to work
echo "Mounting /tmp on /dev/${swap}"
mfs -s 10000 /dev/$swap /tmp

XCODE="/mnt/local/X11R5/bin/Xibm"
xterminal=0

echo

echo "enabling network interface"
ifconfig $INTERFACE inet $THOST $NETMASK up
if [ -n "$ROUTER" ] ; then
    route add 0 $ROUTER
fi

trap "cd /;( /sbin/umount /mnt) > /dev/null 2>&1 ; exit 1" 0 2

echo
echo "Installing / on /dev/${root}"
/sbin/newfs ${root}
/sbin/mount /dev/${root} /mnt; cd /mnt

# XXX: newfs, if compile properly, will do this for us.
# install the boot block manually.
#if /usr/mdec/installboot /usr/mdec/`/sbin/dtype /dev/${disk}`boot /usr/mdec/boothd /dev/r${disk}
#then : all is well
#	echo
#else
#	echo " 
#		WARNING! failed to write boot record to /dev/rhd0c"
#fi

rsh -n -l $NETUSER $SHOST dd if=root.image bs=8192 | /sbin/restore rf$VERBOSE -
err=$?
if [ $err -eq 0 ]
then : all is well
	echo
else
	# XXX: there lurks a bug in the miniroot somewhere where err
	#	will spuriously get set to 141 here, even tho we 
	#	succeeded...  knowing the range of errors that we could
	#	possibly get, we simply ignore it for now...
	if [ $err -le 81 ] ; then
		echo "
			### error $err DURING restore of /" >&2
		exit $err
	fi
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
syscall unlink restoresymtable

#
# write out fstab
#
echo "Creating etc/fstab ...."
cat >etc/fstab <<! 
/dev/${root}	/		ufs	rw 1 1
/dev/${usr}	/usr		ufs	rw 1 3
/dev/${var}	/var		ufs	rw 1 3
/dev/${swap}	/tmp		mfs	rw,-s=6000 0 0
!
echo

/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
cd /
/sbin/umount /mnt 2>/dev/null

echo "Installing /var on /dev/${var}"
/sbin/newfs ${var}
/sbin/mount /dev/${var} /mnt; cd /mnt
rsh -n -l $NETUSER $SHOST dd if=var.image bs=8192 | /sbin/restore rf$VERBOSE -
err=$?
if [ $err -eq 0 ]
then : all is well
	echo
else
	if [ $err -le 81 ] ; then
		echo "
			### error $err DURING restore of /var" >&2
		exit $err
	fi
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
syscall unlink restoresymtable
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
cd /
/sbin/umount /mnt 2>/dev/null

echo "Installing /usr on /dev/${usr}"
/sbin/newfs ${usr}
/sbin/mount /dev/${usr} /mnt; cd /mnt
rsh -n -l $NETUSER $SHOST dd if=usr.image bs=8192 | /sbin/restore rf$VERBOSE -
err=$?
if [ $err -eq 0 ]
then : all is well
	echo
else
	if [ $err -le 81 ] ; then
		echo "
			### error $err DURING restore of /usr" >&2
		exit $err
	fi
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
syscall unlink restoresymtable
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync

if test -f $XCODE ; then
	xterminal=1
fi
cd /
/sbin/umount /mnt 2>/dev/null

if test $xterminal != 0 ; then
	echo "Hey, I see the file $XCODE out there!  Looks like you're"
	echo "installing the Xterminal code."
	echo
	/sbin/mount /dev/${root} /mnt 2>/dev/null

	# put this shell script onto the xstations root partition
	cp /xconf /mnt/.

	# now run it.
	ROOT=/mnt /xconf
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
/sbin/umount /mnt 2>/dev/null
echo "DONE"

trap 0
exit 0
