#!/bin/sh
# $Header: /sys/rt/dist/RCS/restore.tape.sh,v 1.8 1994/05/23 15:17:08 roger Exp $ 
# $Source: /sys/rt/dist/RCS/restore.tape.sh,v $ 

#set -x

root=${ROOT-"hd0a"}
var=${VAR-"hd0e"}
usr=${USR-"hd0g"}
disk=`expr $root : '\(.*\)a'`c
swap=`expr $root : '\(.*\)a'`b
# disk=${disk-"hd0c"}

# XXX: the following line depends on ksh
# disk=${root%a}c

trap "exit 1" 0 2

# need a writable /tmp with lots of space for restore to work
echo "Mounting /tmp on /dev/${swap}"
mfs -s 10000 /dev/$swap /tmp

XCODE="/mnt/local/X11R5/bin/Xibm"
xterminal=0

echo

while : wait until tape is ready
do
    echo -n ">>> Insert tape and press <ENTER> "
    read answer
    case $answer in
    "")	if echo -n < /dev/st0
	    then break # tape is readable and rewound
	    else
		    echo " ### tape drive not ready!!!" >&2
		    echo " ### Is the POWER ON?
### Is the door closed (handle vertical)?
### Is the tape drive plugged into the adapter?
### Fix the problem and try again (else type 'quit')" >&2
		    continue
	    fi;;
    "quit")	exit 1;;
    *)	echo " ### '$answer' invalid response, press <ENTER> or type 'quit'" >&2
	    continue;;
    esac
done

trap "cd /;( /sbin/umount /mnt) > /dev/null 2>&1 ; exit 1" 0 2

echo
echo "Installing / on /dev/${root}"
/sbin/newfs ${root}
/sbin/mount /dev/${root} /mnt; cd /mnt


# XXX: newfs, if compile properly, will do this for us.
# install the boot block manually.
#if /usr/mdec/installboot /usr/mdec/`/sbin/dtype /dev/${disk}`boot /usr/mdec/boothd /dev/r${disk}
#then : all is well
#	echo
#else
#	echo " 
#		WARNING! failed to write boot record to /dev/rhd0c"
#fi

if /usr/ibm/ftc -B -1024 /dev/nrst0 -  2>/dev/null | /sbin/restore rf$VERBOSE -
then : all is well
	echo
else
	echo "
		### error $? DURING restore of /" >&2
	exit $?
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
syscall unlink restoresymtable

#
# write out fstab
#
echo "Creating etc/fstab ...."
cat >etc/fstab <<! 
/dev/${root}	/		ufs	rw 1 1
/dev/${usr}	/usr		ufs	rw 1 3
/dev/${var}	/var		ufs	rw 1 3
/dev/${swap}	/tmp		mfs	rw,-s=6000 0 0
!
echo
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync

cd /
/sbin/umount /mnt 2>/dev/null

echo "Installing /var on /dev/${var}"
/sbin/newfs ${var}
/sbin/mount /dev/${var} /mnt; cd /mnt
if /usr/ibm/ftc -B -1024 /dev/nrst0 -  2>/dev/null | /sbin/restore rf$VERBOSE -
then : all is well
	echo
else
	echo "
		### error $? DURING restore of /var" >&2
	exit $?
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
syscall unlink restoresymtable
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
cd /
/sbin/umount /mnt 2>/dev/null

echo "Installing /usr on /dev/${usr}"
/sbin/newfs ${usr}
/sbin/mount /dev/${usr} /mnt; cd /mnt
if /usr/ibm/ftc -B -1024 /dev/nrst0 -  2>/dev/null | /sbin/restore rf$VERBOSE -
then : all is well
	echo
else
	echo "
		### error $? DURING restore of /usr" >&2
	exit $?
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
syscall unlink restoresymtable

if test -f $XCODE ; then
	xterminal=1
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
cd /
/sbin/umount /mnt 2>/dev/null

if test $xterminal != 0 ; then
	echo "Hey, I see the file $XCODE out there!  Looks like you're"
	echo "installing the Xterminal code."
	echo
	/sbin/mount /dev/${root} /mnt 2>/dev/null

	# put this shell script onto the xstations root partition
	cp /xconf /mnt/.

	# now run it.
	ROOT=/mnt /xconf
fi
/bin/sync;/bin/sync;/bin/sync;/bin/sync;/bin/sync
/sbin/umount /mnt 2>/dev/null
echo "DONE"

trap 0
exit 0
