/*
   dtype.c - print type of disk supplied in argv[1]  (Mark Dapoz)

   $Header: /sys/dist/etc/RCS/Makefile,v 1.4 1992/11/17 09:29:09 md Exp md $ 
   $Source: /sys/dist/etc/RCS/Makefile,v $ 
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/disklabel.h>

main(argc, argv)
int argc;
char **argv;
{
	struct disklabel lab;
	int fd;

	if (argc < 2) {
		fprintf(stderr,"usage: %s [special file]\n", argv[0]);
		exit(1);
	}
	if ((fd=open(argv[1], O_RDONLY)) < 0) {
		perror("open");
		exit(1);
	}
	if (ioctl(fd, DIOCGDINFO, (char *)&lab) < 0) {
		perror("ioctl (GDINFO)");
		exit(1);
	}
	printf("%s\n", lab.d_typename);
	close(fd);
	exit(0);
}
