/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * All advertising materials mentioning features or use of this software
 * must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Lawrence Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)float.h	8.1 (Berkeley) 6/11/93
 *
 * from: $Header: /usr/src/sys/rt/include/RCS/float.h,v 1.2 1994/05/29 21:32:12 md Exp $
 */

#define FLT_RADIX	2		/* b */
#define FLT_ROUNDS	1		/* add rounds to nearest by default */

#define FLT_MANT_DIG	24		/* p */
#define FLT_EPSILON	1.19209290E-07F	/* b**(1-p) */
#define FLT_DIG		6		/* floor((p-1)*log10(b))+(b == 10) */
#define FLT_MIN_EXP	-125		/* emin */
#define FLT_MIN		1.17549435E-38F	/* b**(emin-1) */
#define FLT_MIN_10_EXP	-37		/* ceil(log10(b**(emin-1))) */
#define FLT_MAX_EXP	128		/* emax */
#define FLT_MAX		3.40282347E+38F	/* (1-b**(-p))*b**emax */
#define FLT_MAX_10_EXP	38		/* floor(log10((1-b**(-p))*b**emax)) */

#define DBL_MANT_DIG	53
#define DBL_EPSILON	2.2204460492503131E-16
#define DBL_DIG		15
#define DBL_MIN_EXP	-1021
#define DBL_MIN		2.2250738585072014E-308
#define DBL_MIN_10_EXP	-307
#define DBL_MAX_EXP	1024
#define DBL_MAX		1.7976931348623157E+308
#define DBL_MAX_10_EXP	308

#define LDBL_MANT_DIG	DBL_MANT_DIG
#define LDBL_EPSILON	DBL_EPSILON
#define LDBL_DIG	DBL_DIG
#define LDBL_MIN_EXP	DBL_MIN_EXP
#define LDBL_MIN	DBL_MIN
#define LDBL_MIN_10_EXP	DBL_MIN_10_EXP
#define LDBL_MAX_EXP	DBL_MAX_EXP
#define LDBL_MAX	DBL_MAX
#define LDBL_MAX_10_EXP	DBL_MAX_10_EXP


/*
 * The rest of this file contains definitions and declarations required
 * for the floating point accelerator on the RT and are not used by any
 * BSD 4.4 code.
 */

#ifndef	_FLOATSAVE_

/* 
 * floatsave is the save area for the floating point registers
 * used when it is necessary to take back a register set from
 * a process. these are kept in kernel memory so that it is
 * easy to do so. The space is allocated only when the FPA is 
 * present.
 * the current register set is given in the proc structure.
 *
 */

#define	_FLOATSAVE_

#ifndef LOCORE
/* saved float register sets are indexed by p-proc. */

/*
 * For each type of register set, we define the number of words necessary to
 * save the state of that type of hardware.
 */
#define FPA_SAVE_WORDS		(64+3)		/* FPA1 or 2 */
#define	MC881_SAVE_WORDS	(300/4)
#define	EMUL_SAVE_WORDS		34

/*
 * For each type of register set, we define the number of legal registers
 * which may be set/fetched via ptrace.
 */
#define	FPA_NUM_REG	16
#define	MC881_NUM_REG	(3*8)	/* 8 registers, each extended precision */
#define	EMUL_NUM_REG	16

struct floatsave 
{
	union {
		int fpa_int[FPA_SAVE_WORDS];
		double fpa_double[FPA_SAVE_WORDS/2];
		float fpa_float[FPA_SAVE_WORDS];
		int mc881_int[MC881_SAVE_WORDS];
		int emul_int[EMUL_SAVE_WORDS];
	} float_un;
#define fpa_intreg float_un.fpa_int
#define fpa_doublereg float_un.fpa_double
#define fpa_floatreg float_un.fpa_float
#define	mc881_intreg	float_un.mc881_int
#define	emul_intreg	float_un.emul_int
};

#ifdef KERNEL
extern struct floatsave *floatsave;	/* NPROC of these allocated */
extern int	float_hardware;		/* What hardware is on the system */
#endif KERNEL

/*
 * The following structure is what the kernel and user process use
 * to pass back and forth the state of the system and process
 * floating point structures.
 */

struct floatstate {
    int
	hardware_state,		/* What exists on the system */
	process_state;		/* What is allocated to this process */
    void
	(*emulator)(),		/* Address of floating point emulator */
	(*code_generator)();	/* Address of floating point code generator */
    int
	fpa_registerset;	/* (At this time) which fpa register set */
};

#define	float_has_881(x)	((x)&FLOAT_MC881)
#define	float_has_fpa(x)	((x)&FLOAT_FPA)
#define	float_has_afpa(x)	((x)&FLOAT_AFPA)
#define	float_has_e_afpa(x)	(((x)&FLOAT_AFPA) && \
				((x)&FLOAT_AFPA_PASS_D))
#define	float_has_fpa_or_afpa(x)	((x)&(FLOAT_FPA|FLOAT_AFPA))
#define	float_has_any(x)	((x)&(FLOAT_FPA|FLOAT_AFPA|FLOAT_MC881))
#define	float_has_emul(x)	((x)&FLOAT_EMUL)
#define	float_has_afpa_hardware(x)	((x)&FLOAT_AFPA_HARDWARE)
#define	float_has_e_afpa_hardware(x)	(((x)&FLOAT_AFPA_HARDWARE) && \
					((x)&FLOAT_AFPA_PASS_D))

/*
 * These are the values which exist in u.u_floatmask, and in float_hardware.
 */
#define	FLOAT_MC881			0x01	/* Using mc881/mc881 exists */
#define	FLOAT_FPA			0x02	/* Using fpa/afpa exists */
#define	FLOAT_AFPA			0x04	/* Using afpa/afpa operational*/
#define	FLOAT_EMUL			0x08	/* Using emulator */
#define	FLOAT_AFPA_HARDWARE		0x10	/* Afpa hardware exists */
	/*
	 * Control store accesses to afpa enabled.
	 * In this state, the only legal afpa commands are
	 * those to load the microcode.
	 */
#define	FLOAT_AFPA_CONTROL_STORE_ENABLE	0x20
#define	FLOAT_AFPA_DMA			0x40	/* Afpa with DMA hardware */
#define	FLOAT_AFPA_PASS_D		0x80	/* hardware type is E_AFPA */

#define FLOAT_FMT "\20\1MC881\2FPA\3AFPA_UP\4EMUL\5AFPA_HW\6AFPA_CTL\7AFPA_DMA"

#endif LOCORE

#endif	/* _FLOATSAVE_ */
