/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rt/RCS/softint.h,v 1.4 1991/12/03 11:16:38 md Exp $ */
/* $ACIS:softint.h 12.0$ */
/* $Source: /usr/src/sys/rt/RCS/softint.h,v $ */

#ifndef	SOFT_NET

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsoftint = "$Header: /usr/src/sys/rt/RCS/softint.h,v 1.4 1991/12/03 11:16:38 md Exp $";
#endif

/*	softint.h	*/

/*
 * CPU level 6 is used for software interrupts.
 *
 * The softvector array contains one char entry for
 * each interrupt routine.
 */

/*
 * array offsets for softvector
 */
#define SOFT_CLOCK	0
#define SOFT_NET	1
#define SOFT_TTY	2
#define SOFT_KLS	3
#define SOFT_ASY	4
#define SOFT_PSP	5

#define	SOFT_VECTOR_SIZE	6

#if defined(KERNEL) && !defined(LOCORE)
extern	unsigned char softvector[];

/*#define setsoftTTY() { softvector[SOFT_TTY] = 1; setsoftint(); }*/
#define setsoftKLS() { softvector[SOFT_KLS] = 1; setsoftint(); }
#define setsoftASY() { softvector[SOFT_ASY] = 1; setsoftint(); }
#define setsoftPSP() { softvector[SOFT_PSP] = 1; setsoftint(); }
#define setsoftclock() { softvector[SOFT_CLOCK]	= 1; setsoftint(); }

#endif
#endif
