/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rtio/RCS/streg.h,v 1.1 1988/12/09 22:52:19 md Exp $ */
/* $ACIS:streg.h 12.0$ */
/* $Source: /usr/src/sys/rtio/RCS/streg.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidstreg = "$Header: /usr/src/sys/rtio/RCS/streg.h,v 1.1 1988/12/09 22:52:19 md Exp $";
#endif

/*	streg.h	6.1	83/07/29	*/

/*
 * ST adapter registers
 */
struct stdevice {				/*      must cast data when used         */
	unsigned short stsec;	/* 0:   sector buffer aka ram_port */
	unsigned char stcs;		/* 2:   control reg aka cntl_port aka status_port */
	unsigned char empty3;	/* 3:   */
	unsigned char stdata;	/* 4:   data port aka data_port */
	unsigned char empty5;	/* 5:   */
	unsigned char stcmd;		/* 6:   command port (write only) aka cmd_port*/
	unsigned char empty7;	/* 7:   */
};

#define	b_repcnt  b_bcount
#define	b_command b_resid

/* commands in stcmd */
#define	ST_RESET		0x00	/* reset adapter */
#define	ST_OFFL		0x00	/* treat as reset */
#define	ST_SELECT	0x01	/* select drive */
#define	ST_REW		0x02	/* rewind */
#define	ST_ERASE		0x03	/* ERASE entire tape and rewind */
#define	ST_RETENSION	0x04	/* retention tape */
#define	ST_SENSE		0x05	/* sense (issue READ STATUS, 8 bytes returned) */
#define	ST_WCOM		0x06	/* write */
#define	ST_WIRG		0x06 	/*XXX*//* write with xtra interrecord gap */
#define	ST_WEOF		0x07	/* write-eof */
#define	ST_RCOM		0x08	/* read */
#define	ST_REOF		0x09	/* read eof */
#define	ST_SBAD		0x0a	/* a bad command */
#define	ST_SFORW		0x0c	/* space forward */
#define	ST_TERMINATE	0x0d	/* terminate read/write */
#define	ST_DST1		0x0e	/* drive self test1 - drive memory checksum */
#define	ST_DST2		0x0f	/* drive self test2 -
									 * 1) verifies capstan speed
									 * 2) verifies BOT, EOT, and capstan sensors
									 * 3) writes worst case pattern to tape
									 *		and verifies it					*/
#define	ST_DST3		0x10	/* drive self test3 - write protect check */
#define	ST_ADAP_PASS1	0x11	/* adapter passthru to drive - REW timing */
#define	ST_ADAP_PASS2	0x12	/* ditto - REOF(1) timing */
#define	ST_CMD_AA	0xaa	/* POR handshake */
#define	ST_SREV		0x89

#define	streverseop(cmd)		((cmd)==ST_SREV || (cmd)==ST_REW)

#define ST_CTLR_BITS STCFMT		/* "control" register bits */
#define STCFMT	"\20\1IBF\2OBF\3RESERVED\4INTERRUPT\5EXCEPTION\6ONLINE\7READY\10BUSY"

/* read-only bits in stcs; D=Drive indicator A=Adapter generated */
#define STC_IBF	0x01	/* (A) input buffer full */
#define STC_OBF	0x02	/* (A) output buffer full */
#define STC_XX4	0x04	/* reserved */
#define STC_INT	0x08	/* (A) INTERRUPT */
#define STC_EXC	0x10	/* (D) EXCEPTION */
#define STC_ONL	0x20	/* (D) ONLINE */
#define STC_RDY	0x40	/* (D) READY */
#define STC_BSY	0x80	/* (A) BUSY */

/* write-only bits in stcs */
#define STC_ENABLE	0x01	/* enable interrupts */
#define STC_NORESET	0x02	/* don't reset */
#define STC_RESET		0x00	/* reset (adapter) */
#define STC_PARITY	0x04	/* enable parity */

/* bits in status byte 0 */
#define ST0_ST0	0x80	/* status bit for this byte ("OR" of following bits) */
#define ST0_CNI	0x40	/* cartridge not in place */
#define ST0_USL	0x20	/* device fault flag, examples:
								 *	1) no tape motion (jammed cartridge)
								 *	2) drive failed to recognize or exit
								 *		a BOT or EOT area
								 *	3) no tach pulses from capstan motor
								 *	4) drive internal cmd timeout	*/
#define ST0_WRP	0x10	/* write protected cartridge */
#define ST0_EOM	0x08	/* end of media */
#define ST0_UDA	0x04	/* unrecoverable data error */
#define ST0_BNL	0x02	/* bad block not located */
#define ST0_FIL	0x01	/* file mark detected */

/* bits in status byte 1 */
#define ST1_ST1	0x80	/* status bit for this byte ("OR" of following bits) */
#define ST1_ILL	0x40	/* illegal command, examples:
								 * 1) read/write w/o STC_ONL set
								 * 2) unimplemented command
								 * 3) non read(write) command w/o
								 *		properly terminating ongoing
								 *		read(write) sequence		*/
#define ST1_NTD	0x20	/* no data detected */
#define ST1_MBD	0x10	/* marginal block detected */
#define ST1_BOM	0x08	/* beginning of media */
#define ST1_BUS	0x04	/* bus parity error */
#define ST1_ERM	0x02	/* end of recorded media */
#define ST1_POR	0x01	/* power on/reset occurred */

/* streaming tape adapter completion codes */
#define CC_DONE		0x00
#define CC_LD_COUNT	0x01	/* awaiting r/w block count */
#define CC_POR_AA		0x02	/* awaiting POR handshake */
#define CC_RD_STATUS	0x10	/* status available */
#define CC_RD_VERS	0x20	/* version # available */
#define CC_READ		0x30	/* read buffer full */
#define CC_READ_LAST	0x31	/* read buf full - last buffer */
#define CC_WRITE		0x40	/* write buffer empty */
#define CC_POR			0x55	/* POR successful */
	/* rest of the completion codes are errors */
#define CC_EXCEPTION	0x80
		/* 0x81 to 0x85 - advisable to reset adapter */
#define CC_NOTREADY	0x81	/* adapter timeout on drive ready */
#define CC_READY		0x82	/* adapter timeout on drive !ready */
#define CC_PARITY		0x83	/* FPLS detected parity check */
#define CC_DIRECTION 0x84	/* drive direction */
#define CC_FPLS		0x85	/* adapter timeout on FPLS
									 * (programmable logic sequencer) */
#define CC_CMD_REJ_EXCEPT	0x90	/* cmd rejected - exception outstanding */
#define CC_CMD_REJ_INVAL	0x91	/* cmd rej - invalid command */
#define CC_REJ_SEQUENCE		0x92	/* cmd/data rej - invalid sequence
											 * of cmds and/or data	*/
		/* rest of the errors happen only on a reset
		 * all these are adapter detected
		 * after one of these the adapter should be reset */
#define CC_ROSERR		0xa0	/* ROS sumcheck */
#define CC_RAMERR		0xa1
#define CC_FPLSERR	0xa2	
#define CC_DRVERR		0xa3	/* drive not reset (could be powered off) */
#define CC_BUSERR		0xa4	/* data bus */


/* %b strings for error status bits */
#define ST0FMT	"\20\10ST0\7NO-CARTRIDGE\6UNSELECTED\5WRITE-PROTECTED\4END-OF-MEDIA\3UNREC-ERROR\2BAD-BLOCK-NOT-LOCATED\1FILE-MARK"
#define ST1FMT	"\20\10ST1\7ILLEGAL-CMD\6NO-DATA\5MARGINAL-BLOCK\4BEGIN-MEDIA\3BUS-PARITY-ERROR\2END-OF-RECORDED-MEDIA\1POWER-RESET"
#define ST_ERR_BITS "\20\10ST0\7NO-CARTRIDGE\6UNSELECTED\5WRITE-PROTECTED\4END-OF-MEDIA\3UNREC-ERROR\2BAD-BLOCK-NOT-LOCATED\1FILE-MARK\20ST1\17ILLEGAL-CMD\16NO-DATA\15MARGINAL-BLOCK\14BEGIN-MEDIA\13BUS-PARITY-ERROR\12END-OF-RECORDED-MEDIA\11POWER-RESET"
