/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header: /usr/src/sys/rt/RCS/Locore.c,v 1.2 1990/10/05 00:39:04 dennis Exp $ */
/* $ACIS:Locore.c 12.0$ */
/* $Source: /usr/src/sys/rt/RCS/Locore.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /usr/src/sys/rt/RCS/Locore.c,v 1.2 1990/10/05 00:39:04 dennis Exp $";
#endif

/*	Locore.c	6.1	83/08/11	*/


#include "pte.h"

#include "param.h"
#include "systm.h"
#include "dir.h"
#include "user.h"
#include "vm.h"
#include "tty.h"
#include "proc.h"
#include "buf.h"
#include "msgbuf.h"
#include "mbuf.h"
#include "protosw.h"
#include "domain.h"

#include "../rtio/ioccvar.h"

/*
 * Pseudo file for lint to show what is used/defined in locore.s.
 */


struct proc *masterpaddr;		/* p_addr of current process on master cpu */

struct	user u;

dumpsave() { }

lowinit()
{
	extern int dumpmag;
	extern struct domain unixdomain;
#ifdef PUP
	extern struct domain pupdomain;
#endif
#ifdef INET
	extern struct domain inetdomain;
#endif
#include "imp.h"
#if NIMP > 0
	extern struct domain impdomain;
#endif

	/* cpp messes these up for lint so put them here */
	unixdomain.dom_next = domains;
	domains = &unixdomain;
#ifdef PUP
	pupdomain.dom_next = domains;
	domains = &pupdomain;
#endif
#ifdef INET
	inetdomain.dom_next = domains;
	domains = &inetdomain;
#endif
#if NIMP > 0
	impdomain.dom_next = domains;
	domains = &impdomain;
#endif
	dumpmag = 0;			/* used only by savecore */

	/*
	 * Pseudo-uses of globals.
	 */
	lowinit();
	intstack[0] = intstack[1];
	maxmem = physmem = freemem = 0;
	u = u;
	main(0);

	/*
	 * Routines called from interrupt vectors.
	 */
	panic("Machine check");
	printf("Write timeout");
	cnint(0,0,0);
	hardclock(0, 0, 0);
	int_8259(&int3table,0,0);
	int_8259(&int4table,0,0);
	softclock(0, 0, 0);
	trap(0, 0, 0, 0);
	syscall(0, 0, 0, 0);

	if (vmemall((struct pte *)0, 0, (struct proc *)0, 0))
		return;		/* use value */
	machinecheck((caddr_t)0);
	memerr();
	boothowto = 0;
}

int	cold;


struct	pte Usrptmap[USRPTSIZE];
struct	pte usrpt[USRPTSIZE*NPTEPG];
struct	pte Forkmap[UPAGES];
struct	user forkutl;
struct	pte Xswapmap[UPAGES];
struct	user xswaputl;
struct	pte Xswap2map[UPAGES];
struct	user xswap2utl;
struct	pte Swapmap[UPAGES];
struct	user swaputl;
struct	pte Pushmap[UPAGES];
struct	user pushutl;
struct	pte Vfmap[UPAGES];
struct	user vfutl;
struct	pte CMAP1;
char	CADDR1[NBPG];
struct	pte CMAP2;
char	CADDR2[NBPG];
struct	pte mmap[1];
char	vmmap[NBPG];
struct	pte Mbmap[NMBCLUSTERS/CLSIZE];
struct	mbuf mbutl[NMBCLUSTERS*CLBYTES/sizeof (struct mbuf)];
struct	pte msgbufmap[CLSIZE];
struct	msgbuf msgbuf;
struct	pte camap[32];
int	cabase;
int	copybase;
#ifdef unneeded
char	caspace[32*NBPG];
#endif
int	calimit;

/*ARGSUSED*/
badaddr(addr, len) caddr_t addr; int len; { return (0); }

/*ARGSUSED*/
savectx(lp) label_t *lp; { return (0); }

/*ARGSUSED*/
setjmp(lp) label_t *lp; { return (0); }

/*ARGSUSED*/
longjmp(lp) label_t *lp; { /*NOTREACHED*/ }

/*ARGSUSED*/
setrq(p) struct proc *p; { }

/*ARGSUSED*/
remrq(p) struct proc *p; { }

swtch() { if (whichqs) whichqs = 0; if (masterpaddr) masterpaddr = 0; }

/*ARGSUSED*/
resume(pcbpf) unsigned pcbpf; { }
/*ARGSUSED*/

copyseg(udaddr, pf) caddr_t udaddr; unsigned pf; {
    CMAP1 = CMAP1; CADDR1[0] = CADDR1[0];
}

/*ARGSUSED*/
clearseg(pf) unsigned pf; { CMAP2 = CMAP2; CADDR2[0] = CADDR2[0]; }

/*VARARGS1*/
/*ARGSUSED*/
mtsr(reg, value) int reg, value; { }

/*ARGSUSED*/
mfsr(reg) int reg; { return (0); }


_spl0() { return (0); }
_spl1() { return (0); }
_spl2() { return (0); }
_spl3() { return (0); }
_spl4() { return (0); }
_spl5() { return (0); }
_spl6() { return (0); }
_spl7() { return (0); }

/*ARGSUSED*/
splx(s) int s; { }

getspl() { return(0); }

/*ARGSUSED*/
bcopy(from, to, count) caddr_t from, to; unsigned count; { ; }

/*ARGSUSED*/
bzero(base, count) caddr_t base; unsigned count; { ; }

/*ARGSUSED*/
bcmp(s1, s2, count) caddr_t s1, s2; unsigned count; { return (0); }

ntohs(s) u_short s; { return ((int)s); }

htons(s) u_short s; { return ((int)s); }

/*ARGSUSED*/
ior(reg) unsigned reg; { return(0); }

/*ARGSUSED*/
iow(reg,data) unsigned reg; { }

/*ARGSUSED*/
copypage(p1,p2) { }

/*ARGSUSED*/
display(value) { }

/*ARGSUSED*/
xadunload(addr,hdaddr,count,flag)
char *addr; int *hdaddr;
{ }

/*ARGSUSED*/
vtop(addr) { return(0); }

/*ARGSUSED*/
upcmul(n,scale) unsigned n, scale; { return(0); }

/*ARGSUSED*/
swapsids(x,y) { }

/*
 * Variables declared for savecore, or
 * implicitly, such as by config or the loader.
 */
char	version[] = "4.2 BSD UNIX ....";
char	etext;		/* end of text */
char	stext;		/* actual start of text */
char	coibm[] = "Copyright ...";
