/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /sys/rt/rt/RCS/conf.c,v 1.17 1994/06/16 19:02:52 roger Exp $ */
/* $ACIS:conf.c 12.0$ */
/* $Source: /sys/rt/rt/RCS/conf.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /sys/rt/rt/RCS/conf.c,v 1.17 1994/06/16 19:02:52 roger Exp $";
#endif

/*     conf.c  6.1     83/07/29        */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/buf.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/conf.h>
#include <sys/time.h>
#include <sys/vnode.h>

#include "rt/rt/debug.h"

int nulldev(), nodev(), rawread(), rawwrite(), swstrategy();

#include "hd.h"
#if NHD > 0
int hdinit(), hdstrategy(), hdopen(), hddump(), hdsize(), hdioctl();
#else
#define hdinit	nodev
#define hdstrategy	nodev
#define hdopen	nodev
#define hddump	nodev
#define hdsize	0
#define hdioctl	nodev
#endif

#include "fd.h"
#if NFD > 0
int fdinit(), fdstrategy(), fdioctl();
#ifdef	ATR
int fdopen(),fdclose(),fdsize();
#define	fdbopen	fdopen
#define	fdbclose	fdclose
#define	fdcopen	fdopen
#define	fdcclose	fdclose
#else	/* ATR */
#define fdsize	0		/* no fdsize on RT */
int fdbopen(), fdbclose(), fdcopen(), fdcclose();
#endif	/* ATR */
#else
#define fdinit	nodev
#define fdstrategy	nodev
#define fdbopen	nodev
#define fdcopen	nodev
#define fdbclose	nodev
#define fdcclose	nodev
#define fdioctl	nodev
#define fdsize	0
#endif

#include "st.h"
#if NST > 0
int stinit(), ststrategy(),  stopen(), stclose(), stsize(), stioctl();
#else
#define stinit	nodev
#define ststrategy	nodev
#define stopen	nodev
#define stclose	nodev
#define stsize	nodev
#define stioctl	nodev
#endif

#include "sc.h"
#if NSC > 0
int scsiinit(), scsistrategy(), scsiopen(), scsisize(), scsiioctl(),
    scsiread(), scsiwrite();
#else
#define scsiinit	nodev
#define scsistrategy	nodev
#define scsiopen	nodev
#define scsisize	0
#define scsiioctl	nodev
#define scsiread	nodev
#define scsiwrite	nodev
#endif

#include "cs.h"
#include "xt.h"
#include "cd.h"
#if NCSC > 0 
int	csopen(), csclose(), csread(), cswrite(), csioctl(), csstrategy(),
	csminphys();
#define		csselect	seltrue
#else
#define		csopen		nodev
#define		csclose		nodev
#define		csread		nodev
#define		cswrite		nodev
#define		csioctl		nodev
#define		csselect	nodev
#define		csstrategy	nodev
#define		csminphys	nodev
#endif NCS
#if NXTC > 0
int	xtopen(),xtclose(),xtioctl(),xtstrategy(), xtsize();
#define	xtdump		nodev
#else
#define		xtopen		nodev
#define		xtclose		nodev
#define		xtioctl		nodev
#define		xtstrategy	nodev
#define		xtsize		0
#define		xtdump		nodev
#endif NXT
#if NCDC > 0
int	cdopen(),cdclose(),cdioctl(),cdstrategy(), cdsize();
#define	cddump		nodev
#else
#define		cdopen		nodev
#define		cdclose		nodev
#define		cdioctl		nodev
#define		cdstrategy	nodev
#define		cdsize		0
#define		cddump		nodev
#endif NCD

#ifdef ATR
#include "op.h"

#if NOP > 0
int opstrategy(), opopen(), opclose(), opioctl(), opsize();
#else
#define opclose	nodev
#define opstrategy	nodev
#define opopen	nodev
#define opioctl	nodev
#define opsize	nodev
#endif
int mmsize(), mmstrategy();
#endif /* ATR */

int baddev();		/* which will panic */

struct bdevsw bdevsw[] = {
	/* open		close		strat		ioctl
	  dump		size		flags */
/* 0-9 reserved to IBM */
	{ nodev,	nodev,		baddev,		nodev,		/*0*/
	  nodev,	0,		0 },
	{ hdopen,	nulldev,	hdstrategy,	hdioctl,	/*1*/
	  hddump,	hdsize,		0 },
	{ nodev,	nodev,		nodev,		nodev,		/*2*/
	  nodev,	0,		0 },
	{ fdbopen,	fdbclose,	fdstrategy,	fdioctl,	/*3*/
	  nulldev,	fdsize,		0 },
	{ nodev,	nodev,		swstrategy,	nodev,		/*4*/ 
	  nodev,	0,		0 },
	{ stopen,	stclose,	ststrategy,	stioctl,	/*5*/
	  nodev,	0,		B_TAPE },
	{ nodev,	nodev,		nodev,		nodev,		/*6*/
	  nodev,	0,		0 },
	{ scsiopen,	nulldev,	scsistrategy,	scsiioctl,	/*7*/
	  nodev,	scsisize,	0 },
#ifdef ATR
	{ opopen,	opclose,	opstrategy,	opioctl,	/*8*/
	  nodev,	opsize,		0 },
	{ nulldev,	nulldev,	mmstrategy,	mmioctl,	/*9*/ 
	  nodev,	mmsize,		0 },
#else
	{ nodev,	nodev,		nodev,		nodev,		/*8*/
	  nodev,	0,		0 },
	{ nodev,	nodev,		nodev,		nodev,		/*9*/
	  nodev,	0,		0 },
#endif ATR
/* 0-9 reserved to IBM */
/* 10-19 reserved to local sites */
	{ csopen,	csclose,	csstrategy,	nodev,		/*10*/
	  nodev,	0,		B_TAPE},
	{ xtopen,	nulldev,	xtstrategy,	xtioctl,	/*11*/
	  xtdump,	xtsize,		0 },
	{ cdopen,	nulldev,	cdstrategy,	cdioctl,	/*12*/
	  cddump,	cdsize,		0 },
};
int nblkdev = sizeof(bdevsw) / sizeof(bdevsw[0]);

int cnopen(), cnclose(), cnread(), cnwrite(), cnioctl(), cnselect();
struct tty cons;

/* The asy driver supports several devices.  Some of the entries are shared */
#include "asy.h"
#include "asq.h"
#include "asx.h"
#if (NASY > 0) || (NASQ > 0) || (NASX > 0)
int asyclose(), asyread(), asywrite(), asyioctl(), asystop(), asyselect();
#endif /* (NASY > 0) || (NASQ > 0) || (NASX > 0) */

#if NASY > 0
int asyopen();
struct tty asy_tty[];
#define	asycloseX	asyclose
#define	asyreadX	asyread
#define	asywriteX	asywrite
#define	asyioctlX	asyioctl
#define	asystopX	asystop
#define	asyselectX	asyselect
#else
#define	asyopen		nodev
#define	asy_tty		0
#define	asycloseX	nodev
#define	asyreadX	nodev
#define	asywriteX	nodev
#define	asyioctlX	nodev
#define	asystopX	nodev
#define	asyselectX	nodev
#endif /* NASY > 0 */

#if NASQ > 0
int asqopen();
struct tty asq_tty[];
#define	asqcloseX	asyclose
#define	asqreadX	asyread
#define	asqwriteX	asywrite
#define	asqioctlX	asyioctl
#define	asqstopX	asystop
#define	asqselectX	asyselect
#else
#define	asqopen		nodev
#define	asq_tty		0
#define	asqcloseX	nodev
#define	asqreadX	nodev
#define	asqwriteX	nodev
#define	asqioctlX	nodev
#define	asqstopX	nodev
#define	asqselectX	nodev
#endif /* NASQ > 0 */

#if NASX > 0
int asxopen();
struct tty asx_tty[];
#define	asxcloseX	asyclose
#define	asxreadX	asyread
#define	asxwriteX	asywrite
#define	asxioctlX	asyioctl
#define	asxstopX	asystop
#define	asxselectX	asyselect
#else
#define	asxopen		nodev
#define	asx_tty		0
#define	asxcloseX	nodev
#define	asxreadX	nodev
#define	asxwriteX	nodev
#define	asxioctlX	nodev
#define	asxstopX	nodev
#define	asxselectX	nodev
#endif /* NASX > 0 */

int syopen(), syread(), sywrite(), syioctl(), syselect();

int mmrw();
#ifdef ATR
int mmioctl();
#endif
#define        mmselect        seltrue

#include "pty.h"
#if NPTY > 0
int ptsopen(), ptsclose(), ptsread(), ptswrite(), ptsstop();
int ptcopen(), ptcclose(), ptcread(), ptcwrite(), ptcselect();
int ptyioctl();
struct tty pt_tty[];
#else
#define ptsopen         nodev
#define ptsclose        nodev
#define ptsread         nodev
#define ptswrite        nodev
#define ptcopen         nodev
#define ptcclose        nodev
#define ptcread         nodev
#define ptcwrite        nodev
#define ptyioctl        nodev
#define pt_tty          0
#define ptcselect       nodev
#define ptsstop         nulldev
#endif

#include "lp.h"
#if NLP > 0
int lpopen(), lpclose(), lpwrite();
#else
#define lpopen nodev
#define lpclose nodev
#define lpwrite nodev
#endif

#include "psp.h"
#if NPSP > 0
int pspopen(), pspclose(), pspread(), pspwrite();
int pspioctl(), pspstop(), pspselect();
struct tty psp_tty[];
#else
#define		pspopen		nodev
#define		pspclose	nodev
#define		pspstrategy	nodev
#define		pspread		nodev
#define		pspwrite	nodev
#define		pspioctl	nodev
#define		pspstop		nodev
#define		pspselect	nodev
#define		psp_tty		0
#endif

#include "ps.h"
#if NPS > 0
int psopen(), psclose(), psread(), pswrite(), psioctl(), psselect();
#else
#define		psopen		nodev
#define		psclose		nodev
#define		psstrategy	nodev
#define		psread		nodev
#define		pswrite		nodev
#define		psioctl		nodev
#define		psselect	nodev
#define		ps	0
#endif

int busopen(), busclose();

int spkopen(), spkwrite(), spkclose();
#ifdef notdef	/* in case some one wants to make this dev conditional */
#define 	spkopen		nodev
#define 	spkwrite	nodev
#define 	spkclose	nodev
#endif 

#include "ms.h"
#if NMS > 0
int msopen(), msclose(), msread(), msioctl(), msselect();
struct  tty ms_tty[];
#else
#define		msopen		nodev
#define		msclose		nodev
#define		msread		nodev
#define		msioctl		nodev
#define 	ms_tty		0
#define 	msselect	nodev
#endif

int	logopen(),logclose(),logread(),logioctl(),logselect();

#ifdef	ATR
#include	"pcbios.h"
#if NPCBIOS > 0
int	pcbiosopen(), pcbiosclose();
int	pcbiosioctl();
#else
#define 	pcbiosopen	nodev
#define 	pcbiosclose	nodev
#define 	pcbiosioctl	nodev
#endif
#endif	ATR

#include "bpfilter.h"
#if NBPFILTER > 0
int	bpfopen(), bpfclose(), bpfread(), bpfwrite(), bpfioctl(), bpfselect();
#else
#define		bpfopen		nodev
#define		bpfclose	nodev
#define		bpfread		nodev
#define		bpfwrite	nodev
#define		bpfioctl	nodev
#define		bpfselect	nodev
#endif

#include "lms.h"
#if NLMS > 0
int     lmsopen(), lmsclose(), lmsread(), lmsioctl(), lmsselect();
struct  tty lms_tty[];
#else
#define lmsopen         nodev
#define lmsclose        nodev
#define lmsread         nodev
#define lmsioctl        nodev
#define lmsselect       nodev
#define lms_tty		0
#endif

int ttselect(), seltrue();

#ifndef	ATR
int fdopen();
#endif

struct cdevsw cdevsw[] = {
	/* open		close		read		write
	  ioctl		stop		reset		tty
	  select	mmap		strategy */
/* 0-24 reserved to IBM */
	{ cnopen,	cnclose,	cnread,		cnwrite,	/*0*/
	  cnioctl,	nulldev,	nulldev,	&cons,
	  cnselect,	nodev,		NULL },
	{ asyopen,	asycloseX,	asyreadX,	asywriteX,	/*1*/
	  asyioctlX,	asystopX,	nulldev,	asy_tty,
	  asyselectX,	nodev,		NULL },
	{ syopen,	nulldev,	syread,		sywrite,	/*2*/
	  syioctl,	nulldev,	nulldev,	NULL,
	  syselect,	nodev,		NULL },
#ifdef ATR
	{ nulldev,	nulldev,	rawread,	rawwrite,	/*3*/
	  mmioctl,	nulldev,	nulldev,	NULL,
	  mmselect,	nodev,		mmstrategy },
#else
	{ nulldev,	nulldev,	mmrw,		mmrw,		/*3*/
	  nodev,	nulldev,	nulldev,	NULL,
	  mmselect,	nodev,		NULL },
#endif
	{ hdopen,	nulldev,	rawread,	rawwrite,	/*4*/
	  hdioctl,	nulldev,	nulldev,	NULL,
	  seltrue,	nodev,		hdstrategy },
	{ nodev,	nodev,		nodev,		nodev,		/*5*/
	  nodev,	nodev,		nodev,		NULL,
	  nodev,	nodev,		NULL },
	{ ptsopen,	ptsclose,	ptsread,	ptswrite,	/*6*/
	  ptyioctl,	ptsstop,	nodev,		pt_tty,
	  ttselect,	nodev,		NULL },
	{ ptcopen,	ptcclose,	ptcread,	ptcwrite,	/*7*/
	  ptyioctl,	nulldev,	nodev,		pt_tty,
	  ptcselect,	nodev,		NULL },
	{ lpopen,	lpclose,	nodev,		lpwrite,	/*8*/
	  nodev,	nulldev,	nodev,		NULL,
	  seltrue,	nodev,		NULL },
	{ nulldev,	nulldev,	rawread,	rawwrite,	/*9*/
	  nodev,	nodev,		nulldev,	NULL,
	  nodev,	nodev,		swstrategy },
	{ fdcopen,	fdcclose,	rawread,	rawwrite,	/*10*/
	  fdioctl,	nulldev,	nulldev,	NULL,
	  seltrue,	nodev,		fdstrategy },
	{ stopen,	stclose,	rawread,	rawwrite,	/*11*/
	  stioctl,	nulldev,	nulldev,	NULL,
	  seltrue,	nodev,		ststrategy },
	{ pspopen,	pspclose,	pspread,	pspwrite,	/*12*/
	  pspioctl,	pspstop,	nulldev,	psp_tty,
	  pspselect,	nodev,		NULL },
	{ busopen,	busclose,	nodev,		nodev,		/*13*/
	  nodev,	nodev,		nodev,		NULL,
	  nodev,	nodev,		NULL },
	{ spkopen,	spkclose,	nulldev,	spkwrite,	/*14*/
	  nulldev,	nulldev,	nulldev,	NULL,
	  seltrue,	nodev,		NULL },
	{ msopen,	msclose,	msread,		nodev,		/*15*/
	  msioctl,	nulldev,	nulldev,	ms_tty,
	  msselect,	nodev,		NULL },
	{ nodev,	nodev,		nodev,		nodev,		/*16*/
	  nodev,	nodev,		nodev,		NULL,
	  nodev,	nodev,		NULL },
	{ nodev,	nodev,		nodev,		nodev,		/*17*/
	  nodev,	nodev,		nodev,		NULL,
	  nodev,	nodev,		NULL },
	{ scsiopen,	nulldev,	scsiread,	scsiwrite,	/*18*/
	  scsiioctl,	nulldev,	nulldev,	NULL,
	  seltrue,	nodev,		scsistrategy },
	{ logopen,	logclose,	logread,	nodev,		/*19*/
	  logioctl,	nodev,		nulldev,	NULL,
	  logselect,	nodev,		NULL },
	{ asqopen,	asqcloseX,	asqreadX,	asqwriteX,	/*20*/
	  asqioctlX,	asqstopX,	nulldev,	asq_tty,
	  asqselectX,	nodev,		NULL },
	{ asxopen,	asxcloseX,	asxreadX,	asxwriteX,	/*21*/
	  asxioctlX,	asxstopX,	nulldev,	asx_tty,
	  asxselectX,	nodev,		NULL },
	{ psopen,	psclose,	psread,		pswrite,	/*22*/
	  psioctl,	nulldev,	nulldev,	NULL,
	  psselect,	nodev,		NULL },
	{ nodev,	nodev,		nodev,		nodev,		/*23*/
	  nodev,	nodev,		nodev,		NULL,
	  nodev,	nodev,		NULL },
	{ nodev,	nodev,		nodev,		nodev,		/*24*/
	  nodev,	nodev,		nodev,		NULL,
	  nodev,	nodev,		NULL },
/* 0-24 reserved to IBM */
	{ bpfopen,	bpfclose,	bpfread,	bpfwrite,	/*25*/
	  bpfioctl,	nodev,		nodev,		NULL,
	  bpfselect,	nodev,		NULL },
/* 25-39 reserved to local sites */
#ifndef	ATR
	{ fdopen,	nodev,		nodev,		nodev,		/*26*/
	  nodev,	nodev,		nodev,		NULL,
	  nodev,	nodev,		NULL },
#endif
/* Pertec CS240 streamer on a SCSI Adapter */
	{ csopen,	csclose,	rawread,	rawwrite,	/*27*/
	  csioctl,	nulldev,	nulldev,	0,
	  csselect,	nodev,		csstrategy },
/* Maxtor drive on a SCSI Adapter */
	{ xtopen,	nulldev,	rawread,	rawwrite,	/*28*/
	  xtioctl,	nulldev,	nulldev,	NULL,
	  seltrue,	nodev,		xtstrategy },
/* generic cd-rom on a SCSI Adapter */
	{ cdopen,	nulldev,	rawread,	rawwrite,	/*29*/
	  cdioctl,	nulldev,	nulldev,	NULL,
	  seltrue,	nodev,		cdstrategy },
/* logitech bus mouse */
        { lmsopen,      lmsclose,       lmsread,        nulldev,        /*30*/
          lmsioctl,     nulldev,        nulldev,        lms_tty,   /* lms */
          lmsselect,    nodev,		NULL },
};
int nchrdev = sizeof(cdevsw) / sizeof(cdevsw[0]);

int mem_no = 3;		/* major device number of memory special file */

/*
 * Swapdev is a fake device implemented
 * in sw.c used only internally to get to swstrategy.
 * It cannot be provided to the users, because the
 * swstrategy routine munches the b_dev and b_blkno entries
 * before calling the appropriate driver.  This would horribly
 * confuse, e.g. the hashing routines. Instead, /dev/drum is
 * provided as a character (raw) device.
 */
dev_t swapdev = makedev(4, 0);

/*
 * Routine that identifies /dev/mem and /dev/kmem.
 *
 * A minimal stub routine can always return 0.
 */
iskmemdev(dev)
	dev_t dev;
{
	switch (major(dev)){
	case 3:			/* memory devices */
		switch (minor(dev)){
		case 2:		/* /dev/null */
		case 6:		/* /dev/ros */
			return(0);
		default:
			return(1);
		}
#if 0
	case 13:		/* /dev/bus */
		return(1);
#endif
	default:
		return(0);
	}
	return(1); /* just in case */
}

/*
 * Routine to determine if a device is a disk.
 *
 * A minimal stub routine can always return 0.
 */
isdisk(dev, type)
	dev_t dev;
	int type;
{

#ifdef notyet
	/* someday, something like this, perhaps */
	dev = devtab[major(dev)];
	return (dev != NULL && dev->dv_class == DV_DISK);
#else
	switch (major(dev)) {
	case 13:	/* /dev/bus could be anything */
			return (1);
	case 1:		/* ESDI disks */
	case 7:		/* SCSI disks (via IBM adapter) */
	case 11:	/* SCSI disks (via Adaptec adapter) */
		if (type == VBLK)
			return (1);
		return (0);
	case 4:		/* ESDI disks */
	case 18:	/* SCSI disks (via IBM adapter) */
	case 28:	/* SCSI disks (via Adaptec adapter) */
		if (type == VCHR)
			return (1);
		/* fall through */

	default:
		return (0);
	}
#endif
}

/*
 * Routine that identifies devices which give I/O access
 *
 * A minimal stub routine can always return 0.
 */
isiodev(dev, type)
	dev_t dev;
	int type;
{
	switch (major(dev)) {
	case -1:	/* none at the moment */
		if (type == VBLK)
			return (1);
		return (0);
	case 13:	/* /dev/bus */
		if (type == VCHR)
			return (1);
		/* fall through */

	default:
		return (0);
	}
}

#define MAXDEV	31
static int chrtoblktbl[MAXDEV] =  {
      /* VCHR */      /* VBLK */
	/* 0 */		NODEV,
	/* 1 */		NODEV,
	/* 2 */		NODEV,
	/* 3 */		NODEV,
	/* 4 */		1,	/* ESDI Drives */
	/* 5 */		NODEV,
	/* 6 */		NODEV,
	/* 7 */		NODEV,
	/* 8 */		NODEV,
	/* 9 */		NODEV,
	/* 10 */	3,	/* Floppy Drive */
	/* 11 */	5,	/* Streaming Tape */
	/* 12 */	NODEV,
	/* 13 */	NODEV,
	/* 14 */	NODEV,
	/* 15 */	NODEV,
	/* 16 */	NODEV,
	/* 17 */	NODEV,
	/* 18 */	7,	/* SCSI Drives (IBM) */
	/* 19 */	NODEV,
	/* 20 */	NODEV,
	/* 21 */	NODEV,
	/* 22 */	NODEV,
	/* 23 */	NODEV,
	/* 24 */	NODEV,
	/* 25 */	NODEV,
	/* 26 */	NODEV,
	/* 27 */	10,	/* SCSI Tapes  (Adaptec) */
	/* 28 */	11,	/* SCSI Drives (Adaptec) */
	/* 29 */	12,	/* SCSI CD-ROM (Adaptec) */
	/* 30 */	NODEV,
};
/*
 * Routine to convert from character to block device number.
 *
 * A minimal stub routine can always return NODEV.
 */
chrtoblk(dev)
	dev_t dev;
{
	int blkmaj;

	if (major(dev) >= MAXDEV || (blkmaj = chrtoblktbl[major(dev)]) == NODEV)
		return (NODEV);
	return (makedev(blkmaj, minor(dev)));
}

/* Debugging switches -- may be patched during execution */

int
	aeddebug = 0,
	autodebug = 0,		  /* autoconfig debug */
	cndebug = 0,		  /* CONSOLE (mono/keybrd) debug */
	ecdebug = 0,
	fddebug = 0,	/* for floppy driver */
	fpadebug = 0,
	fsdebug = 0,		  /* Unix file system */
	hddebug = 0,
	indebug = 0,	/* interrupt system */
	iodebug = 0,		  /* low level i/o */
	mc881debug = 0,		  /* mc881 debugging flag */
	nfldebug = 0,
	padebug = 0,		  /* paging system */
	pspdebug = 0,		  /* psp ( planar async ) */
	svdebug = 0,		  /* svc traces */
	swdebug = 0,		  /* swapping system */
	sydebug = 0,		  /* syncronization */
	trdebug = 0,		  /* trap traces */
	vmdebug = 0,		  /* virtual memory */
#ifdef ATR
	pcdebug = 0,
	opdebug = 0,		  /* optical disk */
#endif ATR
	z = 0x01010101;	  /* end of debugging switches */

#ifdef ROROOT
dev_t rorootdev = ROROOT;  /* if root make it read-only */
#endif

#ifdef WAITFOR
int waitfor = 0;		/* normally wait for disk I/O to complete */
#else
int waitfor = 1;		/* normally wait for disk I/O to complete */
#endif WAITFOR
