/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/sys/rt/RCS/crcgen.c,v 1.1 1988/12/09 22:45:57 md Exp $ */
/* $ACIS:crcgen.c 12.0$ */
/* $Source: /usr/src/sys/rt/RCS/crcgen.c,v $ */

#ifdef IBMRTPC

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /usr/src/sys/rt/RCS/crcgen.c,v 1.1 1988/12/09 22:45:57 md Exp $";
#endif

#define crc_mask 0xff07

/*==================================================================
 * function name - crc_gen
 * Purpose:	- This function generates a 2 byte, 16 bit, crc
 *	value from the suppliced parameter data that is returned
 *	to the calling code.
 * Inputs	- 2,
 *	first is an array of byte, char, data.
 *	second is the length of bytes of the array.
 *
 * Outputs	- 1
 *	a 16 bit crc value returned to caller
 ===================================================================*/


crc_gen(pbuff,length)
char pbuff[];
int length;
{
	union accum {
	short whole;
	struct bytes {
		char msb;
		char lsb;
		} byte;
	} avalue, dvalue;
	short ret_crc;
	char datav;
	int i;

	dvalue.whole = 0xffff;

/*==================================================================
 *
 * operate on each byte of data in the passed array, sending the 
 * data through the algorithm to generate a crc. Then use the crc
 * just generated as the base for the next pass of the data thru 
 * the algorithm.
 *==================================================================*/

	for (i=0; length>0; i++, length--) {
		datav = *(pbuff+i);
		avalue.byte.lsb = (datav ^ dvalue.byte.lsb);
		dvalue.byte.lsb = avalue.byte.lsb;
		avalue.whole = ((avalue.whole * 16) ^ dvalue.byte.lsb);
		dvalue.byte.lsb = avalue.byte.lsb;
		avalue.whole <<= 8;

		avalue.whole >>= 1;
		avalue.byte.lsb ^= dvalue.byte.lsb;

		avalue.whole >>= 4;
		avalue.whole = combine(avalue.byte.lsb,avalue.byte.msb);
		avalue.whole = ((avalue.whole & crc_mask) ^ dvalue.byte.lsb);
		avalue.whole = combine(avalue.byte.lsb,avalue.byte.msb);
		avalue.byte.lsb ^= dvalue.byte.msb;
		dvalue.whole = avalue.whole;
	}

	ret_crc = dvalue.whole;
	return(ret_crc);
}

combine(byte1,byte2)
char byte1, byte2;
{
	short ret_value;

	ret_value = ((byte1 << 8) | byte2);
	return(ret_value);
}

#endif
