 /*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /sys/rt/rt/RCS/dkpart.c,v 1.5 1994/05/22 12:43:18 roger Exp $ */
/* $ACIS:dkpart.c 12.0$ */
/* $Source: /sys/rt/rt/RCS/dkpart.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /sys/rt/rt/RCS/dkpart.c,v 1.5 1994/05/22 12:43:18 roger Exp $";
#endif

/* $Header: /sys/rt/rt/RCS/dkpart.c,v 1.5 1994/05/22 12:43:18 roger Exp $ */
/* $ACIS:dkpart.c 12.0$ */

#include	<sys/param.h>
#include	<sys/vm.h>
#include	<sys/buf.h>
#include	<sys/time.h>
#include	<sys/proc.h>
#include	<sys/errno.h>
#include	"rt/include/pte.h"
#include	"rt/include/io.h"
#include	"rt/include/ioccvar.h"
#include	<sys/kernel.h>
#include	<sys/systm.h>
#include	<sys/cmap.h>
#include	<sys/uio.h>
#include	<sys/ioctl.h>
#include	"rt/dev/hdconfig.h"
#include	"rt/include/dkio.h"
#include	"rt/include/mmu.h"
#include	"rt/rt/debug.h"


/*
 * look in VRM minidisk directory for minidisks of
 * the appropriate name (hd?[a-h])
 * and build hdoff[unit][0-7]
 * entries for the given partitions.
 * this code is used by hd.c (ATR), hd.c and scsi.c (ca)
 * and the standalone code.
 * we bump up the start of a partition to the next cylinder, except for the
 * 'a' partition if its within 16 blocks as 4.3 reserves the first 16 blocks.
 * This allows the use of all of a PS/2 ESDI disk, which otherwise as almost
 * 1mb not accessable.
 */
dkfindpart(minidirectory, off, cylsize, offset, un, hd)
	struct minidirectory *minidirectory;
	struct partab *off;
	int	cylsize,		/* the size of a cylinder */
		offset,			/* offset from start of disk */
		un;			/* the unit (for printfs) */
	char    hd[2];			/* name prefix */
{
	int n, next;
	struct minidisk *disk;
	int found = 0, cnt;

	if(minidirectory->header.number <= 0 ||
			minidirectory->header.number >= MAXDISKS) 
		return(0);		/* not valid */
	cnt = minidirectory->header.number;
	for (next = minidirectory->header.first; next >= 0; next = disk->next) {
		if (--cnt < 0 || next > MAXDISKS)
			return(0);	/* directory corrupted */
		disk = &minidirectory->minidisk[next];
		if (ISFREE(disk))
			continue;	/* skip free space */
		n = disk->name[3]-'a';	/* get partition number */
		if (disk->name[0] == hd[0] && disk->name[1] == hd[1] && n >= 0 &&
			n < NPART ||
		    /* now if it's AIX paging space make it 'b' partition */
		    disk->type == TYPE_PAGE && (n = 1) != 0) {
			++found;
			if (off[n].len != 0) {
				DEBUGF(hddebug&SHOW_CONFIG, printf("%s%d: can't redefine %c partition - minidisk entry ignored\n", hd, un,  n+'a'));
				continue;
			}
			if (n == 0 && disk->start%cylsize <= 16)
				off[n].start = disk->start/cylsize;
			else
				off[n].start = (disk->start + cylsize - 1)/cylsize;
			off[n].len = disk->size - (off[n].start*cylsize - disk->start);
			off[n].start +=  offset;
			DEBUGF(hddebug&SHOW_CONFIG, printf("%s%d%c: start %d size %d\n",hd,un,n+'a',off[n].start,off[n].len));
		}
	}
	return(found);
}
