/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
 /* $Header: /sys/rt/rt/RCS/vmaccess.c,v 1.4 1994/05/22 12:41:21 roger Exp $ */
 /* $ACIS:vmaccess.c 12.0$ */
/* $Source: /sys/rt/rt/RCS/vmaccess.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /sys/rt/rt/RCS/vmaccess.c,v 1.4 1994/05/22 12:41:21 roger Exp $";
#endif

/*     vmcopy.c    84/03/30        */

#include <sys/param.h>
#include "rt/rt/debug.h"
#include <machine/pte.h>
#include <machine/mmu.h>
#include <sys/buf.h>
#include <sys/errno.h>

/****************************************************************************
  useracc - verify user access to virtual memory
 ****************************************************************************/
useracc(vaddr, length, rw)
	register caddr_t vaddr;
	register length;
	register rw;
{
	return (isitok(vaddr, length, (rw == B_READ ? UREAD_OK : UWRITE_OK)));
}


/****************************************************************************
  kernacc - verify kernel access to virtual memory
 ****************************************************************************/
kernacc(vaddr, length, rw)
	register caddr_t vaddr;
	register length;
	register rw;
{
	return (isitok(vaddr, length, (rw == B_READ ? KREAD_OK : KWRITE_OK)));
}


/****************************************************************************
  fubyte - fetch byte from user data space
 ****************************************************************************/
fubyte(vaddr)
	register char *vaddr;
{
	return (isitok(vaddr, 1, UREAD_OK) ? *vaddr : -1);
}


/****************************************************************************
  fuibyte - fetch byte from user instruction space, see #define fuibyte in
  ../machine/machparam.h 
 ****************************************************************************/


/****************************************************************************
  fuword - fetch word from user data space
  if the word is not aligned on a word boundary return error indication
  as most likely the user-level code is using non-aligned memory allocator
  and this will make it easier to find.
 ****************************************************************************/
fuword(vaddr)
	register unsigned *vaddr;
{
	if ((int)vaddr & 3)
		return (-1);
	return (isitok(vaddr, 4, UREAD_OK) ? *vaddr : -1);
}


/****************************************************************************
  fuiword - fetch word from user instruction space, see define in
  ../machine/machparam.h
 ****************************************************************************/


/****************************************************************************
  subyte - set byte in user data space
 ****************************************************************************/
subyte(vaddr, value)
	register char *vaddr;
	register char value;
{
	if (isitok(vaddr, 1, UWRITE_OK)) {
		*vaddr = value;
		return (0);
	} else
		return (-1);
}


/****************************************************************************
  suibyte - set byte in user instruction space, see define in ../machine/machparam.h
 ****************************************************************************/


/****************************************************************************
  suword - set word in user data space
  (see alignment comments in fuword)
 ****************************************************************************/
suword(vaddr, value)
	register unsigned *vaddr;
	register unsigned value;
{
	if ((int)vaddr & 3)
		return (-1);
	if (isitok(vaddr, 4, UWRITE_OK)) {
		*vaddr = value;
		return (0);
	} else
		return (-1);
}


/****************************************************************************
  suiword - set word in user instruction space, see define in ../machine/machparam.h
 ****************************************************************************/

/****************************************************************************
  copyin - copy from user data space to kernel data space
 ****************************************************************************/
copyin(from, to, length)
	register caddr_t from, to;
	register unsigned length;
{
	if (isitok(from, length, UREAD_OK)) {
		bcopy(from, to, length);
		return (0);
	} else
		return (EFAULT);
}


/****************************************************************************
  copyout - copy from kernel data space to user data space
 ****************************************************************************/
copyout(from, to, length)
	register caddr_t from, to;
	register unsigned length;
{
	if (isitok(to, length, UWRITE_OK)) {
		bcopy(from, to, length);
		return (0);
	} else
		return (EFAULT);
}
