#include <stdio.h>
#include <sys/types.h>
#include "rt/dev/hdconfig.h"

main()
{
	struct boothdr hdr;

	if (read(0, &hdr, sizeof(struct boothdr)) != sizeof(struct boothdr)) {
		fprintf(stderr, "short read\n");
		perror();
		exit(1);
	}
	printf("boot_check	 %x\n", hdr.boot_check);
	printf("boot_lastcyl	 %d\n", hdr.boot_lastcyl);
	printf("boot_lasttrack	 %d\n", hdr.boot_lasttrack);
	printf("boot_lastsect	 %d\n", hdr.boot_lastsect);
	printf("boot_sectorsize	 %d\n", hdr.boot_sectorsize);
	printf("boot_interleave	 %d\n", hdr.boot_interleave);
	printf("boot_sectorcount %d\n", hdr.boot_sectorcount);
	printf("boot_formatdate	 %x\n", hdr.boot_formatdate);
	printf("boot_cyl	 %d\n", hdr.boot_cyl);
	printf("boot_track	 %d\n", hdr.boot_track);
	printf("boot_sector	 %d\n", hdr.boot_sector);
	printf("boot_length	 %d\n", hdr.boot_length);
	printf("boot_entry	 %d\n", hdr.boot_entry);
	printf("boot_vrmminidisk %x\n", hdr.boot_vrmminidisk);
	printf("boot_llp	 %x\n", hdr.boot_llp);
	printf("boot_vrmlength	 %x\n", hdr.boot_vrmlength);
	printf("boot_ibma	 %02x %02x %02x %02x\n", hdr.boot_ibma[0],
	  hdr.boot_ibma[1], hdr.boot_ibma[2], hdr.boot_ibma[3]);
	printf("boot_reserved1	 %02x %02x %02x %02x\n", hdr.boot_reserved1[0],
	  hdr.boot_reserved1[1], hdr.boot_reserved1[2], hdr.boot_reserved1[3]);
	printf("boot_reserved2	 %02x %02x %02x\n", hdr.boot_reserved2[0],
	  hdr.boot_reserved2[1], hdr.boot_reserved2[2]);
}
