/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /sys/rt/stand/RCS/debug.h,v 1.4 1994/05/22 13:06:13 roger Exp $ */
/* $ACIS:debug.h 12.0$ */
/* $Source: /sys/rt/stand/RCS/debug.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsiddebug = "$Header: /sys/rt/stand/RCS/debug.h,v 1.4 1994/05/22 13:06:13 roger Exp $";
#endif

int debug_option;			/* option flags */
#define OPTION_TRACE_TABLE 0x20		/* use trace table */
int debug_state;		       /* the current state of debug */
#define NORMAL_STATE	0	       /* we are just executing commands */
#define PCHECK_STATE	PC_VEC	       /* we've just had a program check */
#define MCHECK_STATE	MC_VEC	       /* we've just had a machine check */
#define STEP_STATE	INT0_VEC       /* we've just finished a step */
#define CALL_STATE	PROG_VEC       /* fake interrupt vector */
#define PM_STATE	PM_VEC		/* post mortem debugging */

#define REGSAVE 0x300		       /* put it somewhere safe */
#define GETREG(n) ((int *) regsave)[n]	/* pick up register value */

int *regsave;				/* pointer to saved registers */

/* note: currently the debug stack must be in low memory ( < 0x8000) */
#define DEBUG_STACK 0x2000	       /* used when in debugger from trap */
#define STM_R0	0xd900		       /* at stm r0, ... */
#define LM_R0	0xc900		       /* lm r0,... */
#define LPS	0xd000		       /* lps 0, ... */
#define CAL_R1	0xc810		       /* cal r1, ... */


#define INT0_VEC 0x100		       /* first interrupt vector */
#define MC_VEC 0x170		       /* machine check vector */
#define PC_VEC 0x180		       /* program check vector */
#define SVC_VEC	0x190		       /* svc vector */
#define PROG_VEC 0x1a0		       /* programmed entry */
#define PM_VEC	0x1b0			/* simulated vector for post mortem */

#define MAX_VEC	11		       /* number of interrupt vectors */

struct ivec {
	short *old_iar;
	short old_ics;
	short old_cs;
	short *new_iar;
	short new_ics;
	short new_fill;
};

struct svec {
	short *new_iar;
	short new_ics;
	short new_fill;
} save_vec[MAX_VEC];		       /* saved interrupt vectors */

typedef int (*FN)();

int step_count;			       /* count for step instructions */

#define IRQ_0	0x8000		       /* IRQ 0 */
#define IRQ_1	0x4000		       /* IRQ 1 */
#define IRQ_2	0x2000		       /* IRQ 2 */
#define IRQ_3	0x1000		       /* IRQ 3 */
#define IRQ_4	0x0800		       /* IRQ 4 */
#define IRQ_5	0x0400		       /* IRQ 5 */
#define IRQ_6	0x0200		       /* IRQ 6 */
/*
 * following are simulated IRQ's as a way of telling init_vectors what
 * vectors to initialize.
 */
#define IRQ_MC	0x0100		       /* IRQ MC  */
#define IRQ_PC	0x0080		       /* IRQ PC  */
#define IRQ_SVC	0x0040		       /* IRQ SVC */
#define IRQ_PG	0x0020		       /* IRQ PROG if it existed */

#define ALL_IRQ	0xffff		       /* all vectors by bit flags */
#define DEBUG_IRQ IRQ_0 + IRQ_MC + IRQ_PC + IRQ_PG /* for debugger */

#define CODE_ADDR 0x280

#define USER_ICS	0x87	       /* don't stop, priority 7 */

#define TRACE_BIT	0x10	       /* T bit in LPS T,addr */

#include "rt/include/mmu.h"

#define MAX_BREAK	16	       /* max number of break points */
#define BPT	0xbd11		       /* a break point (TGTE R1,R1) */

#define MAXSYMLEN 8

/*
 * NOTE: last symbol table entry must have a 'symbol[0] == 0'
 * in order to properly terminate the symbol table lookups.
 */
struct symtab {
	char symbol[MAXSYMLEN];	       /* the symbol */
	unsigned int value;	       /* it's value */
} *symtab;			       /* and a pointer to it */

#define ALLSYMS(s) s=symtab; s && s->symbol[0]; ++s

int err_flag;			       /* debugger error flag */
int iar_mask;			       /* mask for iar */

#define PROBLEM_ICS	0x0400	       /* problem state */
#define TRANS_ICS	0x0200	       /* translation mode */
#define NOINT_ICS	0x0100	       /* inhibit interrupts */

#include "rt/include/trap.h"

#ifdef ROMPC
#include "rt/include/ioim.h"
#endif ROMPC
