/* $Header: /sys/rt/stand/RCS/hfetch.s,v 1.3 1994/05/22 13:06:13 roger Exp $ */
/* $ACIS:hfetch.s 12.0$ */
/* $Source: /sys/rt/stand/RCS/hfetch.s,v $ */

	.data
rcsid:	.asciz	"$Header: /sys/rt/stand/RCS/hfetch.s,v 1.3 1994/05/22 13:06:13 roger Exp $"
	.text

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#define LOCORE
#include "asm.h"



 #
 # fetch half-word from memory and return it in r0
 # value == -1 if address does not respond
 # r2 = address to fetch from
 #
 #PROG_CHK = 0x180
 #save	=	0x200
	.set PROG_CHK , 0x180
	.set save , 0x200
eye_profil(hfetch):
	bali	r4,1f
1:	.using	1b,r4
 # save the current contents of 188 + 18c into 200 and 204
	l	r3,PROG_CHK+8(r0)	# get old value
	st	r3,save(r0)		# save into tmp location
	l	r3,PROG_CHK+12(r0)	# get old value
	st	r3,save+4(r0)	# save into tmp location
 # load new contents into 188 and 18c
	cal	r0,prog_chk
	st	r0,PROG_CHK+8(r0)	# set new value
	cau	r0,0x0180(r0)	# get proper new ics
	st	r0,PROG_CHK+12(r0)	# and store it too
 # save ECR over exception (for APC)
	mfs	scr_ecr,r5
 # clear r0 and load the value from memory into it
	s	r0,r0
	lhs	r0,0(r2)	# get value from storage
 # following is to force the program check to occur here
 # rather than sometime later
	c	r0,r0	# force cpu to wait for load to complete
 # restore the vector to it's original state
return:	l	r3,save(r0)
	st	r3,PROG_CHK+8(r0)	# restore program check address
	l	r3,save+4(r0)
	st	r3,PROG_CHK+12(r0)
	mts	scr_ecr,r5	# restore ECR
	cas	RETREG,r0,r0	# make sure value is in correct register
	br	r15		# and return
 # come here if we get a program check
prog_chk:
#ifdef ROMPC
#include "rt/include/cpu.h"
#include "rt/include/trap.h"
#include "rt/include/ioim.h"
 # if we are running on ROMPC and RTPC then we need to read the IOIM if the bad
 # address was in segment f
	sri16	r2,28-16	# get top 4 bits of address
	ci	r2,0x0f		# is it segment f?
	jne	0f		# nope, do normal stuff
 # test if ROMPC processer
	.globl	_cpu_model
#ifdef MOD135
	cis	r2,CPU_SGP	# is it SGP?
	jeq	0f		# yes
#else
	load	r2,_cpu_model	# get the model number
	cis	r2,CPU_ROMPC	# is it ROMPC?
#endif MOD135
	jne	0f		# nope
 # test if RTPC (which has IOIM1)
	.globl	_cpu
	load	r2,_cpu		# get the machine type
	cis	r2,CPU_RTPC	# is it RTPC?
	jne	0f		# nope
 # we know that we have a IOIM so read the General Status Register
	get	r2,$IOIM1_BASE	# get base address of IOIM1
	ior	r2,0(r2)
	nilz	r2,r2,0xff	# get RCS part of it
	sli16	r2,16-16	# get into proper place
	ior	r2,IOIM_GSR(r2)	# read the status register
	st	r2,save+12(r0)	# save the GSR 
0:
#endif ROMPC
	mfs	r11,r0		# get mcpc
	st	r0,save+8(r0)
	cal	r0,return	# get return address
	st	r0,PROG_CHK(r0)
	cal	r0,-1(r0)		# get -1 
	lps	0,PROG_CHK(r0)	# and resume execution

eye_profil(bfetch):
	brx	r15
	lc	RETREG,0(r2)	# get byte and return

eye_profil(wfetch):
	brx	r15
	l	RETREG,0(r2)	# get word and return

eye_profil(hstore):
	brx	r15
	sth	r3,0(r2)	# get byte and return

eye_profil(bstore):
	brx	r15
	stc	r3,0(r2)	# get byte and return

eye_profil(wstore):
	brx	r15
	st	r3,0(r2)	# get word and return

