/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /sys/rt/stand/RCS/init.c,v 1.3 1994/05/22 13:06:13 roger Exp $ */
/* $ACIS:init.c 12.0$ */
/* $Source: /sys/rt/stand/RCS/init.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /sys/rt/stand/RCS/init.c,v 1.3 1994/05/22 13:06:13 roger Exp $";
#endif


#include "rt/include/cpu.h"

#ifdef ATR

#include "sa.h"
#include "../rt_atr/pcif.h"	 /* for pcif_reg structure definition */
#include "../rt/cpu.h"

extern ushort *pcif_base;
extern long cbcb_addr;
extern char *pcvec_map;
extern struct cbcb *cbcb;
extern struct pcif_reg *pcif_reg;
extern long sv_pc_cb;

/*  
 * 	For the time being we will rely on the AT to set up 
 *	the display, keyboard, dma, and interrupt registers
 *      for us.
 */

#endif ATR


#ifdef IBMRTPC
#include "init.h"
#include "8530.h"

#define IOW_B(value,port) * (char *) (port) = value
#define IOW_H(value,port) * (short *) (port) = value
#define IOW_W(value,port) * (int *) (port) = value
#endif IBMRTPC

_init()
{
#ifdef IBMRTPC
	register int p;
	static char regdata[16] = {
		0x61, 0x50, 0x52, 0x0F, 0x19, 0x06, 0x19, 0x19,
		0x02, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00
	};
	register int i;
	static clear_screen = 1;       /* if we must clear the screen */
#endif IBMRTPC
#ifdef ATR
		cbcb = (struct cbcb *)(set_512_window(cbcb_addr)+pcif_512_fw);
		pcif_reg = (struct pcif_reg *)(*pcif_base + pcif_io_b); 
		sv_pc_cb = cbcb->cbcb_ent[SVENT].pc_cb;
		pcvec_map = (char *)(set_512_window(sv_pc_cb) + pcif_512_fw);
		SETBIT(&pcif_reg->romp_ctrl,R_IENAB); /* enable ROMP to PC */
						      /* interrupt DTC 1/29 */
		return;
#endif ATR

#ifdef IBMRTPC
/* ***************************************************************** */
/* The purpose of this module is to initialize the hardware          */
/*                                                                   */
/* ***************************************************************** */

	IOW_B(0xff, CRRA);
	IOW_B(0xff, CRRB);

/* Initialize PC mono to make sure horizontal oscillator is running. */
	IOW_B(0x01, MonoCtl);	       /*  Set hi res bit.         */
	/*    enable bits,  cport 1 */
	for (i = 0; i <= 15; i += 1) { /*  Init 16  control regs   */
		IOW_B(i, MonoInx);     /*  Set cursor to up.left   */
		IOW_B(regdata[i], MonoData);
	}
	if (clear_screen) {
		clear_screen = 0;      /* only do it once */
		for (p = MonoBase; p < MonoBase + 4000; p += 4) {
			/*  Clear display to blanks */
			IOW_W((' ' << 24) + (' ' << 8) + 0x00070007, p);
		}
	}
	IOW_B(0x09, MonoCtl);	       /*  Set hi res bit, video   */
#ifdef ROMPC
#ifdef MOD135
	if (cpu_model == CPU_ROMPC || cpu_model == CPU_MOD135)
#else  MOD135
	if (cpu_model == CPU_ROMPC)
#endif MOD135
		init_ioims(cpu_model);	/* initialize the ioims */
#endif ROMPC
	{	/*
		 * Read disk adapter status registers to absorb
		 * interrupt(s) sometimes left outstanding by ROS.
		 */
		char junk = *(volatile char *)0xf00001f7 +
			    *(volatile char *)0xf0000177;
		junk = junk;
	}
#endif IBMRTPC
}

#ifdef IBMRTPC
#ifdef ROMPC
#include "rt/include/ioim.h"
init_ioims(cpu_model)
int cpu_model;
{
	iow(IOIM1_BASE, (BUS1 << 8) + (IOIM1 >> 16));	/* initialize IOIM 1 */
	/* for now disable parity (chips don't work at 100ns) */
	iow(IOIM1+IOIM_GCR, ior(IOIM1+IOIM_GCR) |  IOIM_NOPARITY);
#ifdef MOD135
	if (cpu_model != CPU_MOD135)
#endif MOD135
	iow(IOIM2_BASE, (BUS2 << 8) + (IOIM2 >> 16));	/* initialize IOIM 2 */
}
#endif ROMPC
#endif IBMRTPC

