#! /bin/sh
#$Header: /usr/src/sys/rtstand/RCS/installboot.sh,v 1.2 1993/01/15 17:32:19 md Exp $
#$ACIS:installboot.sh 12.0$
#$Source: /usr/src/sys/rtstand/RCS/installboot.sh,v $
#
# Usage: installboot bootblock bootprog device
#
DIR=/usr/mdec
case $# in
3)
	;;
*)
	echo "Usage: installboot bootblock bootprog device"
	echo "	device should be the 'c' partition"
	echo "  block should be one of"
	ls ${DIR}/hd[1-9][0-9][rcmeh]boot ${DIR}/hd[1-9][0-9][0-9][rcmeh]boot
	echo "  bootprog should be one of"
	ls ${DIR}/boot??
	exit 1
	;;
esac

block=$1
prog=$2
device=${3-/dev/hd0c}
case $device in
/dev/rhd?a|/dev/hd?a)
	device=`expr $device : '\(/dev/.*\)a'`c
	;;
esac
case $device in
/dev/rhd?c|/dev/hd?c)
#	set seek to 4 tracks (sectors/track * 4)
	case "$block" in
	*hd40r*|*hd70c*|*hd70m*)
		seek=68
		;;
	*hd70r*|*hd442c*)
		seek=144
		;;
	*hd70e*|*hd114e*)
		seek=140
		;;
	*hd227e*|*hd310e*)
		seek=132
		;;
	*hd310h*)
		seek=136
		;;
	*)
		echo "$0: block ($block) should be one of:"
		ls ${DIR}/hd[1-9][0-9][rcmeh]boot ${DIR}/hd[1-9][0-9][0-9][rcmeh]boot
		exit 1
		;;
	esac
	;;
/dev/rfd?|/dev/fd?)
	seek=2368
	;;
*)
	echo "For now, you can only $0 on /dev/hd?[ac] or /dev/fd?"
	exit 1
	;;
esac
if dd if=$block bs=1b of=$device count=1 &&
	dd if=$prog bs=1b of=$device count=33 seek=$seek
then
	echo "bootstrap written into $device"
fi
exit 0
