/*
   mkbrec.c - build a boot record for the RT for various ESDI disks
		Mark Dapoz
*/

#include <stdio.h>
#include <sys/types.h>
#include "rt/dev/hdconfig.h"

main(argc, argv)
int argc;
char **argv;
{
	extern char *optarg;
	extern int optind;
	int ch;

	char *progname=argv[0];
	char *model=NULL;
	int pcyl=0, hd=0, sec=0;

	while ((ch = getopt(argc, argv, "m:c:h:s:")) != EOF) {
 	    switch(ch) {
		case 'm':
			model=optarg;
			break;
		case 'c':
			pcyl=atoi(optarg);
			break;
		case 'h':
			hd=atoi(optarg);
			break;
		case 's':
			sec=atoi(optarg);
			break;
		case '?':
		default:
			usage(progname);
			exit(0);
	    }
	}
	argc -= optind;
	argv += optind;
	if ((model != NULL && (pcyl || hd || sec)) || 
	    (model == NULL && (!pcyl && !hd && !sec))) {
		usage(progname);
		exit(0);
	}
	if (model != NULL) {
		if (!strcmp(model, "hd114e"))
			mk_boot_rec(915, 7, 35, 0, 0xb4, 0, 0, 1);  /* hd114e */
		else if (!strcmp(model, "hd70e"))
			mk_boot_rec(583, 7, 35, 2, 0x30, 0, 0, 1);  /* hd70e */
		else if (!strcmp(model, "hd70r"))
			mk_boot_rec(566, 7, 36, 0, 0, 0, 0, 0);     /* hd70r */
		else if (!strcmp(model, "hd310h"))
			mk_boot_rec(1189, 15, 34, 1, 9, 0, 0, 1);   /* hd310h */
		else if (!strcmp(model, "hd310e"))
			mk_boot_rec(1225, 15, 33, 1, 0x2c, 0, 0, 1);/* hd310e */
		else if (!strcmp(model, "hd442c"))
			mk_boot_rec(1412, 15, 36, 0, 0, 0, 0, 1);   /* hd442c */
		else {
			models();			/* unknown */
			exit(0);
		}
	} else
		mk_boot_rec(pcyl, hd, sec);		/* user specified */
}

usage(cmd)
char *cmd;
{
    fprintf(stderr, "%s: [-m model] | [ -c num_cyl -h num_hd -s num_sec ]\n", cmd);
}

models()
{
    fprintf(stderr, "Only the following disk models are known: hd70e hd70r hd114e hd310h\n");
    fprintf(stderr, "                                          hd310e hd442c\n");
}

mk_boot_rec(pcyl, hd, sec, r11, r12, r13, r14, r21)
int pcyl, hd, sec;		/* disk geometry */
short r11, r12, r13, r14, r21;	/* misc reserved values */
{
	struct boothdr hdr;

	bzero(&hdr, sizeof(struct boothdr));

	hdr.boot_check=0x459;		/* constant for ESDI disks */
	hdr.boot_lastcyl=pcyl-2;
	hdr.boot_lasttrack=hd-1;
	hdr.boot_lastsect=sec;
	hdr.boot_sectorsize=512;	/* constant for ESDI disks */
	hdr.boot_interleave=0;		/* mostly constant */
	hdr.boot_sectorcount=(pcyl-1)*hd*sec;
	hdr.boot_formatdate=0;
	hdr.boot_cyl=0;			/* constant */
	hdr.boot_track=4;		/* constant for ESDI disks */
	hdr.boot_sector=1;		/* constant */
	hdr.boot_length=(hd-hdr.boot_track)*sec+15;
	hdr.boot_entry=0;
	hdr.boot_vrmminidisk=0;
	hdr.boot_llp=0;
	hdr.boot_vrmlength=0;

	hdr.boot_ibma[0]=0xc9;		/* IBMA in ebcdic */
	hdr.boot_ibma[1]=0xc2;
	hdr.boot_ibma[2]=0xd4;
	hdr.boot_ibma[3]=0xc1;

	hdr.boot_reserved1[0]=r11;	/* not sure what these are */
	hdr.boot_reserved1[1]=r12;
	hdr.boot_reserved1[2]=r13;
	hdr.boot_reserved1[3]=r14;

	hdr.boot_reserved2[0]=r21;	/* constant? */
	hdr.boot_reserved2[1]=0x00;
	hdr.boot_reserved2[2]=0x00;

	write(1, &hdr, sizeof(struct boothdr));
}
