/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header: /usr/src/sys/rtstand/RCS/mpeltty.c,v 1.2 91/07/08 20:56:17 rayan Exp $ */
/* $ACIS:mpeltty.c 12.0$ */
/* $Source: /usr/src/sys/rtstand/RCS/mpeltty.c,v $ */


#ifndef lint
static char *rcsid = "$Header: /usr/src/sys/rtstand/RCS/mpeltty.c,v 1.2 91/07/08 20:56:17 rayan Exp $";
#endif

/*
 * This file contains all the routines written for the MEGAPEL console driver.
 * These routines initialize the queue area, load the font into the hidden
 * font area of the MEGAPEL, write characters to the screen with underline,
 * bold and reverse video as attributes, position the cursor, blank the screen,
 * and move the screen.
 */

#include "mpel.h"
#if NMPEL > 0

/*
 * -D line defines
 */
#define NOBLINK

#ifdef DEBUG
#define MPELDEBUG
#define LOCAL
#else DEBUG
#define LOCAL	static
#endif DEBUG

#define NULL 0

#include "types.h"

#include "screen_conf.h"
#include "mpeltty.h"
#define TRUE 1
#define FALSE 0

#ifdef LOAD_UCODE
extern short mpel_circle_table[];
extern int mpel_circ_size;
extern short mpel_sine_table[];
extern int mpel_sine_size;
extern short mpel_marker_loc[];
extern int mpel_marker_size;
extern short mpel_hatch_table[];
extern int mpel_hatch_size;
extern short mpel_marker_font[];
extern int mpel_mfont_size;
extern short mpel_mcode[];
extern int mpel_mcode_size;
#include "mpeltty_font.h"
#endif LOAD_UCODE

#define mpelrd(X,Y,Z)	bcopy(MODEL_IO_ADDR+Z, X, Y)
#define mpelwr(X,Y,Z)	bcopy(X, MODEL_IO_ADDR+Z, Y)


/*
 * The cursor bitmap
 */
static unsigned short cursor[] = {
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,
  0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555,0x5555};

static struct ColorTable {
	unsigned short start;
	unsigned short count;
	unsigned int rgb[16];
} CTable = {
	0x0000,
	0x0010,
	0x00000000,	/* black */
	0x00d0d0d0,	/* white */
	0x00f00000,	/* red */
	0x00f0f000,	/* yellow */
	0x000070f0,	/* light blue */
	0x0000f000,	/* green */
	0x000000f0,	/* blue */
	0x00b000b0,	/* magenta */
	0x0000f0f0,	/* cyan */
	0x00404040,	/* gray */
	0x0070f000,	/* light green */
	0x00c08020,	/* brown */
	0x00f04040,	/* light red */
	0x00e030e0,	/* light magenta */
	0x0070f0d0,	/* light cyan */
	0x00f0f0f0	/* high intensity white */
};

/*
 * Removing and writing the cursor functions are now macros.
 */
LOCAL short mpelcursorflag;		/* 1 = on screen, 0 = off screen */
#define CURSOR_OFF (mpelcursorflag == FALSE)
#define CURSOR_ON (mpelcursorflag == TRUE)
#define SET_CURSOR  (mpelcursorflag = TRUE)
#define RESET_CURSOR (mpelcursorflag = FALSE)


LOCAL  short mpel_ucode_loaded;
static short mpel_cursor_x, mpel_cursor_y;	/* cursor position */

#define MPELREMOVE_CURSOR() 	{					\
	if (CURSOR_ON) {						\
		RESET_CURSOR;						\
		mpelxor_cursor(mpel_cursor_x,mpel_cursor_y);		\
	}								\
}
#define MPELWRITE_CURSOR()	{					\
	if (CURSOR_OFF) {						\
		SET_CURSOR;						\
		mpelxor_cursor(mpel_cursor_x,mpel_cursor_y);		\
	}								\
}

/*
 * Put a cursor in the hardware locator area.
 */
LOCAL unsigned short mpcurpars[5] =		/* make it STATIC */
{
	0x0044,	/* word 1: cursor control word */
	0x00f0,	/* words 2-3: cursor color */
	0xf0f0,	/*	high intensity white */
	0x0100,	/* words 4-5: pointer to 64x64 pixel array */
	0x807c
};

/*
 * print screen buffer
 */
char	mpel_screen_buffer[MPEL_COLUMNS*MPEL_ROWS];
int	mpel_buf_pointer;

/*
 * If the MEGAPEL is out there then we return TRUE.
 */
mpel_probe(addr)
unsigned short *addr;
{
	unsigned short tmp;

	tmp = *addr;

	/*
	 * Test to see if the MEGAPEL is there.
	 */
	*(char *)addr = 0x0F;
	if (*(char *)addr != 0x0F) {
		return(FALSE);
	}

	/*
	 * Since we found the screen restore the spot just changed.
	 */
	*addr = tmp;
	return(TRUE);
}


LOCAL
mpelinit_reg()
{

	/*
	 * Place the adapter into HOLD and RESET state
	 */
	SET_TMS_BIT;
	SET_HOLD_BIT;

	/*
         * Poll Not Hold Ack until NotHoldAck goes to 0
         */
	while (*(unsigned short*)(PSR_R) & PSR_NOTHOLD_BIT) ;

	/*
	 * Set Byte order Select for the RT PC
	 */
	SET_SELECT_BIT;

	/*
	 * Disable Interrupts and DMA
	 */
	DISABLE_INTERRUPT;
	DISABLE_DMA;
}

LOCAL
mpel_clear_all()
{
struct  FILLRECT_elem {
		unsigned short header_l;
		unsigned short header_r;
		short lleft_x, lleft_y;
		short uright_x,uright_y;
               } FILLRECT;

struct FILLCOLOR_elem {
		unsigned short header_l;
		unsigned short header_r;
                unsigned short color;
		} FILLCOLOR;

   FILLCOLOR.header_l = 0x0006;
   FILLCOLOR.header_r = 0x5053;
   FILLCOLOR.color = 0;

   FILLRECT.header_l = 0x000c;
   FILLRECT.header_r = 0x5004;
   FILLRECT.lleft_x  = 0;
   FILLRECT.lleft_y  = 0;
   FILLRECT.uright_x = 1023;
   FILLRECT.uright_y = 1023;
   
   wfifo(&FILLCOLOR, 3);
   wfifo(&FILLRECT, 6);
   bzero(mpel_screen_buffer,MPEL_COLUMNS*MPEL_ROWS);
}

#ifdef LOAD_UCODE
LOCAL
mpelclear_areas()
{
	register unsigned short *scr;

	/*
	 * Zero out data space
	 */
	scr = (unsigned short *)DATA_BASE;
	while (scr <= (unsigned short *)DATA_END)
		*scr++ = 0;

	/*
	 * Zero out program space
	 */
	scr = (unsigned short *)PGM_BASE;
	while (scr <= (unsigned short *)PGM_END)
		*scr++ = 0;
}


/*
 * Hardware init -- start on command of user program
 */
LOCAL
mpel_hw_init()
{
	/*
	 * Initialize MEGAPEL registers
	 */
	mpelinit_reg();

	/*
	 * Zero out all of MEGAPEL memory
	 */
	mpelclear_areas();

	/*
	 * Set up COMM Area pointer
	 */
	SET_COMM_AREA;

	/*
	 * Initialize the COMM Area
         * 
	 */

	/*
         * Set up Pointer to Annotation Text Font Location Table
         * at 0xc00920.
         */ 
	SET_ATF_POINTER;

	/*
         * Set Up Annotation Text Font Table (ADAPTER ADDRESSES !!! )
	 * 0001(count) 0001(Font ID) 0300 8000 (Font address)
         */
	SET_ATF_COUNT;
	SET_ATF_FONTADDR;
}



LOCAL
mpel_start()
{

	int i, retry;		/* DEBUGGING */
	struct ctab {
		unsigned short	start;
		unsigned short	count;
		unsigned int	color;
	} ctab = { 255 , 1, 0x00f0f0f0 }; /* load 255 with white */

         
        /*
	 * Start the MEGAPEL Adapter Processor
	 */
	RESET_TMS_BIT;
	RESET_HOLD_BIT;

	/*
         * Check for reason code of 0x0001, clear it.
         */
	retry = 0;
	while (retry < MAXRETRY) {
		if (*(unsigned short*)DAAP_REASON == 0x0001) {
			break;
		}
		for(i = 0; i < 1000 ; i++)
			HDELAY = i;         /* One millisecond */
		retry++;
	}

	/*
	 * Load MEGAPEL Adapter Color Table
         * at addresses 0xc10000.
	 */
	mpelwr(&CTable,sizeof(struct ColorTable), COLOR_TABLE);

	*(unsigned short*)DAAP_REASON = 0x0000;
	*(unsigned short*)APDA_REQUEST = 0x0000;

	/*
	 * Issue Load Color Table Command (COMM Area Command)
	 */
	mpel_load_color_table();

	/*
	 * Issue Enter FIFO Mode Command (COMM Area Command)
	 */
	mpel_enter_FIFO();

	/*
	 * set the 255th color
	 */
	mpelwr(&ctab,sizeof(ctab), COLOR_TABLE);
	mpel_load_color_table();

#ifndef NOBLINK
	/*
	 * Turn Blink On (lose one bitplane)
	 */
	mpel_blink_on();
#endif
	/*
	 * *** READY TO ACCEPT GRAPHICS ELEMENTS IN FIFO ***
	 */


	/*
	 * Store cursor image in adapter's memory. 
         */
	RESET_CURSOR;
        mpelwr(cursor,sizeof(cursor), CURSOR_BITMAP);
        mpel_cursor_x = MPEL_TO_X(0);
        mpel_cursor_y = MPEL_TO_Y(0);

	/*
	 * Clear The screen
	 */
   	MPELREMOVE_CURSOR();
   	mpel_clear_all();

	/* 
         * now put the cursor on the upper left corner of the screen
         */
	MPELWRITE_CURSOR();
}



/*
 * load the ucode. zeros are compressed to the format:
 * 0x0000,number of zeros,
 */
mpel_load(tmp,addr,size)
	short *tmp,*addr;
	int	size;
{
#ifdef COMPRESSED
	while (size--) {
	    if (*tmp) {
	    	*addr = *tmp;
		addr++ ; tmp++ ;
	    } else {
		/* copy lsize 0's to addr */
	      int lsize = *(tmp+1);

	      while (lsize--) {
		*addr = 0;
		addr++;
	     }
	     tmp+=2; /* bump passed lsize */
	     if (size--) break;
	   }
	}
#else
	while (size--) {
	    *addr = *tmp;
	    addr++; tmp++;
	}
#endif
}

/*
 * load all the micro code and tables 
 */
LOCAL
mpel_load_ucode()
{
	mpel_load( mpel_circle_table,(short *)CIRTAB,mpel_circ_size);
	mpel_load( mpel_sine_table,(short *)SINTAB,mpel_sine_size);
	mpel_load( mpel_marker_loc,(short *)MARKID,mpel_marker_size);
	mpel_load( mpel_hatch_table,(short *)HCHTAB,mpel_hatch_size);
	mpel_load( mpel_marker_font,(short *)MARKER,mpel_mfont_size);
	mpel_load( mpel_mcode,(short *)MCODE,mpel_mcode_size);
	mpel_load( mpel_font,(short *)MFONT,mpel_font_size);
}
#endif

/*
 * Initialize the MEGAPEL screen.  Call other init routines to set up the
 * font, which includes setting up the number of columns and rows on the
 * screen given the font size.  Then set up all pointers and increments and
 * put the cursor on the screen.
 */
mpel_screen_init()
{
#ifdef LOAD_UCODE
	mpel_ucode_loaded = 1;
	mpel_hw_init();
	mpel_load_ucode(); 
	mpel_start();
#else
	if (*(unsigned short *)MCODE == (unsigned short) MPEL_MCODE_MAGIC)
		mpel_ucode_loaded = 1;
	else
		mpel_ucode_loaded = 0;
#endif
}

/*
 * Does the actual writing of the character onto the screen.
 */
LOCAL
mpelwrite_char(ch,x,y)
  char ch;
{
struct AT_elem {
                 unsigned short len;
                 unsigned short header;
                 short mpel_x;
                 short mpel_y;
                 unsigned short reserved;
                 short length;
                 char char1;
		 char char2;
                } AT;

  AT.len = 0x000d;
  AT.header = 0x5002;
  AT.mpel_x = x;
  AT.mpel_y = y;
  AT.length = 1;
  AT.char1 = ch;
  AT.char2 = ch;
  AT.reserved = 0;
  return(wfifo(&AT,7));
}

LOCAL
mpelclear_char(x,y,color)
{
   mpel_fillcolor(color);
   mpel_fillrect(x,y,x+11,y+29);
}

/* reset the high lighting register and disable high lighting */
LOCAL
mpelendhi()
{
 struct ENDHL_elem {

		    unsigned short header_l;
		    unsigned short header_r;
                   } ENDHL;

	ENDHL.header_l = 0x0004;
	ENDHL.header_r = 0x501f;
    
   wfifo(&ENDHL, 2);
}                     

/* 
 * set the high light color register and enable high lighting.
 * all subsequent characters are drawn using the high light color.
 * this operation replaces the high intensity operation.
 */
LOCAL
mpelbeginhi(color,mode)
{
  struct HICOLOR_elem {
		unsigned short header_l;
		unsigned short header_r;
                unsigned short color;
		} HICOLOR;

  struct BEGHI_elem {
                      unsigned short header_l;
		      unsigned short header_r;
		      short mode;
		     } BEGHI;

  HICOLOR.header_l = 0x0006;
  HICOLOR.header_r = 0x5063;
  HICOLOR.color = color;
  wfifo(&HICOLOR, 3);

  BEGHI.header_l = 0x0006;
  BEGHI.header_r = 0x501e;
  BEGHI.mode = mode;	/* 1 = color highlight, 2 = blink */
  wfifo(&BEGHI, 3);
}


/*
 * Puts the character onto the screen.
 */
mpel_screen_putc(ch,attr)
register char ch;
register int attr;
{
	int videobg;
        int highlit;
        /*
         * check for attribute settings. i.e. Reverse video
         * high_intensity, blink etc..
         */

	mpel_screen_buffer[mpel_buf_pointer] = ch;
 	if (attr & REVERSE_VIDEO) 
		videobg = 2;
	else 		
		videobg = 0;

        
	/*
	 * Put the character onto the screen  where the cursor is
	 */
	MPELREMOVE_CURSOR();    
	mpelclear_char(mpel_cursor_x, mpel_cursor_y,videobg);

        /*
         * set Hi Lighting registers and enable highlighting (or blink)
         */

#ifndef NOBLINK
	if (attr & BLINK) {
                highlit = 8;
        } else 
#endif
	if (attr & HI_INTENSITY) {
                highlit = 12;
	} else  {
                /* this keeps the debugger & kernel happpy togeter */
                highlit = 255;	
	}
        mpelbeginhi(highlit,1);
  	mpelwrite_char(ch, mpel_cursor_x, mpel_cursor_y);
	mpelendhi();


	/*
         * Don't bother writing the cursor back out
         * the emulator is going to call pos_cursor anyway.
	 * MPELWRITE_CURSOR();
         */
}


/*
 * Removes the cursor if necessary, updates the cursor to the column number
 * and line number given, and writes the cursor back out.
 */
mpel_pos_cursor(column_number,line_number)
register int column_number;
register int line_number;
{
  MPELREMOVE_CURSOR();

  mpel_cursor_x = MPEL_TO_X(column_number);
  mpel_cursor_y = MPEL_TO_Y(line_number);
  mpel_buf_pointer = (line_number*MPEL_COLUMNS) + column_number;

  /*
   * removed the cursor now write it back out.
   */
  MPELWRITE_CURSOR();
}

LOCAL
mpelxor_cursor(x,y)
{
  struct BLTVPM_elem {
                      unsigned short header_l;
		      unsigned short header_r;
                      long srcaddr;
                      short dlleft_x;
                      short dlleft_y;
                      short duright_x;
                      short duright_y;
                      short bpixel;
                      short logop;
                } BLTVPM;


  BLTVPM.header_l = 0x0014;
  BLTVPM.header_r = 0x5012;
  BLTVPM.srcaddr = 0x01008022;
  BLTVPM.dlleft_x  = x;		        /*lower left hand corner */
  BLTVPM.dlleft_y  = y;		        /*lower left hand corner */
  BLTVPM.duright_x = x+11; 	      /*upper right hand corner */
  BLTVPM.duright_y = y+29; 	      /*upper right hand corner */
  BLTVPM.bpixel  = 0x0004;
  BLTVPM.logop   = 0x0007;
  
  wfifo(&BLTVPM, 10);     /* write the SOURCE BLTVPM element to FIFO */
}

LOCAL
mpel_fillcolor(color)
{
struct FILLCOLOR_elem {
		unsigned short header_l;
		unsigned short header_r;
                unsigned short color;
		} FILLCOLOR;

   FILLCOLOR.header_l = 0x0006;
   FILLCOLOR.header_r = 0x5053;
   FILLCOLOR.color = color;

   wfifo(&FILLCOLOR, 3);
}

LOCAL
mpel_fillrect(left_x,left_y,right_x,right_y)
{
struct  FILLRECT_elem {
		unsigned short header_l;
		unsigned short header_r;
		short lleft_x, lleft_y;
		short uright_x,uright_y;
               } FILLRECT;

   FILLRECT.header_l = 0x000c;
   FILLRECT.header_r = 0x5004;
   FILLRECT.lleft_x  = left_x;
   FILLRECT.lleft_y  = left_y;
   FILLRECT.uright_x = right_x;
   FILLRECT.uright_y = right_y;

   wfifo(&FILLRECT, 6);

}

/*
 * Using the attribute, (which can be either reverse video or normal video)
 * blank from the starting line and column to the ending line and
 * column.
 */
mpel_screen_blank(attr,sline,scol,eline,ecol)
int attr; /* attribute of how to clear the screen (i.e. reverse video, etc) */
int sline,scol; /* The starting line and column */
int eline,ecol; /* The ending line and column */
{
   int videobg;

   MPELREMOVE_CURSOR();

   lp_screen_blank(mpel_screen_buffer,sline,scol,eline,ecol,CONS_MPEL);
   if (attr & REVERSE_VIDEO)
	videobg = 2;
   else 		
	videobg = 0;

   mpel_fillcolor(videobg);
   mpel_fillrect(MPEL_TO_X(scol),MPEL_TO_Y(eline),MPEL_TO_X(ecol+1)-1,
						MPEL_TO_Y(sline-1)-1);

}

LOCAL
mpelscroll(sly,suy,dy)
{
  struct COPYBLTVPM_elem {
			  unsigned short header_l;
			  unsigned short header_r;
			  short slleft_x;
                          short slleft_y;
                          short suright_x;
                          short suright_y;
                          short dlleft_x;
                          short dlleft_y;
                          unsigned short logop;
                         } COPYBLTVPM;

  COPYBLTVPM.header_l = 0x0012;
  COPYBLTVPM.header_r = 0x500e;
  COPYBLTVPM.slleft_x = MPEL_X_START;
  COPYBLTVPM.slleft_y = sly;
  COPYBLTVPM.suright_x = MPEL_MAX_X - MPEL_X_START;
  COPYBLTVPM.suright_y = suy;
  COPYBLTVPM.dlleft_x = MPEL_X_START;
  COPYBLTVPM.dlleft_y = dy;
  COPYBLTVPM.logop = 0x0004;

  wfifo(&COPYBLTVPM, 9);
}

/*
 * scroll_down takes the block of lines starting at start_line and ending
 * at the bottom of the screen minus n_scrolls number of lines, and moves them 
 * down to the end of the screen.
 * For example, 
 *	Before:	1. XYZ
 *		2. ABC
 *		3. FGH
 *
 *	After scrolling 2 lines down:
 *		~
 *		~
 *		1. XYZ
 */
LOCAL
mpelscroll_down(src_line,dst_line,nlines)
int src_line;	/* Line number to copy from */
int dst_line;	/* Line number to copy to */
int nlines;	/* Number of lines to be copied */
{
	short sly, suy, dy;
	sly = MPEL_TO_Y(src_line+nlines-1);
	suy = sly +((nlines*MPEL_FONT_Y)-1);
	dy = MPEL_TO_Y(dst_line+nlines-1);

	mpelscroll(sly,suy,dy);
}


/*
 * scroll_up takes the block of lines starting n_scrolls number of lines below
 * start_line and ending at the bottom of the screen, and moves them up to
 * start_line.
 * For example, 
 *	Before:	1. XYZ
 *		2. ABC
 *		3. FGH
 *
 *	After scrolling 2 lines up:
 *		3. FGH
 *		~
 *		~
 */
LOCAL
mpelscroll_up(src_line,dst_line,nlines)
int src_line;	/* Line number to copy from */
int dst_line;	/* Line number to copy to */
int nlines;	/* Number of lines to be copied */
{
	short sly, suy, dy;
	sly = MPEL_TO_Y(src_line+nlines-1);
	suy = sly +((nlines*MPEL_FONT_Y)-1);
	dy = MPEL_TO_Y(dst_line+nlines-1);

	mpelscroll(sly,suy,dy);
}


/*
 * mpel_screen_move takes all lines from line_top to line_bottom and 
 * moves these lines to line_dest so that line_top is sitting on line_dest.
 *
 * For example, given line_top is 1, line_bottom is n and line_dest is 3,
 *
 *	Before:	1. XYZ
 *		2. ABC
 *		3. FGH
 *
 *	After scrolling 2 lines down:
 *		~
 *		~
 *		1. XYZ
 *		2. ABC
 *		3. FGH
 */
mpel_screen_move(line_top,line_bottom,line_dest)
register long line_top,line_bottom,line_dest;
{
	lp_screen_move(mpel_screen_buffer,line_top,line_bottom,line_dest,CONS_MPEL);
	/*
	 * Remove the cursor before doing any scrolling.
	 */
	MPELREMOVE_CURSOR();
	/*
	 * Decide which way we are scrolling.
	 */
	if (line_top < line_dest) {
		mpelscroll_down(line_top,line_dest,line_bottom-line_top+1);
	}
	else if (line_top > line_dest) {
		mpelscroll_up(line_top,line_dest,line_bottom-line_top+1);
	}

	/*
	 * Don't bother writing the cursor out because the emulator will
	 * be calling pos_cursor anyway.
	 * MPELWRITE_CURSOR();
	 */
}

mpel_screen_print(si,flags)
register SCREEN_INFO *si;
{
	lp_screen_print(mpel_screen_buffer,si,flags,CONS_MPEL);
}

/*
 * Additional Megapel-dependent routines 
 */


/*
 * IDENTIFICATION: wfifo				
 * DESCRIPTIVE name: Write to FIFO.
 * FUNCTION: Write to hardware FIFO, checking Half Full and Full
 *           flags to ensure that there is always room in the
 *	     FIFO before writing to it.
 *	    
 *	     The  FIFO is 16bit words long. (i.e. 2048 bytes)
 *
 */

LOCAL
int wfifo(idata_ptr, idata_len)
unsigned short *idata_ptr;		/* Pointer to the data to be */
					/* written to the FIFO       */
	 int    idata_len;		/* Numbre of 2-byte words to */
					/* written to the FIFO	     */
{
   int retry;				/* Current RETRY count	     */
   short i;				/* DELAY loop index	     */
   unsigned short *data_ptr;
   unsigned short fifo_flags;
   int data_len;			/* num of 2-byte words..     */

   if (mpel_ucode_loaded == 0)
		return;
/* Read psr to determine if half full/full flags set.		     */

   data_ptr = idata_ptr;		/* copy input data address   */
   data_len = idata_len;		/* copy input data length    */

   retry = 0;


   while(TRUE) { /* Do Forever */
	if (data_len < 1)
		break;

	STATUS_MPEL(fifo_flags); 	/* fifo flags		     */
  	fifo_flags &= 0xe000;
	 
	/*
	 * If the FIFO is empty or less than half full, then write
	 * up to 511 16 bit words at a time to the FIFO.
         */
		
						/* 0x6000 fifo empty */
						/* 0xe000 fifo less  */
						/* than half full    */
	if((fifo_flags == 0x6000) || (fifo_flags == 0xe000)) {
        /*
	 * If data length is less than or equal to 511 then write ALL
	 * of the data to the FIFO. Else just write the dirst 511.
         */
	   if (data_len <= 511) {
		putfifo(data_ptr,data_len);
		break;
	   }
           else{
		putfifo(data_ptr,511);
		data_ptr += 511;
		data_len -= 511;
		retry = 0;
		continue;
	   }
	}
	else { /* HAlf full */
	/* 
	 * Else FIFO is at least half full. If the FIFO is more than
	 * half full then we can write one 16 bit word to the FIFO.
	 * else the FIFO must be FULL
         */
	   					/* 0x8000 fifo full */
						/* 0xa000 fifo >    */
						/* half full	    */
	   if(fifo_flags == 0xa000) {
		putfifo(data_ptr,1);
		data_ptr++;
		data_len--;
		retry = 0;
	        continue;
	   }
	   else { /* Full	*/
	   /* 
	    * The FIFO is full. Delay for one msec and then check the
	    * FIFO status again. If the RETRY count is exceeded give
	    * up. A higher lever program must put the adapter into FIFO
	    * mode by issuing command 0x0002.
	    */
		if(retry > MAXRETRY) {
		   mpel_ucode_loaded = 0;
		   return;			/* give up	    */
		}
		for (i = 0; i < 1000; i++)
			HDELAY = i;	        /* one millisecond  */
		retry++;
		continue;			/* try again        */
	   }					/* end of else full      */
	}					/* end of else half full */
   } 						/* end of while loop     */
   return(0);
}

/*
 * SUBROUTINE: putfifo
 * FUNCTION:   Copies data from memory into the Megapel FIFO
 */
LOCAL
putfifo(dp,dl)
unsigned short *dp;				/* data ptr	         */
int	dl;					/* count of 2-byte words */
{
   int i;
   for ( i = 0; i < dl; i++)
	FIFO = *dp++;    			/* Load the FIFO	 */
}

/*
 * IDENTIFICATION: mpelicmd (copy from vtt8icmd)
 * DESCRIPTIVE NAME: Issue an Adapte command for the Megapel
 *		     Virtual Display Driver (VDD)
 * FUNCTION: Check for completion of any previous commands.
 *	     When done issue the requested command to the adapter
 * END OF SPEC
 */

LOCAL
mpelicmd(command_code, parameters, parm_count)
unsigned short command_code;
unsigned short parameters[];
int   parm_count;

{
   int register i;
   int retry = 0;
   unsigned short *COMM_Request_parm;

   if (mpel_ucode_loaded == 0) {
	return;
   }

   while(AP_DA_Request != 0){        /* The previous command has not yet   */   
       				     /* completed.        	           */
      if( retry > MAXRETRY ) {	     /* Adaoter is taking too long on      */
	mpel_ucode_loaded = 0;
        return;                  /* give up				   */
      }
      for(i = 0; i < 1000 ; i++)     
	HDELAY = i;                   /* One millisecond			   */
      retry++;			     /* Another chance			   */
   }
   AP_DA_Request = command_code;     /* Store request code into COMM area  */ 
   COMM_Request_parm = (unsigned short *)(COMM_REQ_PARAM);   
   for(i = 0; i < parm_count ; i++)  /* Store parameters into COMM area    */
      COMM_Request_parm[i] = parameters[i];
   RESET_INT_TMS_BIT;
   SET_INT_TMS_BIT;   		     /* Interrupt adapter	           */
}

/*
 * IDENTIFICATION: mpelicmd2 (copy from vtt8icmd)
 * DESCRIPTIVE NAME: Issue an Adapte command for the Megapel
 *		     Virtual Display Driver (VDD)
 * FUNCTION: Check for completion of any previous commands.
 *	     When done issue the requested command to the adapter
 * END OF SPEC
 */
LOCAL
mpelicmd2(command_code, parameters, parm_count)
unsigned short command_code;
unsigned short parameters[];
int   parm_count;

{
   int register i;
   int retry = 0;
   unsigned short *COMM_Request_parm;
   unsigned short reg;

   if (mpel_ucode_loaded == 0) {
	return;
   }

	/*
	 * Issue COMM Area Command
	 */
   AP_DA_Request = command_code;     /* Store request code into COMM area  */ 
   COMM_Request_parm = (unsigned short *)(COMM_REQ_PARAM);   
   for(i = 0; i < parm_count ; i++)  /* Store parameters into COMM area    */
      COMM_Request_parm[i] = parameters[i];
   RESET_INT_TMS_BIT;
   SET_INT_TMS_BIT;   		     /* Interrupt adapter	           */

	/*
         * check for interrupt pending: clear it.
         */
	for (retry=0; retry < MAXRETRY; retry++) {
		STATUS_MPEL(reg);
		if (reg & PSR_INTPEND_BIT)
			break;
		if (*(unsigned short *) DAAP_REASON == (command_code+1))
			break;
		if (retry == (MAXRETRY-1))
			mpel_ucode_loaded = 0;
		else delay(1);
	}

	/*
         * Check for reason code of command+1
         */
	if (*(unsigned short*)DAAP_REASON != (command_code+1)) {
		/* printf("Reason code %x\n", *(unsigned short*)DAAP_REASON); */
	}

	*(unsigned short*)DAAP_REASON = 0x0000;
	*(unsigned short*)APDA_REQUEST = 0x0000;
}

/*
 * utility defines and commands
 */

static unsigned short tableptr[2] =
{
	0x0000,	/* color table pointer */
	0x3ed8
};

LOCAL	
mpel_load_color_table()
{
	mpelicmd2(RQ_LOAD_CTABL, tableptr, 2);
}

LOCAL
mpel_enter_FIFO()
{
	mpelicmd2(RQ_ENTER_FIFO, NULL, 0);
}

#ifndef NOBLINK
LOCAL
mpel_blink_on()
{
	mpelicmd2(RQ_SET_BLINK, NULL, 0);
}
#endif
#endif NMEGAPEL

