/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /sys/rt/stand/RCS/premain.c,v 1.2 1994/03/15 17:39:11 md Exp $ */
/* $ACIS:premain.c 12.0$ */
/* $Source: /sys/rt/stand/RCS/premain.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /sys/rt/stand/RCS/premain.c,v 1.2 1994/03/15 17:39:11 md Exp $";
#endif


#undef main			       /* so we don't get hoisted on our own petard */

#define MAX_LINE	10240	       /* for Alex */
#define MAX_ARG		(MAX_LINE/4)

#include "debug.h"

int _prefirst;

main()
{
	extern char end;
	extern char edata;
	register char *p;
	char line[MAX_LINE];
	char *argv[MAX_ARG];
	register int argc;
	register int clear = 0;		/* startup did it first time */

	_init_vectors(0xffff);	       /* init all vectors */
	mtsr(SCR_ICS, 0x83);       /* allow non-I/O interrupts */
	for (;;) {
/*
 * clear all of bss. This attempts to set conditions back to
 * an initial state. the putchar routine takes particular care to
 * keep all critial values in DATA rather than BSS space so that
 * the screen does not get erased by the following loop.
 */
		if (clear) {
			for (p = &edata; p < &end; ++p)
				*p = 0;
		}
		if (_prefirst++ == 0)
			printf("Enter arguments or debug (*) commands \n");
		printf("S/A %% ");
		getstr(line, sizeof(line));
		argc = _parse(line, line, argv);
		if (argc > 0 && *argv[0] == '*') {
			++argv[0];     /* skip past * */
			dump_cmd(argc, argv);
			clear = 0;
		} else {
			_main(argc, argv);
			printf("main program returned\n");
			clear = 1;
		}
	}
}
