/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* memory allocation functions */

#include <stdio.h>
#if !BSD
#include <string.h>
#endif

extern	char	*argv0;	/* command name (must be set in main function) */

char	*mycalloc(), *mymalloc(), *myrealloc(), *stralloc();
static	char	*alloctest();
#ifdef __STDC__
#include <stdlib.h>
#else
char	*calloc(), *malloc(), *realloc(), *strcpy();
void	exit();
#endif

/* allocate a string */

char *
stralloc(s)
char	*s;
{
	return(strcpy(mymalloc((unsigned) strlen(s) + 1), s));
}

/* version of malloc that only returns if successful */

char *
mymalloc(size)
unsigned size;
{
	return(alloctest(malloc(size)));
}

/* version of calloc that only returns if successful */

char *
mycalloc(nelem, size)
unsigned nelem, size;
{
	return(alloctest(calloc(nelem, size)));
}

/* version of realloc that only returns if successful */

char *
myrealloc(p, size)
char	*p;
unsigned size;
{
	return(alloctest(realloc(p, size)));
}

/* check for memory allocation failure */

static	char *
alloctest(p)
char	*p;
{
	if (p == NULL) {
		(void) fprintf(stderr, "\n%s: out of storage\n", argv0);
		exit(1);
	}
	return(p);
}
