/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#if SVR2 && !BSD && !V9 && !u3b2 && !sun
/*
 * Richard L. Maus, Jr. - Sat May  2 21:31:51 EDT 1987
 *
 * This work-around is only necessary if you use the "keypad()" function
 * in the "curses" library.  If "keypad(..., TRUE)" is ever executed, then
 * "fixkeypad()" should be called sometime after "initscr()" and before the
 * any input request.  For example,
 *
 *	...
 *	initscr();
 *	keypad(stdscr, TRUE);
 *	fixkeypad();
 *	ch = getch();
 *	...
 *
 * Work-around for "curses" bug that fails to terminate keypad array in most
 * versions of AT&T UNIX curses up to and including SVR3.  Also has beneficial
 * side effect of eliminating wasted memory searches beyond the intended end of
 * the array.  My specific problem on an AT&T 6300+ UNIX SVR2 system was that
 * key pad searches were going beyond the end of the allocated array, finding
 * and ordinary character (P) and returning a (keynum) value of 0 from
 * "getch()".  Very nasty indeed.
 *
 * In the "curses" library file "initkeypad.c", the routine "_init_keypad()"
 * sets the last "keynum" structure member to 0 and has a comment stating
 * that this is the terminating convention.  However, the only routine that
 * remotely uses this convention is "wgetch()" in "getch.c".  A "for" loop
 * expects to see a negative value as the termination and assumes that 0 is
 * a valid "keynum" value.
 *
 * We have two choices here: change the code or change the data.  I chose
 * the later.
 *
 * NOTE TO THE FELLOW AT&T'er THAT EVENTUALLY FIXES THE CODE:
 * Please change the convention to use a negative "keynum" value (-1) so that
 * this work-around will continue to co-exist with corrected code.
 */

#define KEYPAD
#include <curses.ext>

void
fixkeypad()
{
	register short	i;
	extern struct screen *SP;

	/*
	 * Search for non-negative values.  If we spot a negative value,
	 * then either we have already called "fixkeypad" before OR
	 * someone has fixed the "curses" library routines.
	 */
	for (i=0; SP->kp[i].keynum >= 0; i++) {
		if (SP->kp[i].keynum == 0) {
			SP->kp[i].keynum = -1;
			return;
		}
	}
}
#endif
