/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	cscope - interactive C symbol cross-reference
 *
 *	global type, data, and function definitions
 */

#include <ctype.h>	/* isalpha, isdigit, etc. */
#include <signal.h>	/* SIGINT and SIGQUIT */
#include <stdio.h>	/* standard I/O package */
#include "constants.h"	/* misc. constants */
#include "invlib.h"	/* inverted index library */
#include "library.h"	/* library function return values */
#include "mouse.h"	/* mouse interface */
#ifdef CCS
#include "ccstypes.h"	/* pid_t */
#else
#if pyr
typedef short   pid_t;
#else
#if AIX
typedef	long	pid_t;
#else
#if ibmrt
#include <sys/types.h>
#else
typedef	int	pid_t;
#endif
#endif
#endif
#endif

#if SVR2 || V9 || BSD && !sun && !BSD44
#define SIGTYPE int
#else
#define SIGTYPE void
#endif

typedef	enum	{		/* boolean data type */
	NO,
	YES
} BOOL;

typedef	enum	{		/* findinit return code */
	NOERROR,
	NOTSYMBOL,
	REGCMPERROR
} FINDINIT;

typedef	struct	history	{		/* command history */
	int	field;
	char	*text;
	struct	history *previous;
	struct	history *next;
} HISTORY;

/* digraph data for text compression */
extern	char	dichar1[];	/* 16 most frequent first chars */
extern	char	dichar2[];	/* 8 most frequent second chars 
				   using the above as first chars */
extern	char	dicode1[];	/* digraph first character code */
extern	char	dicode2[];	/* digraph second character code */

/* main.c global data */
extern	char	*editor, *home, *shell;	/* environment variables */
extern	char	*argv0;		/* command name */
extern	BOOL	compress;	/* compress the characters in the crossref */
extern	BOOL	dbtruncated;	/* database symbols are truncated to 8 chars */
extern	int	dispcomponents;	/* file path components to display */
#if CCS
extern	BOOL	displayversion;	/* display the C Compilation System version */
#endif
extern	BOOL	editallprompt;	/* prompt between editing files */
extern	int	fileargc;	/* file argument count */
extern	char	**fileargv;	/* file argument values */
extern	int	fileversion;	/* cross-reference file version */
extern	BOOL	incurses;	/* in curses */
extern	INVCONTROL invcontrol;	/* inverted file control structure */
extern	BOOL	invertedindex;	/* the database has an inverted index */
extern	BOOL	isuptodate;	/* consider the crossref up-to-date */
extern	BOOL	linemode;	/* use line oriented user interface */
extern	char	*namefile;	/* file of file names */
extern	char	*newreffile;	/* new cross-reference file name */
extern	FILE	*newrefs;	/* new cross-reference */
extern	BOOL	ogs;		/* display OGS book and subsystem names */
extern	FILE	*postings;	/* new inverted index postings */
extern	char	*prependpath;	/* prepend path to file names */
extern	int	symrefs;	/* cross-reference file */
extern	char	temp1[];	/* temporary file name */
extern	char	temp2[];	/* temporary file name */
extern	long	totalterms;	/* total inverted index terms */
extern	BOOL	truncate;	/* truncate symbols to 8 characters */

/* command.c global data */
extern	BOOL	caseless;	/* ignore letter case when searching */
extern	BOOL	*change;	/* change this line */
extern	BOOL	changing;	/* changing text */
extern	char	newpat[];	/* new pattern */
extern	char	pattern[];	/* symbol or text pattern */

/* crossref.c global data */
extern	long	dboffset;	/* new database offset */
extern	BOOL	errorsfound;	/* prompt before clearing error messages */
extern	long	fileindex;	/* source file name index */
extern	long	lineoffset;	/* source line database offset */
extern	long	npostings;	/* number of postings */
extern	int	symbols;	/* number of symbols */

/* dir.c global data */
extern	char	currentdir[];	/* current directory */
extern	char	**incdirs;	/* #include directories */
extern	char	**srcdirs;	/* source directories */
extern	char	**srcfiles;	/* source files */
extern	int	nincdirs;	/* number of #include directories */
extern	int	nsrcdirs;	/* number of source directories */
extern	int	nsrcfiles;	/* number of source files */
extern	int	msrcfiles;	/* maximum number of source files */

/* display.c global data */
extern	int	*displine;	/* screen line of displayed reference */
extern	int	disprefs;	/* displayed references */
extern	int	field;		/* input field */
extern	unsigned fldcolumn;	/* input field column */
extern	int	mdisprefs;	/* maximum displayed references */
extern	int	nextline;	/* next line to be shown */
extern	int	topline;	/* top line of page */
extern	int	bottomline;	/* bottom line of page */
extern	int	totallines;	/* total reference lines */
extern	FILE	*refsfound;	/* references found file */
extern	FILE	*nonglobalrefs;	/* non-global references file */

/* find.c global data */
extern	char	block[];	/* cross-reference file block */
extern	int	blocklen;	/* length of disk block read */
extern	char	blockmark;	/* mark character to be searched for */
extern	long	blocknumber;	/* block number */
extern	char	*blockp;	/* pointer to current character in block */

/* lookup.c global data */
extern	struct	keystruct {
	char	*text;
	char	delim;
	struct	keystruct *next;
} keyword[];

/* scanner.l global data */
extern	int	first;		/* buffer index for first char of symbol */
extern	int	last;		/* buffer index for last char of symbol */
extern	int	lineno;		/* symbol line number */
extern	FILE	*yyin;		/* input file descriptor */
extern	int	yyleng;		/* input line length */
extern	int	yylineno;	/* input line number */
extern	char	yytext[];	/* input line text */

/* cscope functions called from more than one function or between files */ 
void	addcmd();
void	addsrcfile();
void	askforchar();
void	askforreturn();
void	atfield();
void	build();
void	cannotindex();
void	cannotopen();
void	cannotwrite();
void	clearmsg2();
BOOL	command();
void	countrefs();
void	crossref();
HISTORY	*currentcmd();
long	dbseek();
void	dispinit();
void	display();
void	edit();
void	entercurses();
void	exitcurses();
char	*filepath();
void	findcleanup();
char	*findegreppat();
FINDINIT findinit();
void	freefilelist();
void	getstring();
void	incfile();
void	includedir();
BOOL	infilelist();
void	initprogress();
void	initscanner();
void	initsymtab();
char	*inviewpath();
char	*lookup();
void	makefilelist();
void	myexit();
void	myperror();
HISTORY	*nextcmd();
HISTORY	*prevcmd();
void	progress();
void	putfilename();
void	putmsg();
void	putmsg2();
void	putposting();
void	putstring();
char	*readblock();
void	rebuild();
void	resetcmd();
void	savesymbol();
char	*scanpast();
BOOL	search();
void	seekline();
void	setfield();
void	shellpath();
void	sourcedir();
char	*strtolower();
void	warning();
BOOL	writerefsfound();
