/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	cscope - interactive C symbol or text cross-reference
 *
 *	command history
 */

#include "global.h"

HISTORY *head, *tail, *current;

/* add a cmd to the history list */
void
addcmd( f, s)
int f;		/* field number */
char *s;	/* command text */
{
	HISTORY *h;

	h = (HISTORY *) mymalloc(sizeof(HISTORY));
	if (tail) {
		tail->next = h;
		h->next = 0;
		h->previous = tail;
		tail = h;
	} else {
		head = tail = h;
		h->next = h->previous = 0;
	}
	h->field = f;
	h->text = stralloc(s);
	current = 0;
}

/* return previous history item */

HISTORY *
prevcmd()
{
	if (current) {
		if (current->previous)	/* stay on first item */
			return current = current->previous;
		else
			return current;
	} else if (tail)
		return current = tail;
	else 
		return (HISTORY *) 0;
}

/* return next history item */

HISTORY *
nextcmd()
{
	if (current) {
		if (current->next)	/* stay on first item */
			return current = current->next;
		else
			return current;
	} else 
		return (HISTORY *) 0;
}

/* reset current to tail */

void
resetcmd()
{
	current = 0;
}

HISTORY *
currentcmd()
{
	return current;
}
