/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* This file defines a common set of directory reading macros based on the
 * Berkeley library functions, so define statdir() for all and opendir(),
 * readdir(), rewinddir(), and closedir() for System V variants.
 */
#if BSD || sun
#include <sys/dir.h>
#define	statdir(file, statp)	fstat(file->dd_fd, statp)
#ifdef AIX
#include <dirent.h>
#define	direct	dirent
#endif	/* AIX */
#else
#ifdef mips
#include <dirent.h>
#define	statdir(file, statp)	fstat(file->dd_fd, statp)
#define	direct	dirent
#else
#if apollo || hp9000s200 || pyr
#define REALDIRSIZE	sizeof(_dirstruct)
#else	/* System V || V9 */
/* allow for a terminating null on the name, which must be the last structure 
   member */
#undef	DIRSIZ
#define DIRSIZ		15
/* can't use sizeof(_dirstruct) - 1 because it may be padded to a word boundry */
/* can't use sizeof(ino_t) in SVR4 because ino_t becomes ulong, but this struct
   uses o_ino_t, which remains a ushort, so just use sizeof(ushort) */
#ifdef V9
typedef unsigned short	ushort;
#endif	/* V9 */
#define REALDIRSIZE	(sizeof(ushort) + DIRSIZ - 1)
#endif	/* System V || V9 */
#include <sys/dir.h>		/* must be after DIRSIZ definition */
#if !pyr
#define MAXNAMLEN	DIRSIZ - 1
#endif	/* !pyr */
#define	DIR		FILE
#define opendir(name)		fopen(name, "r")
#define closedir(file)		(void) fclose(file)
#define rewinddir(file)		rewind(file)
#define	statdir(file, statp)	fstat(fileno(file), statp)
#define readdir(file)		\
	(fread((char *) &_dirstruct, REALDIRSIZE, 1, file) == 1 ? \
	&_dirstruct : (struct direct *) NULL)
static	struct	direct	_dirstruct;
#endif	/* !mips */
#endif	/* !(BSD || sun) */
