


CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



NAME
     cscope - interactively examine a C program

SYNOPSIS
     cscope [ options ] [ C source files ]

DESCRIPTION
     _C_s_c_o_p_e is an interactive  screen-oriented  tool  that  helps
     you:
          Learn how a C program works  without  endless  flipping
          through a thick listing.  Locate the section of code to
          change to fix a bug without having to learn the  entire
          program.   Examine the effect of a proposed change such
          as adding a value to an _e_n_u_m variable.  Verify  that  a
          change has been made in all source files such as adding
          an argument to an existing function.  Rename  a  global
          variable  in  all source files.  Change a constant to a
          preprocessor symbol in selected lines of files.
     It is designed to answer questions like:
          Where is this variable used?
          What is the value of this preprocessor symbol?
          Where is this function in the source files?
          What functions call this function?
          What functions are called by this function?
          Where does the message "out of space" come from?
          Where is this source file in the directory structure?
          What files include this header file?
     _C_s_c_o_p_e answers these questions from a symbol  database  that
     it builds the first time it is used on the source files.  On
     a subsequent call, _c_s_c_o_p_e rebuilds the database  only  if  a
     source  file has changed or the list of source files is dif-
     ferent.  When the database  is  rebuilt  the  data  for  the
     unchanged files is copied from the old database, which makes
     rebuilding much faster than the initial  build.   After  the
     database is ready _c_s_c_o_p_e will display these input fields:
          Find this C symbol:
          Find this global definition:
          Find functions called by this function:
          Find functions calling this function:
          Find this text string:
          Change this grep pattern:
          Find this egrep pattern:
          Find this file:
          Find files #including this file:
     Press the TAB key repeatedly to move to  the  desired  input
     field,  type  the  pattern to search for, and then press the
     RETURN key.  For the first 4 and last 2  input  fields,  the
     pattern  can  be  a  regcmp(3X)  regular expression.  If the
     search is successful, you can use these command characters:
     1-9    Edit the file containing the line.
     space  Display next lines.
     +      Display next lines.



Sun Release 4.1           Last change:                          1






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



     -      Display previous lines.
     ^E     Edit all lines.
     >      Write all lines to a file.
     >>     Append all lines to a file.
     <      Read lines from a file.
     ^      Filter all lines through a shell command.
     |      Pipe all lines to a shell command.  At any  time  you
            can use these command characters:
     ^P     Move to the previous input field.
     ^Y     Search with the last pattern typed.
     ^B     Recall previous input field and search pattern.
     ^F     Recall next input field and search pattern.
     ^C     Toggle ignore/use letter case when searching.
     ^R     Rebuild the symbol database.
     !      Start an interactive shell  (type  ^D  to  return  to
            _c_s_c_o_p_e).
     ^L     Redraw the screen.
     ?      Display this list of commands.
     ^D     Exit _c_s_c_o_p_e.  Note: If the  first  character  of  the
            pattern  you  want  to  search for matches one of the
            above commands, type a \ character first.

  Changing Text.
     After typing the _g_r_e_p(1) pattern to  be  searched  for,  you
     will  be  prompted  for the replacement text, then the lines
     containing the pattern will be displayed.   You  select  the
     lines to be changed with these command characters:
     1-9    Mark or unmark the line to be changed.
     *      Mark or unmark all displayed lines to be changed.
     space  Display next lines.
     +      Display next lines.
     -      Display previous lines.
     a      Mark or unmark all lines to be changed.
     ^D     Change the marked lines and exit.
     ESC    Exit without changing the marked lines.
     !      Start an interactive shell  (type  ^D  to  return  to
            _c_s_c_o_p_e).
     ^L     Redraw the screen.
     ?      Display this list of commands.

  Special Keys.
     If your terminal has arrow keys that work in _v_i(1)  you  can
     use  them to move around the input fields.  The up-arrow key
     is useful to move to the previous  input  field  instead  of
     using  the TAB key repeatedly.  If you have the CLEAR, NEXT,
     or PREV keys they will act as the  ^L,  +,  and  -  commands
     respectively.

  Mouse.
     If you have a Teletype 5620 or  630  terminal  and  use  the
     _e_m_a_c_s_t_e_r_m(1) or _v_i_t_e_r_m(1) terminal programs, you can use the
     mouse with _c_s_c_o_p_e.  If you use the _m_y_x(1) terminal  program,



Sun Release 4.1           Last change:                          2






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



     set  the  MOUSE environment variable to _m_y_x (see ENVIRONMENT
     VARIABLES).  Point with the mouse and click button 1 to move
     to  the desired input field, type the pattern to search for,
     and then press the RETURN key.  If the search is successful,
     you  can edit the file containing a displayed line by point-
     ing with the mouse and clicking  button  1.   When  changing
     text,  point  with  the  mouse and click button 1 to mark or
     unmark the line to be changed.  Press mouse button 2 to  get
     a menu of commands.

  Options.
     When invoking _c_s_c_o_p_e you can use these options:
     -b       Build the database only.
     -c       Use only ASCII characters  in  the  database  file,
              that is, do not compress the data.
     -C       Ignore letter case when searching.
     -d       Do not update the database.
     -e       Suppress the ^E command prompt between files.
     -f _f_i_l_e  Use _f_i_l_e as the database file name instead  of  the
              default (cscope.out).
     -F _f_i_l_e  Read symbol reference lines from  _f_i_l_e,  just  like
              the < command.
     -i _f_i_l_e  Read any -I, -p, -q, and -T options and the list of
              source  files  from  _f_i_l_e  instead  of  the default
              (cscope.files).
     -I _d_i_r   Look in _d_i_r for #include files.
     -l       Line-oriented interface (see Calling Cscope with  a
              Line-Oriented Interface).
     -L       Do a single search with line-oriented  output  when
              used with the -_n _p_a_t_t_e_r_n option.
     -o       Display OGS book and subsystem names.
     -p _n     Display the last _n file path components instead  of
              the  default  (1).   Use  0 to not display the file
              name at all.
     -P _p_a_t_h  Prepend _p_a_t_h to relative file names in a  pre-built
              database so you do not have to change to the direc-
              tory where the database was built.  This option  is
              only valid with the -d option.
     -q       Build an inverted index for quick symbol  seaching.
              If you use this option with the -f option, you must
              use -f on every call to _c_s_c_o_p_e, including  building
              the  database,  because it changes the names of the
              inverted index files.
     -s _d_i_r   Look in _d_i_r  for  additional  source  files.   This
              option  is ignored if source files are given on the
              command line.
     -T       Use  only  the  first  eight  characters  to  match
              against C symbols.  A regular expression containing
              special characters other than a period (.) will not
              match  any  symbol if its minimum length is greater
              than eight characters.
     -u       Unconditionally build the database (assume that all



Sun Release 4.1           Last change:                          3






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



              files have changed).
     -U       Do not check file time  stamps  (assume  that  some
              files have changed).
     -_n _p_a_t_t_e_r_n
              Go to input field _n (counting from 0) and find _p_a_t_-
              _t_e_r_n.   The  -I, -p, -q, and -T options can also be
              in the _c_s_c_o_p_e._f_i_l_e_s file.   See  below  for  common
              uses of most of these options.

EXAMPLES
  Calling Cscope from the Shell.
     To use _c_s_c_o_p_e on all the C, lex, yacc,  breakpoint  listing,
     Ingres(TM),  and  SDL  files in the current directory and up
     the Change Management  System  (CMS)  and  SABLE  view  path
     ($VPATH) just type
          cscope
     You can use _c_s_c_o_p_e on particular files if you have more than
     one  program in the same directory.  The above is equivalent
     to
          cscope *.[chlyCGHL] *.bp *.q[ch] *.sd
     If you want to use _c_s_c_o_p_e on all the  source  files  in  the
     current  and  a  few other directories, use the -s option to
     give the other directory names, e.g.
          cscope -s ../common,../../common
     If you want to use _c_s_c_o_p_e on all the  source  files  in  the
     current  and lower level directories, first create a list of
     the files with
          find . -name '*.[chlyCGHL]' -print >cscope.files
     and then type
          cscope
     _C_s_c_o_p_e will look up the view path for the _c_s_c_o_p_e._f_i_l_e_s file,
     so  you  can put it under CMS or SABLE to prevent accidental
     destruction.  If a file #include's files that are in  direc-
     tories  other  than  the  current  directory or the standard
     directory (/usr/include), use the -I option just  like  when
     using the _c_c(1) command
          cscope -I../hdr -I../../hdr
     If files may have the same base name, you will want  to  use
     the  -p  option  to  display the last _n file path components
     instead of the default (1).  If you use a compiler that does
     not support flexnames, that is, symbol name differences past
     eight characters are ignored, you will want to  use  the  -T
     option  to have _c_s_c_o_p_e do the same.  You can put -I, -p, -q,
     and -T options in the file containing  the  list  of  source
     files  (see  above).   This shortens the _c_s_c_o_p_e command line
     and makes it easier to call _c_s_c_o_p_e from an editor.   If  you
     use  _c_s_c_o_p_e  on thousands of source files, use the -b option
     to only build the database so you can do run it in the back-
     ground with a _b_a_t_c_h(1) or _a_t(1) job.
          echo 'cscope -b' | batch
     Use the -d option on subsequent calls to cscope
          cscope -d



Sun Release 4.1           Last change:                          4






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



     to avoid the time spent checking if the database is  out  of
     date,  which can be significant.  If the source files change
     infrequently, you can get quick symbol searching by building
     the  database with the -q option.  For a very large database
     you will be able to find a  symbol  in  a  few  seconds  vs.
     several minutes if built without -q, at the expense of about
     twice as much  database  disk  space  and  build  CPU  time.
     Updating a -q database takes about as half as long as build-
     ing it.  It contains binary numbers, so it is portable  only
     between  machines  with  the same byte order.  Note that 3B,
     Amdahl/IBM, and MC680x0-based machines like  Suns  all  have
     the  same  byte  order.  The -q option makes it practical to
     have databases for entire projects.  If you try to  build  a
     project  database  and  get  a "File too large" message, you
     need to get your login's ulimit (file size limit) raised  by
     your system administrator.  If you get the "No space left on
     device" message you will have to use a file system with more
     space.   You can change the temporary file system by setting
     the TMPDIR environment variable.  If you have  enough  space
     to build the database but not to rebuild it after some files
     have changed, try removing the inverted index  _c_s_c_o_p_e._i_n._o_u_t
     and  _c_s_c_o_p_e._p_o._o_u_t  files.   If  you still don't have enough
     space to rebuild, you will have  to  remove  the  _c_s_c_o_p_e._o_u_t
     file.   If you want to use _c_s_c_o_p_e separately on several pro-
     grams in the same directory structure, but  keep  the  data-
     bases in the same (top) directory, use the -f and -i options
     to rename the  _c_s_c_o_p_e._o_u_t  and  _c_s_c_o_p_e._f_i_l_e_s  file,  respec-
     tively, e.g.
          find dir1 -name '*.[chlyCGHL]' -print >dir1.files
          find dir2 -name '*.[chlyCGHL]' -print >dir2.files
          cscope -b -f dir1.db -i dir1.files
          cscope -b -f dir2.db -i dir2.files
     and call cscope with
          cscope -d -f dir2.db
     Note that options used only when building the database, such
     as  -i,  are not needed with the -d option.  If other people
     are going to use these databases, you will should provide  a
     shell  script  to call _c_s_c_o_p_e with the correct options.  Use
     the -P option to give the path to relative file names so the
     script  does  not  have to change to the directory where the
     database was built, which can confuse users.

  Calling Cscope from an Editor.
     To call _c_s_c_o_p_e from within _v_i(1) type :!cscope  followed  by
     any  file  arguments.  From _e_m_a_c_s(1) type M-!cscope followed
     by any file arguments.  There is an _e_m_a_c_s(1) macro  for  the
     two  most  common  calls to _c_s_c_o_p_e.  Type M-X to call _c_s_c_o_p_e
     with no file arguments, and type ^UM-X to call  _c_s_c_o_p_e  with
     the -d option to not update the database.

  Boolean Searching.
     You can do the equivalent of Boolean or logical AND, OR, and



Sun Release 4.1           Last change:                          5






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



     NOT  operations  on  searches  with the ^, >, >>, and < com-
     mands.  For example, if you wanted  all  references  to  the
     symbol  _s_t_d_e_r_r  in  file _i_n_v_l_i_b._c, search for the symbol and
     then use the ^ command with shell command
          grep invlib.c
     If you wanted all the references not in this file,  use  the
     _g_r_e_p(1)  -v  option.  If you wanted all the lines where sym-
     bols _s_t_d_e_r_r or _s_t_d_o_u_t are used, search for the first symbol,
     write  the  references  to a file with the > command, search
     for the second symbol, append the  references  to  the  same
     file  with the >> command, read the file with the < command,
     and get rid of duplicate lines with the ^ command using  the
     shell command
          sort | uniq
     Note that all <global> references will no  longer  be  first
     because the references will be sorted by file name.

  Stacking Cscope and Editor Calls.
     When _c_s_c_o_p_e puts you in the editor  to  display  one  symbol
     reference  and  you  see  another  symbol of interest, don't
     leave the editor, just call _c_s_c_o_p_e  again  from  within  the
     editor.   In  this way you can stack _c_s_c_o_p_e and editor calls
     so you can go off on a tangent, and then back  up  to  where
     you  were by exiting the tangential _c_s_c_o_p_e and editor calls.
     For example, when learning a program you will probably  have
     _c_s_c_o_p_e  find the main function and display it with your edi-
     tor.  You can visualize this as an inverse stack of calls:
          cscope: find and display main()
               editor: display first lines of main()
     You may then see that main  calls  an  initialize  function.
     Rather  than  exiting  the editor to go back to _c_s_c_o_p_e, call
     _c_s_c_o_p_e again from within the editor to find  the  initialize
     function  and  display  it  with  another editor call.  Your
     stack of calls now looks like this:
          cscope: find and display main()
               editor: display first lines of main()
                    cscope: find and display initialize()
                         editor: display first lines of initialize()
     When you are through looking at this function, you can  exit
     this  second  editor  call, exit the second _c_s_c_o_p_e call, and
     you are back in the first editor call that is displaying the
     main function.  You are now back to:
          cscope: find and display main()
               editor: display first lines of main()
     and can continue reading the main function.

  Calling Cscope with a Line-Oriented Interface
     The -l option lets you use _c_s_c_o_p_e  where  a  screen-oriented
     interface  would  not  be  useful, e.g. from another screen-
     oriented program.  _C_s_c_o_p_e will prompt with ">> " when it  is
     ready  for  an  input  line  starting  with the field number
     (counting  from  0)  immediately  followed  by  the   search



Sun Release 4.1           Last change:                          6






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



     pattern, e.g. "1main" finds the definition of the _m_a_i_n func-
     tion.  If you just want a single search, instead of  the  -l
     option  use the -L and -_n _p_a_t_t_e_r_n options, and you won't get
     the ">> " prompt.  For -l,  _c_s_c_o_p_e  outputs  the  number  of
     reference lines
          cscope: 2 lines
     For each reference found, _c_s_c_o_p_e outputs a  line  consisting
     of the file name, function name, line number, and line text,
     separated by spaces, e.g.
          main.c main 161 main(argc, argv)
     Note that the editor is  not  called  to  display  a  single
     reference,  unlike  the  screen-oriented interface.  You can
     use the 'c' command to  toggle  ignoring/using  letter  case
     when  searching and the 'r' command to rebuild the database.
     _C_s_c_o_p_e will quit when it detects end-of-file,  or  when  the
     first  character of an input line is ^D or 'q'.  This option
     allows you to write  a  program  like  _s_a_m_u_e_l(1)  that  uses
     _c_s_c_o_p_e  to look up symbol information.  The program can send
     search commands to _c_s_c_o_p_e and read the results.  The _x_c_s_c_o_p_e
     macro  package  available  for  _e_m_a_c_s(1) uses this option to
     look up C symbols.  This option may also be useful for  ter-
     minals  not  supported  by _t_e_r_m_i_n_f_o(4) or for sight-impaired
     users of printing terminals.

SYMBOL DATABASE FORMAT
     The symbol database (cscope.out) file format is
          <header>
          <first file symbol data>
               ...
          <last file symbol data>
          <trailer>
     The header is a single line
          cscope <format version> <current dir> [-c] <trailer offset>
     The format version is first number  in  the  _c_s_c_o_p_e  version
     that  wrote  the  database, e.g. the format version is 9 for
     _c_s_c_o_p_e version 9.14.  When the format version number in  the
     _c_s_c_o_p_e  program  is  greater  than that in the database, the
     entire database will be rebuilt when any part of it  is  out
     of  date.   The  current  directory is either a full path or
     prefixed by $HOME, allowing the user's login to be moved  to
     a  different  file  system  without rebuilding the database.
     The trailer offset is the fseek(3) offset  of  the  trailer.
     The  header  is followed by the symbol data for each file in
     alphabetical order.  This allows fast updating of the  data-
     base  when  only  a  few files have changed, because the old
     database is copied to the new database up to  the  point  of
     the  changed  file.   Then the changed file's symbol data is
     added to the new database, the old database is copied up  to
     the  next  changed  file,  and  so on.  Two data compression
     techniques are used on the symbol  data:  (1)  keywords  and
     trailing syntax are converted to control characters, and (2)
     common digraphs (character pairs) are  compressed  to  meta-



Sun Release 4.1           Last change:                          7






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



     characters  (characters with the eight bit set).  Since this
     makes it hard to read or postprocess the database,  you  may
     want  to use the -c option to turn off data compression when
     the database is built.  The symbol data for each file starts
     with
          <file mark><file path>
          <empty line>
     and for each source line containing a symbol
          <line number><blank><non-symbol text>
          <optional mark><symbol>
          <non-symbol text>
          repeat above 2 lines as necessary
          <empty line>
     Leading and trailing white  space  in  the  source  line  is
     removed.   Tabs  are  changed to blanks, and multiple blanks
     are squeezed to a single blank, even in character and string
     constants.  The symbol data for the last file ends with
          <file mark>
     A mark is a tab followed by one of these characters:
          Char Meaning

          @    new file
          $    function definition
          `    function call
          }    function end
          #    #define
          )    #define end
          ~    #include
          c    class definition
          e    enum definition
          g    other global definition
          m    global enum/struct/union member definition
          s    struct definition
          t    typedef definition
          u    union definition
     A #include mark is followed by '<' or '"'  to  determine  if
     the  current  directory  should  be  searched.   An untagged
     _e_n_u_m/_s_t_r_u_c_t/_u_n_i_o_n definition has a  mark  without  a  symbol
     name  so  its  beginning can be found.  Historical note: The
     first three mark characters were chosen because they are not
     used  by  the  C  language,  but  since they can appear in a
     string constant, the tab prefix was added.  They were  never
     changed to more meaningful characters because other programs
     had been written to read the  database  file.   The  trailer
     contains  lists  of source directories, include directories,
     and source files; its format is
          <number of source directories>
          <first source directory path (always .)>
               ...
          <last source directory path>
          <number of include directories>
          <first include directory path>



Sun Release 4.1           Last change:                          8






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



               ...
          /usr/include
          <number of source and included files>
          <length of string space needed>
          <first file path>
               ...
          <last file path>

ENVIRONMENT VARIABLES
     EDITOR       Your editor, which defaults to _v_i(1).
     HOME         Your home directory, which is automatically set
                  when you login.
     INCLUDEDIRS  Colon (:)  separated  list  of  directories  to
                  search for #include files.
     MOUSE        Set to _m_y_x if that is your 5620  terminal  pro-
                  gram.
     SHELL        Your shell, which defaults to _s_h(1).
     SOURCEDIRS   Colon (:)  separated  list  of  directories  to
                  search for additional source files.
     TERM         The terminal type, which must be a screen  ter-
                  minal known
     TERMINFO     Terminal information directory full path  name.
                  If  your  terminal  is not in the standard _t_e_r_-
                  _m_i_n_f_o directory, see _c_u_r_s_e_s(3X) and _t_e_r_m_i_n_f_o(4)
                  for how to make your own terminal description.
     TMPDIR       Temporary file  directory,  which  defaults  to
                  /usr/tmp.
     VIEWER       Your file display program, which overrides EDI-
                  TOR (see above).
     VPATH        Change Management System (CMS) and  SABLE  view
                  path.   To  set  a variable such as EDITOR to a
                  value such as _e_m_a_c_s, put this in your ._p_r_o_f_i_l_e:
                  export EDITOR
                  EDITOR=emacs

FILES
     cscope.files  Default file containing -I,  -p,  -q,  and  -T
                   options and the list of source files (overrid-
                   den by the -i option).
     cscope.out    Default symbol database  file  (overridden  by
                   the -f option).  It is put in your home direc-
                   tory if it cannot be created  in  the  current
                   directory.
     cscope.in.out
     cscope.po.out Default files containing  the  inverted  index
                   for  quick  symbol  searching (-q option).  If
                   you use the -f option to rename the _c_s_c_o_p_e._o_u_t
                   file name, ._i_n and ._p_o will be suffixed to its
                   base name to create these file names.
     ncscope*.out  Temporary files containing  the  new  database
                   before  it  replaces the old database.  If you
                   use the -f option  to  rename  the  _c_s_c_o_p_e._o_u_t



Sun Release 4.1           Last change:                          9






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



                   file  name,  an _n will be prefixed to its base
                   name to create these file names.
     /usr/include  Standard directory for #include files.

BUGS
     When the -s option or  SOURCEDIRS  environment  variable  is
     used  to  specify  additional source directories, files with
     the same base name are thought to be the same file  so  only
     one will be put in the database.  The _F_u_n_c_t_i_o_n column of the
     search output for the "Find functions called by  this  func-
     tion:"  input  field  will  only  display the first function
     called in the line, that is, for this function
          e()
          {
               return(f() + g());
          }
     the display would be
          Functions called by this function: e

            File Function Line
            a.c  f        3 return(f() + g());

  C Parsing Bugs.
     Occasionally, a function  definition  or  call  may  not  be
     recognized  because  of braces inside #if statements.  Simi-
     larly, the use of a variable may be  incorrectly  recognized
     as  a  definition.   A _t_y_p_e_d_e_f name preceding a preprocessor
     statement will be incorrectly recognized as a global defini-
     tion, e.g.
          LDFILE *
          #if AR16WR
     Preprocessor statements can also prevent the recognition  of
     a global definition, e.g.
          char flag
          #ifdef ALLOCATE_STORAGE
               = -1
          #endif
          ;
     A function declaration  inside  a  function  is  incorrectly
     recognized as a function call, e.g.
          f()
          {
               void g();
     is incorrectly recognized as a call to g().

  C++ Parsing Bugs.
     Cscope recognizes C++ classes by looking for the _c_l_a_s_s  key-
     word,  but  doesn't recognize that a _s_t_r_u_c_t is also a class,
     so it doesn't recognize inline member  function  definitions
     in a structure.  It also doesn't expect the _c_l_a_s_s keyword in
     a _t_y_p_e_d_e_f, so it incorrectly recognizes X as a definition in
          typedef class X * Y;



Sun Release 4.1           Last change:                         10






CSCOPE(1)                USER COMMANDS                  CSCOPE(1)



     It also doesn't recognize operator function definitions
          Bool Feature::operator==(const Feature & other) {
     and function definitions with a function pointer argument
          ParseTable::Recognizes(int startState, char *pattern,
               int finishState, void (*FinalAction)(char *)) {

AUTHOR
     Joe Steffen















































Sun Release 4.1           Last change:                         11



