/* $Header: /usr/src/pgrm/dbx/RCS/ops.rt.c,v 1.2 91/02/01 19:05:55 rayan Exp $ */
/* $ACIS:ops.c 12.0$ */
/* $Source: /usr/src/pgrm/dbx/RCS/ops.rt.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /usr/src/pgrm/dbx/RCS/ops.rt.c,v 1.2 91/02/01 19:05:55 rayan Exp $";
#endif

/* Copyright (c) 1982 Regents of the University of California */

/*
 * Machine operators.
 */

#include "defs.h"
#include "ops.h"
#include "machine.h"

#ifndef public
typedef long YOpCode;

struct s_tXX {
    char opc[7];
    char fmt;
};

#define	BPT	0xBD00	/* breakpoint trap */

/*
 * instruction formats
 */

#define BUNK	16
#define	UNK	0
#define	JI	1
#define	RI	2
#define RI16	3
#define RR	4
#define	SRI	5
#define SRR	6
#define	R00	7
#define R0R	8
#define RRR	9
#define RC	10
#define BI	11
#define BRI	12
#define BA	13
#define DSC	14
#define DSH	15
#define DSL	16
#define DIR	17
#define DRI	18
#define DIIR	19
#define DRIR	20
#define DRRI	21
#define DTI	22

#endif

public char ltab[] = {
	2,	/* UNK  */
	2,	/* JI   */
	2,	/* RI   */
	2,	/* RI16 */
	2,	/* RR   */
	2,	/* SRI  */
	2,	/* SRR  */
	2,	/* R00  */
	2,	/* R0R  */
	2,	/* RRR  */
	2,	/* RC   */
	4,	/* BI   */
	4,	/* BRI  */
	4,	/* BA   */
	2,	/* DSC  */
	2,	/* DSH  */
	2,	/* DSL  */
	4,	/* DIR  */
	4,	/* DRI  */
	4,	/* DIIR */
	4,	/* DRIR */
	4,	/* DRRI */
	4,	/* DTI  */
};

				/* 0X format instructions - jumps */
public struct s_tXX t0X[] = {
	"j     ",	JI,
};


public char bc[17] [4] = {	/* characters for different branches */
	"   ",
	"ge ",
	"ne ",
	"le ",
	"nc ",
	"?? ",
	"no ",
	"ntb",
	"nop",
	"lt ",
	"eq ",
	"gt ",
	"c  ",
	"?? ",
	"o  ",
	"tb ",
	"?? ",
};

				/* 1X instructions - store char short */
public struct s_tXX t1X[] = {
	"stcs  ",	DSC,
};

				/* 2X instructions - store half short */
public struct s_tXX t2X[] = {
	"sths  ",	DSH,
};

				/* 3X instructions - store short */
public struct s_tXX t3X[] = {
	"sts   ",	DSL,
};

				/* 4X instructions - load char short */
public struct s_tXX t4X[] = {
	"lcs   ",	DSC,
};

				/* 5X instructions - load half alg short */
public struct s_tXX t5X[] = {
	"lhas  ",	DSH,
};

				/* 6X instructions - compute address short */
public struct s_tXX t6X[] = {
	"cas   ",	RRR,
};

				/* 7X instructions - load short */
public struct s_tXX t7X[] = {
	"ls    ",	DSL,
};

				/* 8X instructions - branches */
public struct s_tXX t8X[] = {
	"???   ",	UNK,
	"???   ",	UNK,
	"???   ",	UNK,
	"???   ",	UNK,
	"???   ",	UNK,
	"???   ",	UNK,
	"???   ",	UNK,
	"???   ",	UNK,
	"b     ",	BI,
	"b     ",	BI,
	"bala  ",	BA,
	"balax ",	BA,
	"bali  ",	BRI,
	"balix ",	BRI,
	"b     ",	BI,
	"b     ",	BI,
};

				/* 9X instructions - register ops */
public struct s_tXX t9X[] = {
	"ais   ",	RI,
	"inc   ",	RI,
	"sis   ",	RI,
	"dec   ",	RI,
	"cis   ",	RI,
	"clrsb ",	SRI,
	"mfs   ",	SRR,
	"setsb ",	SRI,
	"clrb  ",	RI,
	"clrb  ",	RI16,
	"setb  ",	RI,
	"setb  ",	RI16,
	"mftbi ",	RI,
	"mftbi ",	RI16,
	"mttbi ",	RI,
	"mttbi ",	RI16,
};

				/* AX instructions - more regs */
public struct s_tXX tAX[] = {
	"sari  ",	RI,
	"sari  ",	RI16,
	"???   ",	UNK,
	"???   ",	UNK,
	"lis   ",	RI,
	"???   ",	UNK,
	"???   ",	UNK,
	"???   ",	UNK,
	"sri   ",	RI,
	"sri   ",	RI16,
	"sli   ",	RI,
	"sli   ",	RI16,
	"srpi  ",	RI,
	"srpi  ",	RI16,
	"slpi  ",	RI,
	"slpi  ",	RI16,
};

				/* BX instructions - more regs */
public struct s_tXX tBX[] = {
	"sar   ",	RR,
	"exts  ",	RR,
	"sf    ",	RR,
	"cl    ",	RR,
	"c     ",	RR,
	"mts   ",	SRR,
	"d     ",	RR,
	"???   ",	UNK,
	"sr    ",	RR,
	"srp   ",	RR,
	"sl    ",	RR,
	"slp   ",	RR,
	"mftb  ",	RR,
	"tge   ",	RR,
	"tlt   ",	RR,
	"mttb  ",	RR,
};

				/* CX instructions */
public struct s_tXX tCX[] = {
	"svc   ",	DIR,
	"ai    ",	DRRI,
	"cal16 ",	DRIR,
	"oiu   ",	DRRI,
	"oil   ",	DRRI,
	"nilz  ",	DRRI,
	"nilo  ",	DRRI,
	"xil   ",	DRRI,
	"cal   ",	DRIR,
	"lm    ",	DRIR,
	"lha   ",	DRIR,
	"ior   ",	DRIR,
	"t     ",	DTI,
	"l     ",	DRIR,
	"lc    ",	DRIR,
	"tsh   ",	DRIR,
};

				/* DX instructions */
public struct s_tXX tDX[] = {
	"lps   ",	DIIR,
	"aei   ",	DRRI,
	"sfi   ",	DRRI,
	"cli   ",	DRI,
	"ci    ",	DRI,
	"niuz  ",	DRRI,
	"niuo  ",	DRRI,
	"xiu   ",	DRRI,
	"cau   ",	DRIR,
	"stm   ",	DRIR,
	"lh    ",	DRIR,
	"iow   ",	DRIR,
	"sth   ",	DRIR,
	"st    ",	DRIR,
	"stc   ",	DRIR,
	"???   ",	UNK,
};

				/* EX instructions */
public struct s_tXX tEX[] = {
	"abs   ",	RR,
	"a     ",	RR,
	"s     ",	RR,
	"o     ",	RR,
	"twoc  ",	RR,
	"n     ",	RR,
	"m     ",	RR,
	"x     ",	RR,
	"b     ",	RC,
	"b     ",	RC,
	"???   ",	UNK,
	"lhs   ",	R0R,
	"balr  ",	RR,
	"balrx ",	RR,
	"b     ",	RC,
	"b     ",	RC,
};

				/* FX instructions */
public struct s_tXX tFX[] = {
	"wait  ",	R00,
	"ae    ",	RR,
	"se    ",	RR,
	"ca16  ",	RR,
	"onec  ",	RR,
	"clz   ",	RR,
	"m     ",	UNK,
	"x     ",	UNK,
	"b     ",	UNK,
	"mc03  ",	RR,
	"mc13  ",	RR,
	"mc23  ",	RR,
	"mc33  ",	RR,
	"mc30  ",	RR,
	"mc31  ",	RR,
	"mc32  ",	RR,
};

public struct s_tXX *p_tXX[] = {
	t0X, t1X, t2X, t3X, t4X, t5X, t6X, t7X,
	t8X, t9X, tAX, tBX, tCX, tDX, tEX, tFX,
};

public char tc[8] [4] = {
	"nop",
	"gt ",
	"eq ",
	"ge ",
	"lt ",
	"ne ",
	"le ",
	"rap",
};

public char sr[16] [6] = {
	"scr0 ",
	"scr1 ",
	"scr2 ",
	"scr3 ",
	"scr4 ",
	"scr5 ",
	"cous ",
	"cou  ",
	"ts   ",
	"scr9 ",
	"mq   ",
	"mpcs ",
	"irb  ",
	"iar  ",
	"cs   ",
};
