/* $Header:coredump.c 12.0$ */
/* $ACIS:coredump.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ucb/dbx/ibmrt/RCS/coredump+decode+procinfo.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rt.c 12.0$";
#endif

/* Copyright (c) 1982 Regents of the University of California */

/*
 * Deal with the core dump anachronism.
 */
#include "defs.h"
#include "machine.h"
#include "process.h"
#include "runtime.h"
#include "events.h"
#include "main.h"
#include "symbols.h"
#include "source.h"
#include "mappings.h"
#include "object.h"
#include "tree.h"
#include "eval.h"
#include "keywords.h"
#include "ops.h"
/*#include <sys/dir.h>*/
#include <nlist.h>
#include <sys/exec.h>
#include <sys/ptrace.h>

#ifndef public
typedef unsigned int Address;
typedef unsigned char Byte;
typedef unsigned int Word;

#define NREG 17		/* 16 general purpose registers + PC */
#define NFLREG 64	/* up to 64 words of floating point registers */

#define ARGP 13
#define FRP 13
#define STKP 1
#define PROGCTR 16

#define CODESTART 0
#define FUNCOFFSET 0

#define BITSPERBYTE 8
#define BITSPERWORD (BITSPERBYTE * sizeof(Word))
#define WORDALIGN(a) ((a) & ~03)

#define nargspassed(frame) argn(0, frame)

#define BP_ERRNO    SIGTRAP     /* signal received at a breakpoint */
#define optab_init()

typedef short Bpinst;

extern Bpinst BP_OP;

#include "source.h"
#include "symbols.h"

#include <signal.h>
#include <sys/param.h>
#include <machine/psl.h>
#include <machine/pte.h>
#include <sys/user.h>
#undef DELETE /* XXX */
#include <sys/vm.h>
#include <machine/reg.h>

Address pc;
Address prtaddr;

#endif

typedef struct {
    Address begin;
    Address end;
    Address seekaddr;
} Map;

private Map datamap, stkmap;
private File objfile;
private struct exec hdr;

/*
 * Special variables for debugging the kernel.
 */

public integer masterpcbb;
public integer slr;
public struct pte *sbr;
public struct pcb pcb;

public getpcb ()
{
    fseek(corefile, masterpcbb & ~0x80000000, 0);
    get(corefile, pcb);
    /* pcb.pcb_p0lr &= ~AST_CLR; */
    printf("p0br %lx p0lr %lx p1br %lx p1lr %lx\n",
	pcb.pcb_p0br, pcb.pcb_p0lr, pcb.pcb_p1br, pcb.pcb_p1lr
    );
}

public copyregs (savreg, reg)
register Word *savreg, *reg;
{
    reg[0] = savreg[R0];
    reg[1] = savreg[R1];
    reg[2] = savreg[R2];
    reg[3] = savreg[R3];
    reg[4] = savreg[R4];
    reg[5] = savreg[R5];
    reg[6] = savreg[R6];
    reg[7] = savreg[R7];
    reg[8] = savreg[R8];
    reg[9] = savreg[R9];
    reg[10] = savreg[R10];
    reg[11] = savreg[R11];
    reg[12] = savreg[R12];
    reg[13] = savreg[R13];
    reg[14] = savreg[R14];
    reg[15] = savreg[R15];
    reg[PROGCTR] = savreg[IAR];
}

/*
 * Map a virtual address to a physical address.
 */

public Address vmap (addr)
Address addr;
{
    Address r;
    integer v, n;
    struct pte pte;

    r = addr & ~0xc0000000;
    v = btop(r);
    switch (addr&0xc0000000) {
	case 0xc0000000:
	case 0x80000000:
	    /*
	     * In system space, so get system pte.
	     * If it is valid or reclaimable then the physical address
	     * is the combination of its page number and the page offset
	     * of the original address.
	     */
	    if (v >= slr) {
		error("address %x out of segment", addr);
	    }
	    r = ((long) (sbr + v)) & ~0x80000000;
	    goto simple;

	case 0x40000000:
	    /*
	     * In p1 space, must not be in shadow region.
	     */
	    if (v < pcb.pcb_p1lr) {
		error("address %x out of segment", addr);
	    }
	    r = (Address) (pcb.pcb_p1br + v);
	    break;

	case 0x00000000:
	    /*
	     * In p0 space, must not be off end of region.
	     */
	    if (v >= pcb.pcb_p0lr) {
		error("address %x out of segment", addr);
	    }
	    r = (Address) (pcb.pcb_p0br + v);
	    break;

	default:
	    /* do nothing */
	    break;
    }
    /*
     * For p0/p1 address, user-level page table should be in
     * kernel virtual memory.  Do second-level indirect by recursing.
     */
    if ((r & 0x80000000) == 0) {
	error("bad p0br or p1br in pcb");
    }
    r = vmap(r);
simple:
    /*
     * "r" is now the address of the pte of the page
     * we are interested in; get the pte and paste up the physical address.
     */
    fseek(corefile, r, 0);
    n = fread(&pte, sizeof(pte), 1, corefile);
    if (n != 1) {
	error("page table botch (fread at %x returns %d)", r, n);
    }
    if (pte.pg_v == 0 and (pte.pg_fod != 0 or pte.pg_pfnum == 0)) {
	error("page no valid or reclamable");
    }
    return (addr&PGOFSET) + ((Address) ptob(pte.pg_pfnum));
}


/*
 * Target machine dependent stuff.
 */



Bpinst BP_OP = BPT;

public int rloc[] = {
    R0, R1, R2, R3, R4, R5, R6, R7, R8, R9, R10, R11, R12, R13, R14, R15, IAR
};

/*
 * Instruction decoder.
 */

#define bits(x,n,m) ((x >> (31-m)) & ((1 << (m-n+1)) - 1))
#define signed(x,n,m) ((x <<n) >> 31-m+n)

static char *buf;	/* current append string for formatted instruction */

public Address printop (addr)
Address addr;
{
    struct s_tXX *tp;
    YOpCode inst;
    int info;
    char *cp;
    char *savebp;
    char *bp;
    int ifmt;
    Address newaddr;
    char *zaps();

    bp = malloc(20);	/* alloc some space to print into */
    savebp = bp;
    buf = bp;

    iread(&inst, addr, sizeof(inst));
    tp = p_tXX[ info = bits(inst,0,3) ];
    if ( info>7 )
	tp = & tp[ bits(inst,4,7) ];
    info = ltab[ ifmt = tp->fmt];
    newaddr = addr + info;	/* add length of instruction to address */

    printf("%08x  ",addr);
    cp = tp->opc;
    bp = buf+1;
    while( *buf++ = *cp++);
    --buf;

    switch(ifmt){

	case JI:
		zaps(bp,bc[bits(inst,4,7)]);
		varput((long) addr +2*signed(inst,8,15));
		break;

	case RI:
		wreg(bits(inst,8,11));
		addc(',');
		fixput(bits(inst,12,15),0);
		break;

	case RI16:
		wreg(bits(inst,8,11));
		addc(',');
		fixput(bits(inst,12,15)+16,1);
		break;

	case RR:
		wreg(bits(inst,8,11));
		addc(',');
		wreg(bits(inst,12,15));
		break;

	case SRI:
		sreg(bits(inst,8,11));
		addc(',');
		fixput(bits(inst,12,15)+16,1);
		break;

	case SRR:
		sreg(bits(inst,8,11));
		addc(',');
		wreg(bits(inst,12,15));
		break;

	case R0R:
		wreg(bits(inst,8,11));
		addc(',');
		addc('0');
		addc('(');
		wreg(bits(inst,12,15));
		addc(')');
		break;

	case RRR:
		wreg(bits(inst,4,7));
		addc(',');
		wreg(bits(inst,8,11));
		addc(',');
		wreg(bits(inst,12,15));
		break;

	case RC:
		info = bits(inst,9,11);
		if (bits(inst,5,6))
			info += 8;
		if (!bits(inst,8,8))
			info = BUNK;
		bp = zaps(bp,bc[info]);
		*bp++ = 'r';
		if (bits(inst,7,7))
			*bp = 'x';
		wreg(bits(inst,12,15));
		break;

	case BI:
		info = bits(inst,9,11);
		if (bits(inst,5,6))
			info = info+8;
		if (!bits(inst,8,8))
			info = BUNK;
		bp = zaps(bp,bc[info]);
		if (bits(inst,7,7))
			*bp = 'x';
		varput((long) addr+2*signed(inst,12,31));
		break;

	case BRI:
		wreg(bits(inst,8,11));
		addc(',');
		varput((long) addr+2*signed(inst,12,31));
		break;

	case BA:
		wreg(15);
		addc(',');
		varput(2*bits(inst,8,30));
		break;

	case DSC:
	case DSH:
	case DSL:
		wreg(bits(inst,8,11));
		addc(',');
		varput(bits(inst,4,7) << (ifmt-DSC),0);
		if (ireg('(',bits(inst,12,15)))
			addc(')');
		break;

	case DIR:
		varput(bits(inst,16,31));
		if (ireg('(',bits(inst,12,15)))
			addc(')');
		break;

	case DRI:
		wreg(bits(inst,12,15));
		addc(',');
		vsiput(signed(inst,16,31));
		break;

	case DIIR:
		fixput(bits(inst,8,11),0);
		addc(',');
		vsiput(signed(inst,16,31));
		if (ireg('(',bits(inst,12,15)))
			addc(')');
		break;

	case DRIR:
		wreg(bits(inst,8,11));
		addc(',');
		vsiput(signed(inst,16,31));
		if (ireg('(',bits(inst,12,15)))
			addc(')');
		break;

	case DRRI:
		wreg(bits(inst,8,11));
		addc(',');
		wreg(bits(inst,12,15));
		addc(',');
		vsiput(signed(inst,16,31));
		break;

	case DTI:
		zaps(bp,tc[bits(inst,9,11)]);
		wreg(bits(inst,12,15));
		addc(',');
		vsiput(signed(inst,16,31));
		break;

	case R00:		/* unknown instruction... */
	case UNK:
		break;

	}

    addc(0x00);		/* add null at end of string */

    printf("%s\n",savebp);	/* print out the instruction */
    fflush(stdout);	/* flush the output buffer so the guy can see it */
    free(savebp);	/* free the buffer....reclaim some space */
    addr = newaddr;	/* update the address pointer */
    return(addr);
}

static addc(c) register char c; { *buf++ = c; }

static ireg(c,r) register char c; register int r;
{
    if (r){
	addc(c); wreg(r);
    }
    return(r);
}

static wreg(r)
   register int r;
{
   addc('r');
   if (r > 9){
	addc('1');
	r-= 10;
   }
   fixput(r,0);
}

static sreg(r)
   register int r;
{
   register char c, *cp;

   for(cp=sr[r]; (c = *cp) > ' '; ++cp)
	addc(c);
}

static fixput(x,i)	/* output the least significant i+1 hex digits of x */
   register long x;
   register int i;
{
   static char hexdig[17] = "0123456789ABCDEF";

   i *= 4;
   do
	addc(hexdig[(x >> i) & 0xF]);
   while ((i -= 4) >= 0);
}

static varput(x)	/* output all significant hex digits of x */
   register long x;
{
   register long mask = 0xF;
   register int i, digs=0;

   for (i=0; i<2*sizeof(long); ++i){
	if (mask & x)
	   digs = i;
	mask <<= 4;
   }
   fixput(x,digs);
}

static vsiput(x) /* output all significant hex digits of x as a signed # */
   register long x;
{
   if (x<0){
	addc('-');
	x = -x;
   }
   varput(x);
}

static char *zaps(p,q)	/* modify the substring p with the substring q and */
			/* ending with the first blank or the end or q */
   register char *p,*q;
{
   register char c;

   while((c= *q++) > ' '){
	*p++ = c;
   }

   return(p);
}

/*
 * Compute the next address that will be executed from the given one.
 * If "isnext" is true then consider a procedure call as straight line code.
 *
 * We must unfortunately do much of the same work that is necessary
 * to print instructions.  In addition we have to deal with branches.
 * Unconditional branches we just follow, for conditional branches
 * we continue execution to the current location and then single step
 * the machine.  We assume that the last argument in an instruction
 * that branches is the branch address (or relative offset).
 */

private Address dojump (startaddr, offset, delayed)
Address startaddr, offset;
boolean delayed;
{
    Address addr;

    stepto(startaddr);
    pstep(process, DEFSIG);
    addr = reg(PROGCTR);
    if (addr >= 0xe0000000) {
	addr = startaddr + offset;
	if (delayed) {
	    addr += 4;
	}
    }
    pc = addr;
    bpact();
    if (not isbperr()){
	printstatus();
    }
    return addr;
}

public Address nextaddr (startaddr, isnext)
Address startaddr;
Boolean isnext;
{
    Address addr;
    struct s_tXX *tp;
    YOpCode inst;
    int info;
    int opcode, extend;

    addr = usignal(process);
    if (addr != 0 && addr != 1) {
	dread(&addr, addr, sizeof(addr));
    } else {
	iread(&inst, startaddr, sizeof(inst));
	info = bits(inst, 0, 3);
	tp = p_tXX[info];
	opcode = info;
	extend = bits(inst, 4, 7);
	if (info > 7) {
	    tp = &tp[extend];
	}
	info = ltab[tp->fmt];
	addr = startaddr + info;		/* default next instruction */
	switch (opcode) {
	    case 0:			/* jumps - JI format */
		addr = dojump(startaddr, info, false);
		break;
	    case 8:			/* branch - check for calls */
		if (extend < 10 || extend > 13) {
		    addr = dojump(startaddr, info, false);
		} else if (isnext) {
		    if (extend == 11 || extend == 13) {
			addr += 4;
		    }
		} else {
		    addr = dojump(startaddr, info, true);
		}
		break;
	    case 0xe:		/* extended branch - calls? */
		if (extend >= 8 && extend != 11 && extend != 13) {
		    if (extend < 10 || extend == 14 || extend == 15) {
			addr = dojump(startaddr, info, false);
		    }
		} else if (isnext) {
		    if (extend == 13) {
			addr += 4;
		    }
		} else {
		    addr = dojump(startaddr, info, true);
		}
		break;
	    /*
	     * 1 STCS, 2 STHS, 3 STS, 4 LCS, 5 LHAS, 6 CAS,
	     * 7 LS, {9,10,11,15} R format, 12 SVC, 13 CLI
	     */
	    default:
		break;
	}
    }
    return addr;
}

/*
 * Enter a procedure by creating and executing a call instruction.
 */

#define CALLSIZE 4	/* size of call instruction */

public beginproc (p, argc)
Symbol p;
int argc;
{
    Word dest;
    Word save, callinst;
    Address addr;
    Name n;
    Symbol data;
    char buf[100];

    sprintf(buf, ".%s", symname(p));
    n = identname(buf, false);
    data = lookup(n);
    if (data == nil || data->class != VAR) {
	error("no data area for %s\n", symname(p));
    }
    addr = 4;
    iread(&save, addr, CALLSIZE);
    pc = 6;
    dest = codeloc(p);
    callinst = 0xdb00ecff;
    iwrite(&callinst, addr, CALLSIZE);
    setreg(15, dest);
    setreg(PROGCTR, pc);
    setreg(0, data->symvalue.offset);
    pstep(process, DEFSIG);
    iwrite(&save, addr, CALLSIZE);
    pc = reg(PROGCTR);
    if (not isbperr()) {
	printstatus();
    }
}

/*
 * Extract a bit field from an integer.
 */

public integer extractField (s)
Symbol s;
{
    integer nbytes, nbits, n, r, off, len;

    off = s->symvalue.field.offset;
    len = s->symvalue.field.length;
    nbytes = size(s);
    n = 0;
    if (nbytes > sizeof(n)) {
	printf("[bad size in extractField -- word assumed]\n");
	nbytes = sizeof(n);
    }
    popn(nbytes, ((char *) &n) + (sizeof(Word) - nbytes));
    nbits = nbytes * BITSPERBYTE;
    r = n >> (nbits - ((off mod nbits) + len));
    r &= ((1 << len) - 1);
    return r;
}

/*
 * Change the length of a value in memory according to a given difference
 * in the lengths of its new and old types.
 */

public loophole (oldlen, newlen)
integer oldlen, newlen;
{
    integer i, n;
    Stack *oldsp;

    n = newlen - oldlen;
    oldsp = sp - oldlen;
    if (n > 0) {
	for (i = oldlen - 1; i >= 0; i--) {
	    oldsp[n + i] = oldsp[i];
	}
	for (i = 0; i < n; i++) {
	    oldsp[i] = '\0';
	}
    } else {
	for (i = 0; i < newlen; i++) {
	    oldsp[i] = oldsp[i - n];
	}
    }
    sp += n;
}

/*
 * Machine/system dependent process access.
 */


#ifndef public

#include "main.h"
#include "machine.h"

/*
 * Cache of instruction space.
 */

#define CACHESIZE 1003

typedef struct {
    Word addr;
    Word val;
} CacheWord;

/*
 * Information about a process.
 */

#define packedbits(n) (((n) + 31) >> 5)
#define NREGBITS packedbits(NREG + NFLREG)
#define regword(n) (n >> 5)
#define regbit(n) (1 << (n & 037))

struct Process {
    int pid;			/* process being traced */
    unsigned valid[NREGBITS];	/* valid bits for registers */
    unsigned xdirty[NREGBITS];	/* dirty bits for registers */
    Word reg[NREG+NFLREG];	/* process' registers */
    Word oreg[NREG+NFLREG];	/* process' old registers */
    short status;		/* either STOPPED or FINISHED */
    short signo;		/* signal that stopped process */
    short sigcode;		/* extra signal information */
    int exitval;		/* return value from exit() */
    long sigset;		/* bit array of traced signals */
    CacheWord word[CACHESIZE];	/* text segment cache */
    Ttyinfo ttyinfo;		/* process' terminal characteristics */
    Address sigstatus;		/* process' handler for current signal */
    unsigned mask;
    Word *ureg;			/* u_ar0 offset */
};

/*
 * Compute the cache location for a given address.
 * This function assumes that the cache size is a power of two.
 */

#define cachehash(addr) (((addr) >> 2) & (CACHESIZE-1))

/*
 * User structure and register access.
 */

struct user *uoffset;

#define readreg(p, r)		ptrace(PT_READ_U, p->pid, p->ureg+rloc[r], 0)
#define writereg(p, r, v)	ptrace(PT_WRITE_U, p->pid, p->ureg+rloc[r], v)

#define readflreg(p, r)		ptrace(PT_READ_F, p->pid, r, 0)
#define writeflreg(p, r, v)	ptrace(PT_WRITE_F, p->pid, r, v)

#define ar0(v)			((Word *) ((int)(v) + ctob(UPAGES) - ENDOFP1))

#endif

/*
 * Define register symbols.
 */

public defregsyms ()
{
    register int i;
    char buf[10];

    for (i = 0; i < NREG; i++) {
	sprintf(buf, "$r%d", i);
	defregname(identname(buf, false), i);
    }
    for (i = 0; i < NFLREG; i++) {
	sprintf(buf, "$fr%d", i);
	defregname(identname(buf, false), i + NREG);
    }
    defregname(identname("$ap", true), ARGP);
    defregname(identname("$fp", true), FRP);
    defregname(identname("$sp", true), STKP);
    defregname(identname("$pc", true), PROGCTR);
    getuoffset();
}

/*
 * Set up which signals will be caught and ignored by default.
 */

public setsigtrace (p)
register Process p;
{
    register int i;

    for (i = 1; i <= NSIG; i++) {
	psigtrace(p, i, true);
    }
    psigtrace(p, SIGHUP, false);
    psigtrace(p, SIGKILL, false);
    psigtrace(p, SIGALRM, false);
    psigtrace(p, SIGTSTP, false);
    psigtrace(p, SIGCONT, false);
    psigtrace(p, SIGCHLD, false);
}

/*
 * Adjust the pc if necessary after a stop.
 */

public adjustpc (p, op)
Process p;
int op;
{
    /* nothing to do */
    /* on m68000, if op is PT_STEP add 2, otherwise subtract 2 on SIGTRAPs */
}

public uinit (p)
Process p;
{
    p->ureg = ar0(ptrace(PT_READ_U, p->pid, &uoffset->u_ar0, 0));
}

private getuoffset ()
{
    struct nlist list[] = { { "userSIZE" }, { "" } };

    nlist("/vmunix", list);
    if (list[0].n_type == 0) {
	warning("can't find userSIZE symbol");
    }
    uoffset = (struct user *) (ctob(UPAGES) - list[0].n_value);
}


public Word getfloatmask(p)
   Process p;

{
  long floatmask;

    floatmask = ptrace(PT_READ_U, p->pid, &uoffset->u_floatmask, 0);
    return floatmask; 
}
 
/*
 * Decode and print the instructions within the given address range.
 */

public printinst (lowaddr, highaddr)
Address lowaddr;
Address highaddr;
{
    register Address addr;

    for (addr = lowaddr; addr <= highaddr; ) {
	addr = printop(addr);
    }
    prtaddr = addr;
}

/*
 * Another approach:  print n instructions starting at the given address.
 */

public printninst (count, addr)
int count;
Address addr;
{
    register Integer i;
    register Address newaddr;

    if (count <= 0) {
	error("non-positive repetition count");
    } else {
	newaddr = addr;
	for (i = 0; i < count; i++) {
	    newaddr = printop(newaddr);
	}
	prtaddr = newaddr;
    }
}

/*
 * Print the contents of the addresses within the given range
 * according to the given format.
 */

typedef struct {
    String name;
    String printfstring;
    int length;
} Format;

private Format fmt[] = {
    { "d", " %d", sizeof(short) },
    { "D", " %ld", sizeof(long) },
    { "o", " %o", sizeof(short) },
    { "O", " %lo", sizeof(long) },
    { "x", " %04x", sizeof(short) },
    { "X", " %08x", sizeof(long) },
    { "b", " \\%o", sizeof(char) },
    { "c", " '%c'", sizeof(char) },
    { "s", "%c", sizeof(char) },
    { "f", " %f", sizeof(float) },
    { "g", " %g", sizeof(double) },
    { nil, nil, 0 }
};

private Format *findformat (s)
String s;
{
    register Format *f;

    f = &fmt[0];
    while (f->name != nil and not streq(f->name, s)) {
	++f;
    }
    if (f->name == nil) {
	error("bad print format \"%s\"", s);
    }
    return f;
}

/*
 * Retrieve and print out the appropriate data in the given format.
 * Floats have to be handled specially to allow the compiler to
 * convert them to doubles when passing to printf.
 */

private printformat (fmt, addr)
Format *fmt;
Address addr;
{
    char c;
    short s;
    long i;
    float f;
    double d;

    switch (fmt->name[0]) {
	case 'b':
	case 'c':
	case 's':
	    dread(&c, addr, sizeof(c));
	    printf(fmt->printfstring, c);
	    break;
	case 'd':
	case 'o':
	case 'x':
	    dread(&s, addr, sizeof(s));
	    printf(fmt->printfstring, s);
	    break;
	case 'D':
	case 'O':
	case 'X':
	    dread(&i, addr, sizeof(i));
	    printf(fmt->printfstring, i);
	    break;
	case 'f':
	    dread(&f, addr, sizeof(f));
	    printf(fmt->printfstring, f);
	    break;
	case 'g':
	    dread(&d, addr, sizeof(d));
	    printf(fmt->printfstring, d);
	    break;
	default:
	    badcaseval(fmt->name);
    }
}

public Address printdata (lowaddr, highaddr, format)
Address lowaddr;
Address highaddr;
String format;
{
    int n;
    register Address addr;
    Format *f;

    if (lowaddr > highaddr) {
	error("first address larger than second");
    }
    f = findformat(format);
    n = 0;
    for (addr = lowaddr; addr <= highaddr; addr += f->length) {
	if (n == 0) {
	    printf("%08x: ", addr);
	}
	printformat(f, addr);
	++n;
	if (n >= (16 div f->length)) {
	    printf("\n");
	    n = 0;
	}
    }
    if (n != 0) {
	printf("\n");
    }
    prtaddr = addr;
    return addr;
}

/*
 * The other approach is to print n items starting with a given address.
 */

public printndata (count, startaddr, format)
int count;
Address startaddr;
String format;
{
    int i, n;
    Address addr;
    Format *f;
    Boolean isstring;
    char c;

    if (count <= 0) {
	error("non-positive repetition count");
    }
    f = findformat(format);
    isstring = (Boolean) streq(f->name, "s");
    n = 0;
    addr = startaddr;
    for (i = 0; i < count; i++) {
	if (n == 0) {
	    printf("%08x: ", addr);
	}
	if (isstring) {
	    printf("\"");
	    dread(&c, addr, sizeof(char));
	    while (c != '\0') {
		printchar(c);
		++addr;
		dread(&c, addr, sizeof(char));
	    }
	    printf("\"\n");
	    n = 0;
	    addr += sizeof(String);
	} else {
	    printformat(f, addr);
	    ++n;
	    if (n >= (16 div f->length)) {
		printf("\n");
		n = 0;
	    }
	    addr += f->length;
	}
    }
    if (n != 0) {
	printf("\n");
    }
    prtaddr = addr;
}

/*
 * Print out a value according to the given format.
 */

public printvalue (v, format)
long v;
String format;
{
    Format *f;
    char *p, *q;

    f = findformat(format);
    if (streq(f->name, "s")) {
	putchar('"');
	p = (char *) &v;
	q = p + sizeof(v);
	while (p < q) {
	    printchar(*p);
	    ++p;
	}
	putchar('"');
    } else {
	printf(f->printfstring, v);
    }
    putchar('\n');
}

/*
 * Print out an execution time error.
 * Assumes the source position of the error has been calculated.
 *
 * Have to check if the -r option was specified; if so then
 * the object file information hasn't been read in yet.
 */

public printerror ()
{
    extern Integer sys_nsig;
    extern String sys_siglist[];
    integer err;

    if (isfinished(process)) {
	err = exitcode(process);
	if (err == 0) {
	    printf("\"%s\" terminated normally\n", objname);
	} else {
	    printf("\"%s\" terminated abnormally (exit code %d)\n",
		objname, err
	    );
	}
	erecover();
    }
    err = errnum(process);
    putchar('\n');
    printsig(err);
    putchar(' ');
    printloc();
    putchar('\n');
    if (curline > 0) {
	printlines(nil, curline, curline);
    } else {
	printinst(pc, pc);
    }
    erecover();
}

/*
 * Print out a signal.
 */

private String illinames[] = {
    "reserved addressing fault",
    "priviliged instruction fault",
    "reserved operand fault"
};

private String fpenames[] = {
    nil,
    "integer overflow trap",
    "integer divide by zero trap",
    "floating overflow trap",
    "floating/decimal divide by zero trap",
    "floating underflow trap",
    "decimal overflow trap",
    "subscript out of range trap",
    "floating overflow fault",
    "floating divide by zero fault",
    "floating undeflow fault"
};

public printsig (signo)
integer signo;
{
    integer code;

    if (signo < 0 or signo > sys_nsig) {
	printf("[signal %d]", signo);
    } else {
	printf("%s", sys_siglist[signo]);
    }
    code = errcode(process);
    if (signo == SIGILL) {
	if (code >= 0 and code < sizeof(illinames) / sizeof(illinames[0])) {
	    printf(" (%s)", illinames[code]);
	}
    } else if (signo == SIGFPE) {
	if (code > 0 and code < sizeof(fpenames) / sizeof(fpenames[0])) {
	    printf(" (%s)", fpenames[code]);
	}
    }
}

/*
 * Note the termination of the program.  We do this so as to avoid
 * having the process exit, which would make the values of variables
 * inaccessible.  We do want to flush all output buffers here,
 * otherwise it'll never get done.
 */

public endprogram ()
{
    int exitcode;

    printnews();
    exitcode = argn(1, nil);
    if (exitcode != 0) {
	printf("\nexecution completed (exit code %d)\n", exitcode);
    } else {
	printf("\nexecution completed\n");
    }
    getsrcpos();
    erecover();
}

/*
 * Single step the machine a source line (or instruction if "inst_tracing"
 * is true).  If "isnext" is true, skip over procedure calls.
 */

public dostep (isnext)
Boolean isnext;
{
    register Address addr;
    register Lineno line;
    String filename;
    Symbol s;

    addr = nextaddr(pc, isnext);
    if (not inst_tracing and nlhdr.nlines != 0) {
	line = linelookup(addr);
	while (line == 0 && (s = whatblock(addr)) && !nosource(s)) {
	    addr = nextaddr(addr, isnext);
	    line = linelookup(addr);
	}
	curline = line;
    } else {
	curline = 0;
    }
    stepto(addr);
    filename = srcfilename(addr);
    setsource(filename);
}

/*
 * Setting a breakpoint at a location consists of saving
 * the word at the location and poking a BP_OP there.
 *
 * We save the locations and words on a list for use in unsetting.
 */

typedef struct Savelist *Savelist;

struct Savelist {
    Address location;
    Bpinst save;
    short refcount;
    Savelist link;
};

private Savelist savelist;

/*
 * Set a breakpoint at the given address.  Only save the word there
 * if it's not already a breakpoint.
 */

public setbp (addr)
Address addr;
{
    Bpinst w, save;
    register Savelist newsave, s;

    for (s = savelist; s != nil; s = s->link) {
	if (s->location == addr) {
	    s->refcount++;
	    return;
	}
    }
    iread(&save, addr, sizeof(save));
    newsave = new(Savelist);
    newsave->location = addr;
    newsave->save = save;
    newsave->refcount = 1;
    newsave->link = savelist;
    savelist = newsave;
    w = BP_OP;
    iwrite(&w, addr, sizeof(w));
}

/*
 * Unset a breakpoint; unfortunately we have to search the SAVELIST
 * to find the saved value.  The assumption is that the SAVELIST will
 * usually be quite small.
 */

public unsetbp (addr)
Address addr;
{
    register Savelist s, prev;

    prev = nil;
    for (s = savelist; s != nil; s = s->link) {
	if (s->location == addr) {
	    iwrite(&s->save, addr, sizeof(s->save));
	    s->refcount--;
	    if (s->refcount == 0) {
		if (prev == nil) {
		    savelist = s->link;
		} else {
		    prev->link = s->link;
		}
		dispose(s);
	    }
	    return;
	}
	prev = s;
    }
    panic("unsetbp: couldn't find address %d", addr);
}


/*
 * Determine whether a function returns a multi-word value
 * whose address is passed as an invisible first argument.
 */

public boolean multiword (f)
Symbol f;
{
    register boolean r;
    register Symbol t;

    if (f == nil) {
	r = false;
    } else {
	t = rtype(f->type);
	r = (boolean) (t->class == RECORD || t->class == VARNT);
    }
    return r;
}

