/* $Header: /usr/src/pgrm/dbx/RCS/runtime.rt.c,v 1.2 90/11/06 09:03:01 rayan Exp $ */
/* $Source: /usr/src/pgrm/dbx/RCS/runtime.rt.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /usr/src/pgrm/dbx/RCS/runtime.rt.c,v 1.2 90/11/06 09:03:01 rayan Exp $";
#endif


/* Copyright (c) 1982 Regents of the University of California */

/*
 * Runtime organization dependent routines, mostly dealing with
 * activation records.
 */

#define NFLREG 64   /* up to 64 words of floating point registers */
#define NSAVEREG NREG+NFLREG 

#include "defs.h"
#include "runtime.h"
#include "process.h"
#include "machine.h"
#include "events.h"
#include "mappings.h"
#include "symbols.h"
#include "tree.h"
#include "eval.h"
#include "operators.h"
#include "object.h"
#include <signal.h>
#include <sys/param.h>

#ifndef public
typedef struct Frame *Frame;

#include "machine.h"
#endif

private Boolean walkingstack = false;

typedef struct {
    Node callnode;
    Node cmdnode;
    boolean isfunc;
} CallEnv;

private CallEnv endproc;

typedef enum {
    Unknown, AIX_C, Assembler, startup, Signal, As2, X6, normal, Ada,
    nFrameTypes
} FrameType;

struct Frame {
    int condition_handler;
    Address ap;			/* argument pointer */
    Address fp;			/* frame pointer */
    Address pc;			/* program counter */
    Word reg[NSAVEREG];		/* not necessarily there */

    /*
     * Extra stuff for RT PC.  Compilers generate a table
     * at the end of each routine with information
     * necessary for examining stack frames.
     * Below is the information we extract from the table.
     */
    boolean prolog;		/* pc is in prolog */
    FrameType rtype;
    int foffset;		/* offset from frame pointer to top of stack */
    short firstreg;		/* first general register saved */
    short firstfreg;		/* first floating register saved */
    short regoff;		/* address of first saved general register */
    short fregoff;		/* address of first saved floating register */
    short fptr;			/* register used as frame ptr */
    short nparams;		/* number of words of parameters */
    short paramloc[4];		/* param locs: 0 => stack, reg otherwise */
};

#define savepc(frp) ((frp)->pc)
#define frameeq(f1, f2) ((f1)->pc == (f2)->pc)

#define inSignalHandler(addr) ((addr) > 0x10000000 && (addr) < 0x20000000)

public Frame curframe = nil;
struct Frame curframerec;

typedef enum { okay, stackend, complain } UnwindType;

static UnwindType unwind[nFrameTypes] = {
    complain, complain, okay, stackend, complain, okay, complain, okay, okay
};

/*
 * Trace table structures.
 */

typedef struct {
    char flag1;		/* always 0xDF */
    char rtype;		/* routine type (massive overkill) */
    char flag2;		/* always 0xDF */
    u_int gprs : 4;	/* first GPR saved */
    u_int got_w : 1;	/* true if w_byte extension present */
    u_int got_x : 1;	/* true if x_byte extension present */
    u_int got_y : 1;	/* true if y_byte extension present */
    u_int got_z : 1;	/* true if z_byte extension present */
} TraceBase;

typedef struct {	/* present if got_w above is true */
    u_int npars : 4;	/* number of parameter words */
    u_int fp_reg : 4;	/* reg used as frame ptr */
} TraceParams;

typedef struct {	/* present if got_x above is true */
    u_int fprs : 4;	/* first float register saved 0=none */
    u_int p0inreg : 1;	/* true if parameter word 0 left in register */
    u_int p1inreg : 1;	/* true if parameter word 1 left in register */
    u_int p2inreg : 1;	/* true if parameter word 2 left in register */
    u_int p3inreg : 1;	/* true if parameter word 3 left in register */
} TraceFloats;

typedef struct {	/* routine offset information */
    u_int osize : 2;	/* number of bytes in size field -1 */
    u_int fsize : 6;	/* top 6 bits of word in frame */
    char fext[3];	/* upto 3 more bytes of size field */
} TraceOffset;

#ifndef OLDCC
#   define LINKSIZE	20	/* bytes in the black hole in the stack frame*/
#   define REGARGSIZE	16
#   define YFIXUP	0
#else
#   define LINKSIZE	0	/* not used in old calling convention */
#   define REGARGSIZE	0
#   define YFIXUP	16
#endif

#define LastGPRsaved	15	/* last general register to save */
#define LastFPRsaved	5	/* last FP register to save (6 not preserved)*/
#define MaxGPRsave	64	/* bytes in maximum GP register save area */
#define MaxFPRsave	64	/* bytes in maximum FP register save area */

#define MAXSAVE (LINKSIZE + REGARGSIZE + 10*sizeof(Word) + 4*sizeof(double))

/*
 * Move the object address for a procedure or function up the
 * appropriate amount.
 */

public findbeginning (f)
Symbol f;
{
    f->symvalue.funcv.beginaddr += FUNCOFFSET;
}

/*
 * Check to see that a given address is a legitimate code address and
 * generate a message if not.
 */

private boolean ValidText (addr)
Address addr;
{
    if (addr >= objsize) {
	warning("text address 0x%x too high (max = 0x%x)", addr, objsize);
	return false;
    } else if ((addr & 0xf0000000) != 0) {
	warning("bad text address 0x%x", addr);
	return false;
    }
    return true;
}

/*
 * Find the address of the trace table following the procedure
 * at the given address.  Return true if there is one, and read the table
 * information into the given frame.
 */

private boolean findtable (addr, frp)
Address addr;
Frame frp;
{
    register Address a;
    char buf[4];

    addr = tracetable_addr(addr);

    for (a = addr; ; a++) {
	if (!ValidText(a)) {
	    break;
	}
	iread(buf, a, sizeof(buf));
	if (buf[0] == 0xdf && buf[2] == 0xdf) {
	    readtable(a, frp);
	    return true;
	}
	if (buf[1] != 0xdf) {
	    ++a;
	    if (buf[2] != 0xdf) {
		++a;
		if (buf[3] != 0xdf) {
		    ++a;
		}
	    }
	}
    }
    return false;
}

private readtable (startaddr, frp)
Address startaddr;
register Frame frp;
{
    Address addr;
    TraceBase tbase;
    register int i;

    for (i = 0; i < 4; i++) {
	frp->paramloc[i] = i + 2;
    }
    addr = startaddr;
    iread(&tbase, addr, 4);
    addr += 4;
    frp->rtype = (FrameType) tbase.rtype;
    frp->firstreg = tbase.gprs ? tbase.gprs : 16;
    readw(tbase.got_w, &addr, frp);
    readx(tbase.got_x, &addr, frp);
    if (tbase.got_y) {
	++addr;
    }
    if (tbase.got_z) {
	++addr;
    }
    readoff(&addr, frp);
    frp->regoff = frp->foffset - (4*(16-frp->firstreg)+LINKSIZE+REGARGSIZE);
    if (frp->firstfreg <= LastFPRsaved) {
	frp->fregoff = frp->regoff - 8 * (LastFPRsaved + 1 - frp->firstfreg);
    } else {
	frp->fregoff = frp->regoff;
    }
}

private readw (optw, addr, frp)
boolean optw;
Address *addr;
Frame frp;
{
    TraceParams tp;

    if (optw) {
	iread(&tp, *addr, 1);
	*addr += 1;
	frp->nparams = tp.npars;
	frp->fptr = tp.fp_reg;
    } else {
	frp->nparams = 0;
	frp->fptr = 1;
    }
}

private readx (optx, addr, frp)
boolean optx;
Address *addr;
Frame frp;
{
    TraceFloats tf;
    register unsigned mask, tfmask;
    int i;

    if (optx) {
	iread(&tf, *addr, 1);
	*addr += 1;
	frp->firstfreg = tf.fprs;
	mask = 0x8;
	tfmask = *(char *)&tf;
	for (i = 2; i <= 5; i++) {
	    if ((tfmask & mask) != 0) {
		frp->paramloc[i-2] = i;
	    }
	    mask >>= 1;
	}
    } else {
	frp->firstfreg = 7;
    }
}

private readoff (addr, frp)
register Address *addr;
Frame frp;
{
    TraceOffset toff;
    unsigned char t;
    unsigned int off;
    int i, nbytes;

    if (frp->rtype == Assembler || frp->rtype == As2) {
	frp->foffset = 0;
    } else {
	iread(&toff, *addr, 1);
	*addr += 1;
	nbytes = toff.osize;
	off = toff.fsize;
	for (i = 0; i < nbytes; i++) {
	    off <<= 8;
	    iread(&t, *addr, 1);
	    *addr += 1;
	    off |= t;
	}
	frp->foffset = off << 2;
    }
}

public boolean isprolog (addr)
Address addr;
{
    Symbol f;

    f = whatblock(addr);
    while (isinline(f)) {
	f = container(f);
    }
    return (boolean) (addr <= (codeloc(f) + 8));
}

/*
 * Set a frame to the current activation record.
 */

public getcurframe (frp)
register Frame frp;
{
    register Address a;
    register int i;

    a = reg(PROGCTR);
    if (findtable(a, frp)) {
	frp->prolog = isprolog(a);
	frp->pc = a;
	frp->fp = reg(frp->fptr);
	frp->ap = frp->fp + frp->foffset - REGARGSIZE;
	for (i = 0; i < NSAVEREG; i++) {
	    frp->reg[i] = reg(i);
	}
    }
	else { error("getcurframe: findframe failed for addr 0x%x\n",a); }
}

/*
 * Return a pointer to the next activation record up the stack or
 * nil if there is none.  Normally, this routine writes over
 * the given Frame space; therefore it is important to perform
 * the field assignments in the correct order.
 */

public Frame nextframe (frp)
register Frame frp;
{
    register Word *r;
    struct Frame frame;
    Address callpc, off;
    struct sigcontext *sc;
    int i;

    if (unwind[(int)frp->rtype] != okay) {
	if (unwind[(int)frp->rtype] != stackend) {
	    warning("routine type %d not supported", frp->rtype);
	}
	return nil;
    }
    if (frp->prolog) {
	callpc = frp->reg[15]-4;
    } else {
	dread(&callpc, frp->ap - LINKSIZE - 4, sizeof(callpc));
	callpc -= 4;
    }
    if (inSignalHandler(callpc)) {
	sc = (struct sigcontext *) (frp->reg[1] + 3*sizeof(Word));
	dread(&callpc, &sc->sc_pc, sizeof(callpc));
	dread(frp->reg, ((Word *) &sc[1]) + 1, sizeof(frp->reg));
	frp->prolog = isprolog(callpc);
    } else if (!ValidText(callpc)) {
	return nil;
    } else if (!frp->prolog) {
	off = frp->fp + frp->regoff;
	for (r = &frp->reg[frp->firstreg]; r < &frp->reg[NSAVEREG]; r++) {
	    dread(r, off, sizeof(*r));
	    off += sizeof(*r);
	}
    } else {
	frp->prolog = false;
    }
    if (!findtable(callpc, &frame)) {
	warning("can't find trace table");
	return nil;
    }
    frp->rtype = frame.rtype;
    frp->foffset = frame.foffset;
    frp->fp = frp->reg[frame.fptr];
    frp->ap = frp->fp + frp->foffset - REGARGSIZE;
    frp->pc = callpc;
    frp->nparams = frame.nparams;
    frp->firstreg = frame.firstreg;
    frp->firstfreg = frame.firstfreg;
    frp->regoff = frame.regoff;
    frp->fregoff = frame.regoff;
    frp->fptr = frame.fptr;
    for (i = 0; i < 4; i++) {
	frp->paramloc[i] = frame.paramloc[i];
    }
    return frp;
}

/*
 * If the given parameter is currently in a register,
 * return the register number; otherwise return -1.
 */

public int preg (param, optfrp)
Symbol param;
Frame optfrp;
{
    register Symbol p;
    register int r, off;
    Frame frp;

    r = -1;
    if (param->block == nil) {
	error("[internal error: nil function containing parameter %s]",
	    symname(param)
	);
    }
    p = param->block->chain;
    if (p == nil) {
	error("[internal error: nil paramlist for function containing %s]",
	    symname(param)
	);
    }
    if (multiword(param->block)) {
	off = 3;
    } else {
	off = 2;
    }
    for (; off <= 5; off++) {
	if (p == param) {
	    if (optfrp == nil) {
		frp = findframe(p->block);
	    } else {
		frp = optfrp;
	    }
	    checkref(frp);
	    if (frp->prolog) {
		r = off;
	    }
	    break;
	}
	p = p->chain;
    }
    return r;
}

/*
 * Return the base address for arguments in the given frame.
 */

public Address args_base (optfrp)
Frame optfrp;
{
    struct Frame frame;
    register Frame frp;

    if (optfrp == nil) {
	getcurframe(&frame);
	frp = &frame;
    } else {
	frp = optfrp;
    }
    return frp->prolog ? (frp->reg[1] - REGARGSIZE) : frp->ap;
}

/*
 * Return the base address for locals in the given frame.
 */

public Address locals_base (optfrp)
Frame optfrp;
{
    struct Frame frame;
    register Frame frp;
    Address base;

    if (optfrp == nil) {
	getcurframe(&frame);
	frp = &frame;
    } else {
	frp = optfrp;
    }
    base = frp->prolog ? (frp->reg[1] - frp->foffset) : frp->fp;
    return base + frp->fregoff;
}

/*
 * Return saved register n from the given frame.
 */

public Word savereg (n, frp)
integer n;
Frame frp;
{
    Word w;

    if (frp == nil) {
	w = reg(n);
    } else {
	switch (n) {
	    case FRP:
		w = frp->fp;
		break;

	    case STKP:
		w = reg(STKP);
		break;

	    case PROGCTR:
		w = frp->pc;
		break;

	    default:
		if (n < 0 or n >= NSAVEREG) {
		    panic("savereg out of range (%d)", n);
		}
		w = frp->reg[n];
		break;
	}
    }
    return w;
}

/*
 * Set the registers according to the given frame pointer.
 */

public getnewregs (addr)
Address addr;
{
    struct Frame frame;

    dread(&frame, addr, sizeof(frame));
    setreg(FRP, frame.fp);
    setreg(PROGCTR, frame.pc);
    pc = frame.pc;
    setcurfunc(whatblock(pc));
}

/*
 * Set saved register n in the given frame.
 */

public setsavereg (n, frp, w)
Integer n;
Frame frp;
Word w;
{
    if (frp == nil) {
	setreg(n,w);
	return;
    }
    switch (n) {
	case FRP:
	    frp->fp = w;
	    break;

	case STKP:
	    setreg(STKP,w);
	    break;

	case PROGCTR:
	    frp->pc = w;
	    break;

	default:
	    assert(n >= 0 and n < NSAVEREG);
	    frp->reg[n] = w;
	    break;
    }
}

/*
 * Return the nth argument of the given frame.
 * If the frame is nil, use the current one.
 */

public Word argn (n, optfrp)
int n;
Frame optfrp;
{
    Word w;
    register Frame frp;
    struct Frame frame;

    if (optfrp == nil) {
	getcurframe(&frame);
	frp = &frame;
    } else {
	frp = optfrp;
    }
    if (n == 0) {
	w = frp->nparams;
    } else if (n >= 1 && n <= 4 && frp->paramloc[n-1] != 0) {
	w = reg(frp->paramloc[n-1]);
    } else {
	dread(&w, args_base(frp) + ((n-1) * sizeof(Word)), sizeof(w));
    }
    return w;
}

/*
 * Push the arguments on the process' stack.  We do this by first
 * evaluating them on the "eval" stack, then copying into the process'
 * space.
 */

public integer pushargs (proc, arglist)
Symbol proc;
Node arglist;
{
    Stack *savesp;
    Word paramreg[4];
    int n, r, argc, args_size;

    savesp = sp;
    if (varIsSet("$unsafecall")) {
	argc = unsafe_evalargs(proc, arglist);
    } else {
	argc = evalargs(proc, arglist);
    }
    args_size = sp - savesp;
    if (args_size > 0) {
	if (args_size > sizeof(paramreg)) {
	    n = sizeof(paramreg) / sizeof(Word);
	    mov(savesp, paramreg, sizeof(paramreg));
	    args_size -= sizeof(paramreg);
	    setreg(STKP, reg(STKP) - args_size);
	    dwrite(savesp + sizeof(paramreg), reg(STKP), args_size);
	} else {
	    n = args_size / sizeof(Word);
	    mov(savesp, paramreg, args_size);
	}
	for (r = 0; r < n; r++) {
	    setreg(r+2, paramreg[r]);
	}
    }
    sp = savesp;
    return argc;
}

/*
 * Pass an expression to a particular parameter.
 *
 * Normally we pass either the address or value, but in some cases
 * (such as C strings) we want to copy the value onto the stack and
 * pass its address.
 *
 * Another special case raised by strings is the possibility that
 * the actual parameter will be larger than the formal, even with
 * appropriate type-checking.  This occurs because we assume during
 * evaluation that strings are null-terminated, whereas some languages,
 * notably Pascal, do not work under that assumption.
 */

public passparam (actual, formal)
Node actual;
Symbol formal;
{
    Address addr;
    Stack *savesp;
    integer actsize, formsize;

    if (formal != nil and isvarparam(formal) and
	(not isopenarray(formal->type))
    ) {
	addr = lval(actual->value.arg[0]);
	push(Address, addr);
    } else if (passaddr(formal, actual->nodetype)) {
	savesp = sp;
	eval(actual);
	actsize = sp - savesp;
	setreg(STKP,
	    reg(STKP) - ((actsize + sizeof(Word) - 1) & ~(sizeof(Word) - 1))
	);
	dwrite(savesp, reg(STKP), actsize);
	sp = savesp;
	push(Address, reg(STKP));
	if (formal != nil and isopenarray(formal->type)) {
	    push(integer, actsize div size(formal->type->type));
	}
    } else if (formal != nil) {
	formsize = size(formal);
	savesp = sp;
	eval(actual);
	actsize = sp - savesp;
	if (actsize > formsize) {
	    sp -= (actsize - formsize);
	}
    } else {
	eval(actual);
    }
}

/*
 * Push the value associated with the current function.
 */

#define isdouble(t) ( t->class == RANGE && \
    (t->symvalue.rangev.upper == 0 && t->symvalue.rangev.lower == 8) )

#define isfloat(t) ( t->class == RANGE && \
    (t->symvalue.rangev.upper == 0 && t->symvalue.rangev.lower == 4) )

public pushretval (s)
     Symbol s;
{
    int len;
    boolean indirect;
    Symbol t;
    Word reg2;
    union {
	double	d;
	float f;
	long	l[2];
    }	u;

    len = size(s);
    t = rtype(s);
    indirect = (t->class == RECORD || t->class == VARNT );

    reg2 = reg(2);	/* funky RT function return in r2 */

    if ( indirect ){
	rpush((Address) reg2, len);
    } 
    else if ( isfloat(t) ){ /* in case they use float regs someday.. */
       u.l[0] = reg2;
       push(float, u.f);
    }
    else if ( isdouble(t) ){
       u.l[0] = reg2;
       u.l[1] = reg(3);
       push(double, u.d )
    }
    else {
	switch ( len ){
	 case sizeof(char):
	   push(char, reg2);
	   break;

	 case sizeof(short):
	   push(short, reg2);
	   break;

	 default:
	   if ( len == sizeof(Word) ){
	      push(Word, reg2);
	   } 
	   else if ( len == 2*sizeof(Word) ){
	      push(Word, reg2);
	      push(Word, reg(3));
	   } 
	   else {
	      error("[internal error: bad size %d in pushretval]", len);
	   }
	   break;
	}
    }
}

/* 
 * Ibmrt passes function pointers as the address of beginning of
 * the function's data area. The function address is at the
 * first word of the data area. Getfuncaddr will most likely be
 * a no-op for other compilers/machines.
 */
getfuncaddr(a)
Address a;					/* address of foo's data */
{
	Address x;
	dread(&x, a, sizeof(Address));		/* indirect */
	return(x);
}
/*
 * Get the current frame information in the given Frame and store the
 * associated function in the given value-result parameter.
 */

getcurfunc (frp, fp)
Frame frp;
Symbol *fp;
{
    getcurframe(frp);
    *fp = whatblock(savepc(frp));
}

/*
 * Return the frame associated with the next function up the call stack, or
 * nil if there is none.  The function is returned in a value-result parameter.
 * For "inline" functions the statically outer function and same frame
 * are returned.
 */

public Frame nextfunc (frp, fp)
Frame frp;
Symbol *fp;
{
    Symbol t;
    Frame nfrp;

    t = *fp;
    checkref(t);
    if (isinline(t)) {
	t = container(t);
	nfrp = frp;
    } else {
	nfrp = nextframe(frp);
	if (nfrp == nil) {
	    t = nil;
	} else {
	    t = whatblock(savepc(nfrp));
	}
    }
    *fp = t;
    return nfrp;
}

/*
 * Return the frame associated with the given function.
 * If the function is nil, return the most recently activated frame.
 *
 * Static allocation for the frame.
 */
public Frame findframe(f)
Symbol f;
{
    register Frame frp;
    static struct Frame frame;
    Symbol p;

    if ( !f )
      return nil;

    frp = &frame;
    if ( getcurfunc(frp,&p) < 0 ){
	return nil;
    }
    if (f == curfunc && curframe ){
       *frp = *curframe;
       return frp;
    } 
    if ( p == f )
      return frp;

    for (;;) {

       frp = nextfunc(frp, &p);

       if ( p == program )
	 frp = nil;

       if ( p == f || !frp )
	 return frp;
    }
/*NOTREACHED*/
}

/*
 * Find the return address of the current procedure/function.
 */

public Address return_addr ()
{
    Frame frp;
    Address addr;
    struct Frame frame;

	/*
	 * curblock = whatblock(pc) -- get current block
	 * if in prologue, use reg 15, it contains the return address.
	 * else get the return address out of the current frame save area
	 * for reg 15.
	 */

    frp = &frame;
    getcurframe(frp);
    frp = nextframe(frp);
    if (frp == nil) {
	addr = 0;
    } else {
	addr = savepc(frp);
    }
    return addr;
}

/*
 * Print a list of currently active blocks starting with most recent.
 */

public wherecmd ()
{
    walkstack(false);
}

/*
 * Print the variables in the given frame or the current one if nil.
 */

public dump (func)
Symbol func;
{
    Symbol f;
    Frame frp;

    if (func == nil) {
	f = curfunc;
	if (curframe != nil) {
	    frp = curframe;
	} else {
	    frp = findframe(f);
	}
    } else {
	f = func;
	frp = findframe(f);
    }
    showaggrs = true;
    printcallinfo(f, frp);
    dumpvars(f, frp);
}

/*
 * Dump all values.
 */

public dumpall ()
{
    walkstack(true);
}

/*
 * Walk the stack of active procedures printing information
 * about each active procedure.
 */

private walkstack (dumpvariables)
Boolean dumpvariables;
{
    Frame frp;
    boolean save;
    Symbol f;
    struct Frame frame;

    if (notstarted(process) or isfinished(process)) {
	error("program is not active");
    } else {
	save = walkingstack;
	walkingstack = true;
	showaggrs = dumpvariables;
	frp = &frame;
	getcurfunc(frp, &f);
	for (;;) {
	    printcallinfo(f, frp);
	    if (dumpvariables) {
		dumpvars(f, frp);
		putchar('\n');
	    }
	    frp = nextfunc(frp, &f);
	    if (frp == nil or f == program) {
		break;
	    }
	}
	if (dumpvariables) {
	    printf("in \"%s\":\n", symname(program));
	    dumpvars(program, nil);
	    putchar('\n');
	}
	walkingstack = save;
    }
}

/*
 * Print out the information about a call, i.e.,
 * routine name, parameter values, and source location.
 */

private printcallinfo (f, frp)
Symbol f;
Frame frp;
{
    Lineno line;
    Address caller;

    caller = savepc(frp);
    if (caller != reg(PROGCTR)) {
	/*
	 * Unless we are in the current procedure, we should use pc-1
	 * for the traceback so that we see the call as the current location
	 * in the caller.  The pc often points to the line following the call.
	 */
	caller -= 1;
    }
    printname(stdout, f);
    if (not isinline(f)) {
	printparams(f, frp);
    }
    line = srcline(caller);
    if (line != 0) {
	printf(", line %d", line);
	printf(" in \"%s\"\n", srcfilename(caller));
    } else {
	printf(" at 0x%x\n", caller);
    }
}

/*
 * Set the current function to the given symbol.
 * We must adjust "curframe" so that subsequent operations are
 * not confused; for simplicity we simply clear it.
 */

public setcurfunc (f)
Symbol f;
{
    curfunc = f;
    curframe = nil;
}

/*
 * Return the frame for the current function.
 * The space for the frame is allocated statically.
 */

public Frame curfuncframe ()
{
    static struct Frame frame;
    Frame frp;

    if (curframe == nil) {
	frp = findframe(curfunc);
	curframe = &curframerec;
	*curframe = *frp;
    } else {
	frp = &frame;
	*frp = *curframe;
    }
    return frp;
}

/*
 * Execute up to a source line, skipping over intermediate procedure calls.
 * The tricky part here is recursion; we might single step to the next line,
 * but be within a recursive call.  So we compare frame pointers to make sure
 * that execution is at the same or outer level.
 */

public donext ()
{
    Address oldfrp, newfrp;

    if (isprolog(pc)) {
	dostep(true);
	pc = reg(PROGCTR);
    } else {
	oldfrp = reg(FRP);
	do {
	    dostep(true);
	    pc = reg(PROGCTR);
	    newfrp = reg(FRP);
	} while (newfrp < oldfrp and newfrp != 0);
    }
}

/*
 * Set curfunc to be N up/down the stack from its current value.
 */

public up (n)
integer n;
{
    integer i;
    Symbol f;
    Frame frp;
    boolean done;

    if (not isactive(program)) {
	error("program is not active");
    } else if (curfunc == nil) {
	error("no current function");
    } else {
	i = 0;
	f = curfunc;
	frp = curfuncframe();
	done = false;
	do {
	    if (frp == nil) {
		done = true;
		error("not that many levels");
	    } else if (i >= n) {
		done = true;
		curfunc = f;
		curframe = &curframerec;
		*curframe = *frp;
		showaggrs = false;
		printcallinfo(curfunc, curframe);
	    } else if (f == program) {
		done = true;
		error("not that many levels");
	    } else {
		frp = nextfunc(frp, &f);
	    }
	    ++i;
	} while (not done);
    }
}

public down (n)
integer n;
{
    integer i, depth;
    Frame frp, curfrp;
    Symbol f;
    struct Frame frame;

    if (not isactive(program)) {
	error("program is not active");
    } else if (curfunc == nil) {
	error("no current function");
    } else {
	depth = 0;
	frp = &frame;
	getcurfunc(frp, &f);
	if (curframe == nil) {
	    curfrp = findframe(curfunc);
	    curframe = &curframerec;
	    *curframe = *curfrp;
	}
	while ((f != curfunc or !frameeq(frp, curframe)) and f != nil) {
	    frp = nextfunc(frp, &f);
	    ++depth;
	}
	if (f == nil or n > depth) {
	    error("not that many levels");
	} else {
	    depth -= n;
	    frp = &frame;
	    getcurfunc(frp, &f);
	    for (i = 0; i < depth; i++) {
		frp = nextfunc(frp, &f);
		assert(frp != nil);
	    }
	    curfunc = f;
	    *curframe = *frp;
	    showaggrs = false;
	    printcallinfo(curfunc, curframe);
	}
    }
}

/*
 * Return the address corresponding to the first line in a function.
 */

public Address firstline (f)
Symbol f;
{
    Address addr;

    addr = codeloc(f);
    while (linelookup(addr) == 0 and addr < objsize) {
	++addr;
    }
    if (addr == objsize) {
	addr = -1;
    }
    return addr;
}

/*
 * Catcher drops strike three ...
 */

public runtofirst ()
{
    Address addr, endaddr;

    addr = pc;
    endaddr = objsize + CODESTART;
    while (linelookup(addr) == 0 and addr < endaddr) {
	++addr;
    }
    if (addr < endaddr) {
	stepto(addr);
    }
}

/*
 * Return the address corresponding to the end of the program.
 *
 * We look for the entry to "_exit".
 */

public Address lastaddr ()
{
    Symbol s;

    s = lookup(identname("_exit", true));
    if (s == nil) {
	warning("can't find _exit");
	return CODESTART;
    }
    return codeloc(s);
}

/*
 * Decide if the given function is currently active.
 *
 * We avoid calls to "findframe" during a stack trace for efficiency.
 * Presumably information evaluated while walking the stack is active.
 */

public Boolean isactive (f)
Symbol f;
{
    Boolean b;

    if (isfinished(process) || notstarted(process) ) {
	b = false;
    } 
    else {
	if (walkingstack || f == program || f == nil ||
	  ((isinline(f) || ismodule(f)) && isactive(container(f))))
	    b = true;
	else
	    b = (Boolean) (findframe(f) != nil);
    }
    return b;
}

/*
 * Evaluate a call to a procedure.
 */

public callproc (exprnode, isfunc)
Node exprnode;
boolean isfunc;
{
    Node procnode, arglist;
    Symbol proc;
    Word call_pc, call_sp;

    procnode = exprnode->value.arg[0];
    arglist = exprnode->value.arg[1];

    if (procnode->op != O_SYM) {
	beginerrmsg();
	fprintf(stderr, "can't call \"");
	prtree(stderr, procnode);
	fprintf(stderr, "\"");
	enderrmsg();
    }
    assert(procnode->op == O_SYM);
    proc = procnode->value.sym;
    if (not isblock(proc)) {
	error("\"%s\" is not a procedure or function", symname(proc));
    }
    endproc.isfunc = isfunc;
    endproc.callnode = exprnode;
    endproc.cmdnode = topnode;
    pushenv();

    call_pc = reg(PROGCTR);
    pc = codeloc(proc);
    pushargs(proc, arglist);
    call_sp = reg(1);
    beginproc(proc);

    push(Word,call_pc);
    push(Word,call_sp);

    event_alloc(true,
	  build(O_EQ, 
	     build(O_SYM, pcsym), 
	     build(O_LCON,call_pc)
	  ),
          buildcmdlist(build(O_PROCRTN, proc))
    );

    isstopped = false;
    if (not bpact()) {
	isstopped = true;
	cont(0);
    }
}

public procreturn (f)
Symbol f;
{
    int r;
    Node tmp;
    char *copy;
    Word call_sp, call_pc;

    /* if SP < call_sp we are in a recursive call, continue */

    call_sp = pop(Word);
    call_pc = pop(Word);

    if ( reg(1) < call_sp ){
       push(Word,call_pc);
       push(Word,call_sp);
       event_alloc(true,
		  build(O_EQ, 
			build(O_SYM, pcsym), 
			build(O_LCON,call_pc)
		  ),
		  buildcmdlist(build(O_PROCRTN, f)));
       return;
    }

    /* grab the endproc struct early */

    endproc = pop(CallEnv);
    push(CallEnv,endproc);
    flushoutput();

    if ( endproc.isfunc ){

       pushretval(f->type);

	r = size(f->type);
	if ( r > sizeof(long) ){
	   copy = newarr(char, r);
	   popn(r,copy);
	   tmp = build(O_SCON, copy);
	}
	else
	  tmp = build(O_LCON, (long) popsmall(f->type));

	tmp->nodetype = f->type;

/****	tfree(endproc.callnode); ***/

	*(endproc.callnode) = *tmp;
        dispose(tmp);
	eval(endproc.cmdnode);
    } 
    else {
	printf("%s returns successfully\n", symname(f));
    }
    popenv();
    getsrcpos();
    erecover();	/* blast out, kills pending events */
}

/*
 * Check to see if an expression is correct for a given parameter.
 * If the given parameter is false, don't worry about type inconsistencies.
 *
 * Return whether or not it is ok.
 */

private boolean chkparam (actual, formal, chk)
Node actual;
Symbol formal;
boolean chk;
{
    boolean b;

    b = true;
    if (chk) {
	if (formal == nil) {
	    beginerrmsg();
	    fprintf(stderr, "too many parameters");
	    b = false;
	} else if (not compatible(formal->type, actual->nodetype)) {
	    beginerrmsg();
	    fprintf(stderr, "type mismatch for %s", symname(formal));
	    b = false;
	}
    }
    if (b and formal != nil and
	isvarparam(formal) and not isopenarray(formal->type) and
	not (
	    actual->op == O_RVAL or actual->nodetype == t_addr or
	    (
		actual->op == O_TYPERENAME and
		(
		    actual->value.arg[0]->op == O_RVAL or
		    actual->value.arg[0]->nodetype == t_addr
		)
	    )
	)
    ) {
	beginerrmsg();
	fprintf(stderr, "expected variable, found \"");
	prtree(stderr, actual);
	fprintf(stderr, "\"");
	b = false;
    }
    return b;
}

/*
 * Evaluate an argument list left-to-right.
 */

public integer evalargs (proc, arglist)
Symbol proc;
Node arglist;
{
    Node p, actual;
    Symbol formal;
    Stack *savesp;
    integer count;
    boolean chk;

    savesp = sp;
    count = 0;
    formal = proc->chain;
    chk = (boolean) (not nosource(proc));
    for (p = arglist; p != nil; p = p->value.arg[1]) {
	assert(p->op == O_COMMA);
	actual = p->value.arg[0];
	if (not chkparam(actual, formal, chk)) {
	    fprintf(stderr, " in call to %s", symname(proc));
	    sp = savesp;
	    popenv();
	    enderrmsg();
	}
	passparam(actual, formal);
	if (formal != nil) {
	    formal = formal->chain;
	}
	++count;
    }
    if (chk) {
	if (formal != nil) {
	    sp = savesp;
	    popenv();
	    error("not enough parameters to %s", symname(proc));
	}
    }
    return count;
}

/*
 * Evaluate an argument list without any type checking.
 * This is only useful for procedures with a varying number of
 * arguments that are compiled -g.
 */

public integer unsafe_evalargs (proc, arglist)
Symbol proc;
Node arglist;
{
    Node p;
    integer count;

    count = 0;
    for (p = arglist; p != nil; p = p->value.arg[1]) {
	assert(p->op == O_COMMA);
	eval(p->value.arg[0]);
	++count;
    }
    return count;
}

/*
 * Push the current environment.
 */

public pushenv ()
{
   Word framebase[4];

   push(Word,reg(0));
   push(Word,reg(1));
   push(Word,reg(2));
   push(Word,reg(3));
   push(Word,reg(4));
   push(Word,reg(5));
   push(Word,reg(6));
   push(Word,reg(7));
   push(Word,reg(8));
   push(Word,reg(9));
   push(Word,reg(10));
   push(Word,reg(11));
   push(Word,reg(12));
   push(Word,reg(13));
   push(Word,reg(14));
   push(Word,reg(15));

   dread(framebase,reg(1),sizeof(framebase));
   push(Word,framebase[0]);
   push(Word,framebase[1]);
   push(Word,framebase[2]);
   push(Word,framebase[3]);

   push(Word,reg(1));
   push(Word, reg(PROGCTR));
   push(int, (int) isstopped);
   push(CallEnv, endproc);

/*****
    push(Address, pc);
    push(Lineno, curline);
    push(String, cursource);
    push(int, (int) isstopped);
    push(Symbol, curfunc);
    push(Frame, curframe);
    push(struct Frame, curframerec);
    push(CallEnv, endproc);
    push(Word, reg(PROGCTR));
    push(Word, reg(STKP));
    push(Word, reg(FRP));
*****/
}

/*
 * Pop back to the real world.
 */

public popenv ()
{
    Word framebase[4];

    endproc = pop(CallEnv);
    isstopped = (Boolean) pop(int);

    setreg(PROGCTR, pop(Word));
    setreg(1,pop(Word));

    framebase[3] = pop(Word);
    framebase[2] = pop(Word);
    framebase[1] = pop(Word);
    framebase[0] = pop(Word);
    dwrite(framebase,reg(1),sizeof(framebase));

    setreg(15,pop(Word));
    setreg(14,pop(Word));
    setreg(13,pop(Word));
    setreg(12,pop(Word));
    setreg(11,pop(Word));
    setreg(10,pop(Word));
    setreg(9,pop(Word));
    setreg(8,pop(Word));
    setreg(7,pop(Word));
    setreg(6,pop(Word));
    setreg(5,pop(Word));
    setreg(4,pop(Word));
    setreg(3,pop(Word));
    setreg(2,pop(Word));
    setreg(1,pop(Word));
    setreg(0,pop(Word));

/****
    String filename;

    setreg(FRP, pop(Word));
    setreg(STKP, pop(Word));
    setreg(PROGCTR, pop(Word));
    endproc = pop(CallEnv);
    curframerec = pop(struct Frame);
    curframe = pop(Frame);
    curfunc = pop(Symbol);
    isstopped = (Boolean) pop(int);
    filename = pop(String);
    curline = pop(Lineno);
    pc = pop(Address);
    setsource(filename);
****/
}
/*
 * Flush the debuggee's standard output.
 *
 * This is VERY dependent on the use of stdio.
 */

public flushoutput()
{
  Address addr;
    Symbol p, iob;

    p = lookup(identname("fflush", true));
    while (p != nil and not isblock(p)) {
	p = p->next_sym;
    }
    if (p != nil) {
	iob = lookup(identname("_iob", true));
	if (iob != nil) {
	    pushenv();
	    pc = codeloc(p);
	    setreg(2, address(iob, nil) + sizeof(*stdout));
	    beginproc(p);
	    stepto(reg(15));
/*
	    addr = reg(15);
	    setbp(addr);
	    resume(-1, addr);
	    unsetbp(addr);
*/
	    popenv();
	}
    }
}

