/*-
 * Copyright (c) 1980, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This module is believed to contain source code proprietary to AT&T.
 * Use and redistribution is subject to the Berkeley Software License
 * Agreement and your Software Agreement with AT&T (Western Electric).
 */

#ifndef lint
static char sccsid[] = "@(#)ex_tagio.c	8.1 (Berkeley) 6/9/93";
#endif /* not lint */

/*
 * These routines are for faster tag lookup.  They support the binary
 * search used in tagfind() instead of the linear search.  The speedup
 * is quite noticable looking for a tag at the end of a long tags
 * file.  Define FASTTAG in the Makefile to use these routines.
 */
#ifdef FASTTAG

#ifndef vms
#include <sys/file.h>
#else
#include <file.h>
#endif
#include "ex.h"
#ifdef	TAGSTACK
#include "ex_temp.h"
#include "ex_vis.h"
#endif	/* TAGSTACK */

static long offset = -1;
static long block = -1;
static int bcnt = 0;
static int b_size = MAXBSIZE;
static char *ibuf;

topen(file, buf)
char *file, *buf;
{
	int fd;
	struct stat statb;

	offset = -1;
	block = -1;
	if ((fd = open(file, O_RDONLY, 0)) < 0)
		return(-1);
	if (fstat(fd, &statb) < 0) {
		(void)close(fd);
		return(-1);
	}
	ibuf = buf;
	b_size = statb.st_blksize;
	return(fd);
}

tseek(fd, off)
int fd;
long off;
{
	int nblock;

	nblock = off / b_size * b_size;
	offset = off % b_size;
	if (nblock == block)
		return(0);
	block = nblock;
	if (lseek(fd, nblock, L_SET) < 0)
		return(-1);
	if ((bcnt = read(fd, ibuf, b_size)) < 0)
		return(-1);
	return(0);
}

tgets(buf, cnt, fd)
register char *buf;
int cnt;
int fd;
{
	register char *cp;
	register cc;

	cc = offset;
	if (cc == -1) {
		if ((bcnt = read(fd, ibuf, b_size)) <= 0)
			return (NULL);
		cc = 0;
		block = 0;
	}
	if (bcnt == 0)		/* EOF */
		return(NULL);
	cp = ibuf + cc;
	while (--cnt > 0) {
		if (++cc > bcnt) {
			block += b_size;
			if ((bcnt = read(fd, ibuf, b_size)) <= 0) {
				offset = cc;
				return (NULL);
			}
			cp = ibuf;
			cc = 1;
		}
		if ((*buf++ = *cp++) == '\n')
			break;
	}
	*--buf = NULL;
	offset = cc;
	return(1);
}

tclose(fd)
int fd;
{
	(void)close(fd);
	offset = -1;
	block = -1;
	bcnt = 0;
}
# ifdef	TAGSTACK

#define	TSTACKMEMSIZE	(10*1024)		/* 10k should suffice */

typedef struct tstack_str Tstack;
struct tstack_str {
	char	*t_file;
	short	t_flen;		/* XXX! */
	line	t_dot;
	int	t_cursor;
	Tstack	*t_prev;
};

int		tstack_cnt = 1;
static char	tstack_mem[TSTACKMEMSIZE];
static char	*tstack_ptr = tstack_mem;
static Tstack	*tstack = (Tstack *) 0;

/*
 * save current file/lineno/cursor
 */
tag_push(fname)
	char	*fname;
{
	int		len;
	Tstack		*tp;

	/* Don't bother if there is no current file */
	if (fname[0] == '\0')
		return;

	/* See how much space we will need */
	len = sizeof(Tstack) + strlen(fname) + 1;
	/* keep things word aligned */
	len += len & 3;
	if (tstack_ptr + len >= &tstack_mem[TSTACKMEMSIZE]) {
		lprintf("[Tag stack full] ");
		return;
	}
	tp = (Tstack *) tstack_ptr;
	tp->t_prev = tstack;
	tp->t_file = tstack_ptr + sizeof(Tstack);
	(void) strcpy(tp->t_file, fname);
	tp->t_flen = strlen(fname);
	tp->t_dot = lineDOT();
	tp->t_cursor = inopen ? cursor - linebuf : 0;
	tstack_ptr += len;
	tstack = tp;
}

tag_pop(bang)
	int	bang;
{
	Tstack		*tp;
	line		*addr;
	bool		samef = 1;
	int		i;

	/* Do this first so tstack_cnt will be reset regardless */
	i = tstack_cnt;
	tstack_cnt = 1;

	if (!tstack)
		error("Tag stack empty");

	for (tp = tstack ; --i > 0 && tp ; tp = tp->t_prev)
		;
	if (!tp)
		error("Tag stack not that deep");

	if (strcmp(tp->t_file, savedfile) || !edited) {
		char cmdbuf2[sizeof(savedfile) + 10];
		char *oglobp;
		int omagic;
		char opeek;

		if (!bang) {
			ckaw();
			if (chng && dol > zero)
				error("No write@since last change (:pop! overrides)");
		}
		omagic = value(MAGIC);
		oglobp = globp;
		sprintf (cmdbuf2, "e! %*.*s", 
			tp->t_flen, tp->t_flen, tp->t_file);
		globp = cmdbuf2;
		opeek = peekc; ungetchar(0);
		commands(1, 1);
		peekc = opeek;
		globp = oglobp;
		value(MAGIC) = omagic;
		samef = 0;
	}
	/*
	 * Update these now that we know everything is ok
	 */
	tstack = tp->t_prev;
	tstack_ptr = (char *) tp;

	/*
	 *	Try to find the line that we were on
	 */
	addr = zero + tp->t_dot;

	/*
	 *	Line is gone?
	 */
	if (addr <= zero || addr > dol)
		addr = one;
	/*
	 * Try to find position on the line
	 */
	if (inopen) {
		char	*s;

		if (samef && addr != dot)
			markDOT();
		getline(*addr);
		s = linebuf + (inopen ? tp->t_cursor : 0);
		if (s >= linebuf && s < strend(linebuf)) {
			char	tbuf[8]; /* 001024 (max line) + ' ' + \0 */

			if (s != linebuf)
				(void) sprintf(tbuf, "00%d ", s - linebuf);
			else
				tbuf[0] = '0', tbuf[1] = '0', tbuf[2] = '\0';
			macpush(tbuf, 0);
		}
	}
	dot = addr;
	if (ospeed > B300)
		hold |= HOLDWIG;
	return;
}
# endif	TAGSTACK
#endif
