#ifndef dial__h
#define dial__h

#ifndef _TERMIOS_H_
/* taylored for easy porting of sysV programs. */
#include <sys/termios.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#define termio termios
#define TCGETA  TIOCGETA
#define TCSETA  TIOCSETA
#define TCSETAW TIOCSETAW
#define TCSETAF TIOCSETAF
#define TCFLSH TIOCFLUSH
#define NCC     NCCS
#endif

typedef struct {
	struct termio *attr;	/* ptr to termio attribute struct */
	int	baud;		/* transmission baud-rate */
	int	speed;		/* 212A modem: low=300, high=1200 */
	char	*line;		/* device name for out-going line */
	char	*telno;		/* ptr to tel-no digits string */
	int	modem;		/* allow modem control on direct lines */
	char	*device;	/* Will hold the name of the device used
				/* to make a connection. */
	int	dev_len;	/* The length of the device used to make
				/* a connection. */
} CALL;

extern int dial();
extern void undial();
extern int Uerror, Debug;

/* codes returned in Uerror, from uucp.h */
#define SS_OK			0
#define SS_NO_DEVICE		1
#define SS_TIME_WRONG		2
#define SS_INPROGRESS		3
#define SS_CONVERSATION		4
#define SS_SEQBAD		5
#define SS_LOGIN_FAILED		6
#define SS_DIAL_FAILED		7
#define SS_BAD_LOG_MCH		8
#define SS_LOCKED_DEVICE	9
#define SS_ASSERT_ERROR		10
#define SS_BADSYSTEM		11
#define SS_CANT_ACCESS_DEVICE	12
#define SS_DEVICE_FAILED	13	/* No longer used */
#define SS_WRONG_MCH		14
#define SS_CALLBACK		15
#define SS_RLOCKED		16
#define SS_RUNKNOWN		17
#define SS_RLOGIN		18
#define SS_UNKNOWN_RESPONSE	19
#define SS_STARTUP		20
#define SS_CHAT_FAILED		21
#endif /* dial__h */
