/*
 *	This line.c has fixline fixed to check for the external
 *	struct termio *DialTermio, and set to it if non-null.
 *	It also sets VMIN, VTIME and iflag differently from uucp.
 *	If DialModem is set, modem control is never suppressed.
 *	For use by dial(3).
 */
#include "uucp.h"

static struct sg_spds {
	int	sp_val,
		sp_name;
} spds[] = {
	{ 300,  B300},
	{ 600,  B600},
	{1200, B1200},
	{2400, B2400},
	{4800, B4800},
	{9600, B9600},
#ifdef EXTA
	{19200,	EXTA},
#endif
#ifdef B19200
	{19200,	B19200},
#endif
#ifdef B38400
	{38400,	B38400},
#endif
#ifdef B57600
	{57600,	B57600},
#endif
#ifdef B115200
	{115200,B115200},
#endif
	{0,    0}
};

#define PACKSIZE	64
#define HEADERSIZE	6
#define SNDFILE	'S'
#define RCVFILE 'R'
#define RESET	'X'

int	linebaudrate = 0;	/* for speedup hook in pk (unused in ATTSV) */

#if	defined(ATTSV) || defined(BSD4_4)

static struct termio Savettyb;
/*
 * set speed/echo/mode...
 *	tty 	-> terminal name
 *	spwant 	-> speed
 *	type	-> type
 *
 *	if spwant == 0, speed is untouched
 *	type is unused, but needed for compatibility
 *
 * return:  
 *	none
 */
fixline(tty, spwant, type)
int	tty, spwant, type;
{
	register struct sg_spds	*ps;
	struct termio		ttbuf;
	int			speed = -1;
	extern struct termio *DialTermio;
	extern short Direct;

	CDEBUG(6, "fixline(%d, ", tty);
	CDEBUG(6, "%d)\n", spwant);

	if (DialTermio != (struct termio *)0) {
#ifdef BSD4_4
		if (!DialTermio -> c_ospeed)	/* XXX! */
		    DialTermio -> c_ospeed = DialTermio -> c_ispeed = spwant;
		CDEBUG(6, "using DialTermio, speed %d\n", DialTermio->c_ospeed);
#else
		CDEBUG(6, "using DialTermio, speed code %d\n",
			DialTermio->c_cflag & CBAUD);
#endif
		ASSERT(ioctl(tty, TCSETA, DialTermio) >= 0,
		    "RETURN FROM fixline ioctl", "", errno);
		return;
	}

	if (ioctl(tty, TCGETA, &ttbuf) != 0)
		return;
	if (spwant > 0) {
		for (ps = spds; ps->sp_val; ps++)
			if (ps->sp_val == spwant) {
				speed = ps->sp_name;
				break;
			}
		ASSERT(speed >= 0, "BAD SPEED", "", speed);
#ifdef BSD4_4
		ttbuf.c_ispeed = ttbuf.c_ospeed = speed;
		}
#else
		ttbuf.c_cflag = speed;
	} else
		ttbuf.c_cflag &= CBAUD;
#endif
	ttbuf.c_oflag = ttbuf.c_lflag = (ushort)0;
	ttbuf.c_iflag = (IGNPAR | IGNBRK | ISTRIP | IXON | IXOFF);

#ifdef NO_MODEM_CTRL
	/*   CLOCAL may cause problems on pdp11s with DHs -- see uucp.h */
	if ( Direct || type == D_DIRECT) {
		CDEBUG(4, "fixline - direct\n", "");
		ttbuf.c_cflag |= CLOCAL;
	}
#endif /* NO_MODEM_CTRL */

	ttbuf.c_cflag |= (CS8 | CREAD | HUPCL);
	ttbuf.c_cc[VMIN] = 1;
	ttbuf.c_cc[VTIME] = 0;
	
	ASSERT(ioctl(tty, TCSETA, &ttbuf) >= 0,
	    "RETURN FROM fixline ioctl", "", errno);
	return;
}

setclocal(dcf, on)
int	dcf, on;
{
	struct termio ttbuf;

	if ((*Ioctl)(dcf, TCGETA, &ttbuf) != 0)
		return;
	if (on == TRUE)
	    ttbuf.c_cflag |= CLOCAL;
	else
	    ttbuf.c_cflag &= ~CLOCAL;

	(void) (*Ioctl)(dcf, TCSETA, &ttbuf);
}

sethup(dcf)
int	dcf;
{
	struct termio ttbuf;
	register change = 0;

	if (ioctl(dcf, TCGETA, &ttbuf) != 0)
		return;
	if (!(ttbuf.c_cflag & HUPCL)) {
		ttbuf.c_cflag |= HUPCL;
		change++;
	}
	if (ttbuf.c_cflag & CLOCAL) {
		ttbuf.c_cflag &= ~CLOCAL;
		change++;
	}
	if (change)
		(void) ioctl(dcf, TCSETA, &ttbuf);
}

#ifndef BSD4_4
genbrk(fn)
register int	fn;
{
	if (isatty(fn)) 
		(void) ioctl(fn, TCSBRK, 0);
}
#endif


/*
 * optimize line setting for sending or receiving files
 * return:
 *	none
 */
setline(type)
register char	type;
{
	static struct termio tbuf;
	
	if (ioctl(Ifn, TCGETA, &tbuf) != 0)
		return;
	CDEBUG(2, "setline - %c\n", type);
	switch (type) {
	case RCVFILE:
		if (tbuf.c_cc[VMIN] != PACKSIZE) {
		    tbuf.c_cc[VMIN] = PACKSIZE;
		    (void) ioctl(Ifn, TCSETAW, &tbuf);
		}
		break;

	case SNDFILE:
	case RESET:
		if (tbuf.c_cc[VMIN] != HEADERSIZE) {
		    tbuf.c_cc[VMIN] = HEADERSIZE;
		    (void) ioctl(Ifn, TCSETAW, &tbuf);
		}
		break;
	}
}

savline()
{
	int ret;

	ret = ioctl(0, TCGETA, &Savettyb);
	Savettyb.c_cflag = (Savettyb.c_cflag & ~CS8) | CS7;
	Savettyb.c_oflag |= OPOST;
	Savettyb.c_lflag |= (ISIG|ICANON|ECHO);
	return(ret);
}

/***
 *	sytfixline(tty, spwant)	set speed/echo/mode...
 *	int tty, spwant;
 *
 *	return codes:  none
 */

sytfixline(tty, spwant)
int tty, spwant;
{
	struct termio ttbuf;
	struct sg_spds *ps;
	int speed = -1;
	int ret;

	for (ps = spds; ps->sp_val >= 0; ps++)
		if (ps->sp_val == spwant)
			speed = ps->sp_name;
	CDEBUG(4, "sytfixline - speed= %d\n", speed);
	ASSERT(speed >= 0, "BAD SPEED", "", speed);
	(void) ioctl(tty, TCGETA, &ttbuf);
	ttbuf.c_iflag = (ushort)0;
	ttbuf.c_oflag = (ushort)0;
	ttbuf.c_lflag = (ushort)0;
#ifdef BSD4_4
	ttbuf.c_ispeed = ttbuf.c_ospeed = speed;
#else
	ttbuf.c_cflag = speed;
#endif
	ttbuf.c_cflag |= (CS8|CLOCAL);
	ttbuf.c_cc[VMIN] = 6;
	ttbuf.c_cc[VTIME] = 1;
	ret = ioctl(tty, TCSETAW, &ttbuf);
	ASSERT(ret >= 0, "RETURN FROM sytfixline", "", ret);
	return;
}

sytfix2line(tty)
int tty;
{
	struct termio ttbuf;
	int ret;

	(void) ioctl(tty, TCGETA, &ttbuf);
	ttbuf.c_cflag &= ~CLOCAL;
	ttbuf.c_cflag |= CREAD|HUPCL;
	ret = ioctl(tty, TCSETAW, &ttbuf);
	ASSERT(ret >= 0, "RETURN FROM sytfix2line", "", ret);
	return;
}


restline()
{
	return(ioctl(0, TCSETA, &Savettyb));
}

#else /* !ATTSV */

static struct sgttyb Savettyb;

/***
 *	fixline(tty, spwant, type)	set speed/echo/mode...
 *	int tty, spwant;
 *
 *	if spwant == 0, speed is untouched
 *	type is unused, but needed for compatibility
 *
 *	return codes:  none
 */

/*ARGSUSED*/
fixline(tty, spwant, type)
int tty, spwant, type;
{
	struct sgttyb	ttbuf;
	struct sg_spds	*ps;
	int		 speed = -1;

	CDEBUG(6, "fixline(%d, ", tty);
	CDEBUG(6, "%d)\n", spwant);

	if (ioctl(tty, TIOCGETP, &ttbuf) != 0)
		return;
	if (spwant > 0) {
		for (ps = spds; ps->sp_val; ps++)
			if (ps->sp_val == spwant) {
				speed = ps->sp_name;
				break;
			}
		ASSERT(speed >= 0, "BAD SPEED", "", speed);
		ttbuf.sg_ispeed = ttbuf.sg_ospeed = speed;
	} else {
		for (ps = spds; ps->sp_val; ps++)
			if (ps->sp_name == ttbuf.sg_ispeed) {
				spwant = ps->sp_val;
				break;
			}
		ASSERT(spwant >= 0, "BAD SPEED", "", spwant);
	}
	ttbuf.sg_flags = (ANYP | RAW);
	(void) ioctl(tty, TIOCSETP, &ttbuf);
	(void) ioctl(tty, TIOCHPCL, STBNULL);
	(void) ioctl(tty, TIOCEXCL, STBNULL);
	linebaudrate = spwant;		/* for hacks in pk driver */
	return;
}

sethup(dcf)
int	dcf;
{
	if (isatty(dcf)) 
		(void) ioctl(dcf, TIOCHPCL, STBNULL);
}

/*
 * V7 and RT aren't smart enough for this -- linebaudrate is the best
 * they can do.
 */
/*ARGSUSED*/
setline(dummy) { }

savline()
{
	int	ret;

	ret = ioctl(0, TIOCGETP, &Savettyb);
	Savettyb.sg_flags |= ECHO;
	Savettyb.sg_flags &= ~RAW;
	return(ret);
}

restline()
{
	return(ioctl(0, TIOCSETP, &Savettyb));
}
#endif

#ifndef ATTSV
/***
 *	genbrk		send a break
 *
 *	return codes;  none
 */

genbrk(fn)
{
	if (isatty(fn)) {
		(void) ioctl(fn, TIOCSBRK, 0);
		nap(HZ/10);				/* 0.1 second break */
		(void) ioctl(fn, TIOCCBRK, 0);
	}
	return;
}
#endif
