/*
 *	wrapper to make dial(3) interface for cu routines
 */
#include <setjmp.h>
#include "dial.h"
#include <stdio.h>

jmp_buf Connjmp, Sjbuf;			/*needed by uucp routines*/
struct termio *DialTermio;

short
	DialModem,	/* YES=wait for CD on open */
	Direct;		/* YES=always set CLOCAL */

static struct cucall {		/* cu calling info-also in cu.c; */
				/* make changes in both places!*/
	char *speed;		/* transmission baud rate */
	char *line;		/* device name for outgoing line */
	char *telno;		/* ptr to tel-no digit string */
	char *class;		/* class of call */
} cucall;

#ifdef antique
static struct speed {
	int speed;
	int code;
} speeds[] = {
	50, B50,
	75, B75,
	110, B110,
	134, B134,
	150, B150,
	200, B200,
	0, 0
};
#endif

dial(call)
CALL *call;
{	char speed[10];
	struct termio ttbuf;
	struct speed *ps;
	int fd, spcode = -1;
	int systemname = 0;

{
    extern Debug;
    if (Debug) {
	fprintf (stderr, "dial called: baud=%d, speed=%d, line=%s, telno=%s\n",
		call -> baud, call -> speed, 
		call -> line == (char *) NULL ? "__NULL__" : call -> line,
		call -> telno == (char *) NULL ? "__NULL__" : call -> telno);
    }
}
	if (call->baud) {
		sprintf(speed, "%.9d", call->baud);
		if (call->baud < 300) strcpy(speed, "300");
		cucall.speed = speed;
	} else cucall.speed = "Any";
	if (call->line) cucall.line = call->line;
	if (call->telno) {
	    cucall.telno = call->telno;
	    if(!(strlen(call->telno) == strspn(call->telno, "0123456789=-*#")))
		systemname++;
	}
	if (!(call->line || call->telno)) {
		Uerror = SS_NO_DEVICE;
		return(-1);
	}
	Direct = (call->line && !(call->telno));
	DialTermio = call->attr;
	DialModem = call->modem;
	if (setjmp(Connjmp)) return(-1);
	if (systemname)
	    fd = conn(cucall.telno);
	else
	    fd = altconn(&cucall);
#ifdef antique
	/* nobody uses speeds this slow anymore !!! */
	if (!call->attr && fd >= 0 && call->baud && call->baud < 300) {
		for (ps = speeds; ps->speed; ps++)
			if (ps->speed == call->baud) spcode = ps->code;
		if (spcode != -1) {
			ioctl(fd, TCGETA, &ttbuf);
			ttbuf.c_cflag &= ~CBAUD;
			ttbuf.c_cflag |= spcode;
			ioctl(fd, TCSETA, &ttbuf);
		}
	}
#endif
	return(fd);
}

void
undial()
{
	rmlock(0);
}

/*
 * stuff for compatability w/uucp modules; from cu.c
 */
void logent(){}		/* so we can load ulockf() */

char *Myline = NULL;  /* flag to force the requested line to be used  */
		      /* by rddev() in uucp conn.c		    */

void
assert(s1, s2, i1)
char *s1, *s2;
{
	fprintf(stderr, "uucp assert error %s %s (%d)\n", s1, s2, i1);
}

cleanup()		/* called from uucp ASSERT */
{
	longjmp(Connjmp, 1);
}

