
/*
 * sldial.  Simple little program to which dials-out, then
 * exec's sliplogin to handle the slip setup.
 *
 * TODO:  expand to allow on-the-fly chat strings.
 */

#include "uucp.h"
#include "pathnames.h"

extern int maxexpecttime;	/* amount of time we will wait for CONNECT */
extern int trycalls;		/* number of times to retry a line */
extern int busyhack;		/* XXX! */
jmp_buf Sjbuf;			/*needed by uucp routines*/
extern void cleanup ();

main(argc, argv)
    int argc;
    char *argv[];
{
    int ret, i, sflag = 0, fflag = 0, fd, pid, f[2], retcode = 0;
    char *name, *pgrm, *string, *slhost;
    Verbose = 1;		/*for uucp callers,  dialers feedback*/

    slhost = NULL;
    name = ((name = strrchr (argv[0], '/')) == NULL) ? argv[0] : name + 1;
    strcpy(Progname, name);
    ret = setservice("slip");
    ASSERT(ret == 0, Ct_OPEN, "Systems", ret);

    trycalls = 1;	/* default in uucp is 2 */
    busyhack = 1;	/* XXX: enable busyhack check in expect() */
    while((i = getopt(argc, argv, "dS:x:fT:R:")) != EOF)
	switch(i) {
	    case 'd':
		Debug = 9; /*turns on uucp debugging-level 9*/
		break;
	    case 'S':
		slhost = optarg;
		break;
	    case 'x':
		Debug = atoi (optarg);
		break;
	    case 'f':
		fflag++;
		break;
	    case 'T':
		maxexpecttime = atoi (optarg);
		break;
	    case 'R':
		trycalls = atoi (optarg);
		break;
	    case '?':
		goto Usage;
	}

    /* XXX: add the ability to specify phone number, line, etc, like cu */
    if (optind < argc && optind > 0) { 
	sflag++;
	string = argv[optind];
	if (versys(string)) {
	    (void) fprintf(stderr,
		    "%s: %s not in Systems file\n",
		    Progname, string);
	    cleanup(101);
	}
	strncpy(Rmtname, string, MAXBASENAME);
	Rmtname[MAXBASENAME] = '\0';
	if (slhost == NULL)
	    slhost = Rmtname;
    }

    if (!sflag) {
Usage:;
	fprintf (stderr, "Usage: %s [-d] [-T seconds] [-R retries] [-S sliphost] <SystemName>\n", Progname);
	fprintf (stderr, "\tWhere:\n");
	fprintf (stderr, "\tsliphost is the Slip Host keyword in slip.hosts\n");
	fprintf (stderr, "\tSystemName is the dial-out systemname defined in Systems.slip\n");
	exit (1);
    }

    /* fork early so that the lockfile gets our pid */
    f[0] = f[1] = 0;
    if (!fflag) {
	if (pipe (f) < 0) {
	    perror ("pipe failed\n");
	    exit(1);
	}
	if ((pid = fork()) < 0) {
	    perror ("fork failed\n");
	    exit(1);
	}

	/* parent hangs around waiting for a response from the child */
	if (pid) {
	    close (f[1]);
	    if (read (f[0], &retcode, sizeof (int)) < 0)
		exit (1);
	    exit (retcode);
	}
	else {
	    close (f[0]);
	}
    }

    fd = conn(Rmtname);
    if (fd < 0) {
	delock(Rmtname);
	fprintf (stderr, "%s: FAILED: %s\n", Progname, UERRORTEXT);
	if (f[1]) {
	    retcode = 101;	/* XXX: need something better here */
	    write (f[1], &retcode, sizeof (int));
	}
	cleanup(101);
    } 
    (void)dup2(fd, 0);		/* sliplogin expects the tty on stdin */

    /* XXX: pick between sliplogin or pppd */
    pgrm = *Progname == 's' ? _PATH_SLIPLOGIN : _PATH_PPPD;
    name = ((name = strrchr (pgrm, '/')) == NULL) ? pgrm : name + 1;

    /* at this point, we have to assume we succeeded... */
    if (f[1]) {
	write (f[1], &retcode, sizeof (int));
    }

    execl(pgrm, name, slhost, (char *) 0);
    exit (1);
}

void
cleanup(code)
int code;
{
    CDEBUG(4,"call cleanup(%d)\r\n", code);

    /* XXX: might want to do more here ?? */

    rmlock((char*) NULL);	/* remove lock files */	
    exit(code);
}

/*
 *	produce an assert error message
 * input:
 *	s1 - string 1
 *	s2 - string 2
 *	i1 - integer 1 (usually errno)
 *	file - __FILE of calling module
 *	line - __LINE__ of calling module
 */
void
assert(s1, s2, i1, file, line)
char *s1, *s2, *file;
{
	char buf1[80];

	sprintf (buf1, "%s %s: %%d\n", s1, s2);
	VERBOSE(buf1,i1);
}

/* void assert(){}		/* for ASSERT in gnamef.c */
void logent(){}		/* so we can load ulockf() */

