
#include "uucp.h"
VERSION("$Id: conn.c,v 1.6 1993/04/28 03:32:11 roger Exp $")

static char _ProtoStr[40] = "";	/* protocol string from Systems file entry */
extern jmp_buf Sjbuf;

int maxexpecttime = MAXEXPECTTIME;	/* amount of time to wait on expect */
int trycalls = TRYCALLS;		/* times to retry each phone number */
int busyhack = 0;			/* XXX: temp hack */
int alarmtr();
static void getProto();
/* static getto(), finds();   PUT this back after altconn is included */
extern getto();
static finds();

static notin(), ifdate(), ifadate(), classmatch();

extern struct caller caller[];
extern int _ForceCall;

/* Needed for cu for force which line will be used */
#ifdef STANDALONE
extern char *Myline;
#endif /* STANDALONE */

/*
 * conn - place a telephone call to system and login, etc.
 *
 * return codes:
 *	FAIL - connection failed
 *	>0  - file no.  -  connect ok
 * When a failure occurs, Uerror is set.
 */

conn(system)
char *system;
{
	int nf, fn = FAIL;
	char *flds[F_MAX+1], *file;
	extern void sysreset();

	CDEBUG(4, "conn(%s)\n", system);
	Uerror = 0;
	while ((nf = finds(system, flds, F_MAX)) > 0) {

#if !defined(STANDALONE) && !defined(SLIP)
		/*
		 *	Make sure there is work for the allowed grades 
		 *	before we place the call.
		 *	SIDE EFFECT - if Systems limits grades at the CURRENT
		 *	  TIME OF DAY and there are NO files to transfer within
		 *	  the allowed grade limit, the only way to initiate
		 *	  a transfer (or POLL) in MASTER mode is with:
		 *	  "uucico -r1 -gGRADE", where GRADE is EQUAL to
		 *	  the MaxGrade allowed in Systems at this time of day.
		 */
		if (MaxGrade != DefMaxGrade && !iswrk(file, CK_WORK)){
		    if (!FORCECALL) {
			CDEBUG(1, "No work of grade %c -- no call\n", MaxGrade);
			Uerror = SS_TIME_WRONG;
			continue;
		    }
		    CDEBUG(1, "No work of grade %c; but for you...\n",
			MaxGrade);
		}
#endif /* !STANDALONE && !SLIP */

#ifdef 0 /* mc68k */		/* tcp hacks? */
#if  defined (TCP) || defined (UNET)
		if (!*_ProtoStr
		    && (!strcmp("TCP", flds[F_TYPE])
			|| !strcmp("UCBTCP", flds[F_TYPE])
			|| !strcmp("INET", flds[F_TYPE]))) {
				(void) strcpy(_ProtoStr, "etg");
				DEBUG(7, "ProtoStr = %s\n", _ProtoStr);
		}
#endif	/* UNET || TCP */
#ifdef INET
		if (!strcmp("INET", flds[F_TYPE]))
			return(incall(flds));
#endif /* INET */
#endif /* mc68k */
		fn = getto(flds);
		CDEBUG(4, "getto ret %d\n", fn);
		if (fn < 0)
		    continue;

#ifdef STANDALONE
		sysreset();
		return(fn);
#else /* !STANDALONE */
		if (chat(nf - F_LOGIN, flds + F_LOGIN, fn,"","") == SUCCESS) {
			sysreset();
			return(fn); /* successful return */
		}

		/* login failed */
		DEBUG(6, "close caller (%d)\n", fn);
		close(fn);
		if (Dc[0] != NULLCHAR) {
			DEBUG(6, "delock(%s)\n", Dc);
			delock(Dc);
		}
#endif /* STANDALONE */
	}

	/* finds or getto failed */
	sysreset();
	CDEBUG(1, "Call Failed: %s\n", UERRORTEXT);
	return(FAIL);
}

#ifdef 0 /* mc68k */
#ifdef INET
/*
 * make a connection via the Internet, CT style.
 */

#include <netdb.h>

incall(flds)
char *flds[];
{
	struct servent *sp;
	int ret;
	char rhost[80];
	char *prhost = rhost;

	sp = getservbyname("olduucp", "tcp");
	if (sp == 0) {
		DEBUG(4, "incall - shell/tcp unknown service", 0);
		return(-1);
	}
	DEBUG(4,"incall (machine = %s) ", flds[F_NAME]);
	strncpy(rhost, flds[F_NAME], sizeof(rhost));
	ret = rcmd(&prhost, sp->s_port, "uucp", flds[F_PHONE], 
		"", 0);
	DEBUG(4, "incall status = %d\n", ret);
	if (ret < 0)
		Uerror = SS_LOGIN_FAILED;
	return(ret);
}
#endif
#endif /* mc68k */

/*
 * getto - connect to remote machine
 *
 * return codes:
 *	>0  -  file number - ok
 *	FAIL  -  failed
 */

getto(flds)
char *flds[];
{
	char *dev[D_MAX+2], devbuf[BUFSIZ];
	register int status;
	register int dcf = -1;
	int reread = 0;
	int tries = 0;	/* count of call attempts - for limit purposes */
	extern void devreset();

	CDEBUG(1, "Device Type %s wanted\n", flds[F_TYPE]);
	Uerror = 0;
	while (tries < trycalls) {
		if ((status=rddev(flds[F_TYPE], dev, devbuf, D_MAX)) == FAIL) {
			if (tries == 0 || ++reread >= trycalls)
				break;
			devreset();
			continue;
		}
		/* check class, check (and possibly set) speed */
		if (classmatch(flds, dev) != SUCCESS)
			continue;
		if ((dcf = processdev(flds, dev)) >= 0)
			break;

		switch(Uerror) {
		case SS_CANT_ACCESS_DEVICE:
		case SS_DEVICE_FAILED:
		case SS_LOCKED_DEVICE:
			break;
		default:
			tries++;
			break;
		}
	}
	devreset();	/* reset devices file(s) */
	if (status == FAIL && !Uerror) {
		CDEBUG(1, "Requested Device Type Not Found\n", 0);
		Uerror = SS_NO_DEVICE;
	}
	return(dcf);
}

/*
 * classmatch - process 'Any' in Devices and Systems and
 * 	determine the correct speed, or match for ==
 */

static int
classmatch(flds, dev)
char *flds[], *dev[];
{
	/* check class, check (and possibly set) speed */
	if (EQUALS(flds[F_CLASS], "Any")
	   && EQUALS(dev[D_CLASS], "Any")) {
		dev[D_CLASS] = flds[F_CLASS] = DEFAULT_BAUDRATE;
		return(SUCCESS);
	} else if (EQUALS(dev[F_CLASS], "Any")) {
		dev[D_CLASS] = flds[F_CLASS];
		return(SUCCESS);
	} else if (EQUALS(flds[F_CLASS], "Any")) {
		flds[D_CLASS] = dev[F_CLASS];
		return(SUCCESS);
	} else if (EQUALS(flds[F_CLASS], dev[D_CLASS]))
		return(SUCCESS);
	else
		return(FAIL);
}


/***
 *	rddev - find and unpack a line from device file for this caller type 
 *	lines starting with whitespace of '#' are comments
 *
 *	return codes:
 *		>0  -  number of arguments in vector - succeeded
 *		FAIL - EOF
 ***/

rddev(type, dev, buf, devcount)
char *type;
char *dev[];
char *buf;
{
	char *commap, d_type[BUFSIZ];
	int na;

	while (getdevline(buf, BUFSIZ)) {
		if (buf[0] == ' ' || buf[0] == '\t'
		    ||  buf[0] == '\n' || buf[0] == '\0' || buf[0] == '#')
			continue;
		na = getargs(buf, dev, devcount);
		ASSERT(na >= D_CALLER, "BAD LINE", buf, na);

/* For cu -- to force the requested line to be used */
#ifdef STANDALONE
		if (Myline != NULL) {
		    register char *p;
		    char dcname[20];

		    /* D_LINE may have O_NDELAY subfield, which must
		     * be stripped off before comparing to desired line
		     */
		    if ((p=strchr(strcpy(dcname, dev[D_LINE]), ',')) != NULL)
			*p = NULLCHAR;
		    if (!EQUALS(Myline, dcname) )
			continue;
		}
#endif /* STANDALONE */

		bsfix(dev);	/* replace \X fields */

		/*
		 * D_TYPE field may have protocol subfield, which
		 * must be pulled off before comparing to desired type.
		 */
		(void)strcpy(d_type, dev[D_TYPE]);
		if ((commap = strchr(d_type, ',')) != (char *)NULL )
			*commap = '\0';
		if (EQUALS(d_type, type)) {
			getProto( dev[D_TYPE] );
			return(na);
		}
	}
	return(FAIL);
}


/*
 * finds	- set system attribute vector
 *
 * input:
 *	fsys - open Systems file descriptor
 *	sysnam - system name to find
 * output:
 *	flds - attibute vector from Systems file
 *	fldcount - number of fields in flds
 * return codes:
 *	>0  -  number of arguments in vector - succeeded
 *	FAIL - failed
 * Uerror set:
 *	0 - found a line in Systems file
 *	SS_BADSYSTEM - no line found in Systems file
 *	SS_TIME_WRONG - wrong time to call
 */

static
finds(sysnam, flds, fldcount)
char *sysnam, *flds[];
{
	static char info[BUFSIZ];
	int na;

	/* format of fields
	 *	0 name;
	 *	1 time
	 *	2 acu/hardwired
	 *	3 speed
	 *	etc
	 */
	if (sysnam == 0 || *sysnam == 0 ) {
		Uerror = SS_BADSYSTEM;
		return(FAIL);
	}

	while (getsysline(info, sizeof(info))) {
		if (*sysnam != *info || *info == '#')	/* speedup */
			continue;
		na = getargs(info, flds, fldcount);
		bsfix(flds);	/* replace \X fields */
		if ( !EQUALSN(sysnam, flds[F_NAME], SYSNSIZE))
			continue;
#ifdef STANDALONE
		Uerror = 0;
		return(na);	/* FOUND OK LINE */
#else /* !STANDALONE */
		if (ifdate(flds[F_TIME]) == SUCCESS) {
			/*  found a good entry  */
			*_ProtoStr = NULLCHAR;
			getProto(flds[F_TYPE]);
			Uerror = 0;
			return(na);	/* FOUND OK LINE */
		}
		if (FORCECALL) {
			/*  found a good entry  */
			CDEBUG(1, "Wrong Time To Call: (%s); but for you...\n",
				flds[F_TIME]);
			Uerror = 0;
			return(na);	/* FOUND OK LINE */
		}
		CDEBUG(1, "Wrong Time To Call: %s\n", flds[F_TIME]);
		Uerror = SS_TIME_WRONG;
#endif /* STANDALONE */
	}
	if (!Uerror)
		Uerror = SS_BADSYSTEM;
	return(FAIL);
}

/*
 * getProto - get the protocol letters from the input string.
 * input:
 *	str - string from Systems file (flds[F_TYPE])--the ,
 *		delimits the protocol string
 *		e.g. ACU,g or DK,d
 * output:
 *	str - the , (if present) will be replaced with NULLCHAR
 *	global ProtoStr will be modified
 * return:  none
 */

static
void
getProto(str)
char *str;
{
	register char *p;
	if ( (p=strchr(str, ',')) != NULL) {
		*p = NULLCHAR;
		if( *_ProtoStr == NULLCHAR )
			(void) strcpy(_ProtoStr, p+1);
		else
			(void) strcat(_ProtoStr, p+1);
		DEBUG(7, "ProtoStr = %s\n", _ProtoStr);
	}
}

/*
 * check for a specified protocol selection string
 * return:
 *	protocol string pointer
 *	NULL if none specified for LOGNAME
 */
char *
protoString()
{
	return(_ProtoStr[0] == NULLCHAR ? NULL : _ProtoStr);
}

/*
 * chat -	do conversation
 * input:
 *	nf - number of fields in flds array
 *	flds - fields from Systems file
 *	fn - write file number
 *	phstr1 - phone number to replace \D
 *	phstr2 - phone number to replace \T
 *
 *	return codes:  0  |  FAIL
 */

chat(nf, flds, fn, phstr1, phstr2)
char *flds[], *phstr1, *phstr2;
int nf, fn;
{
	char *want, *altern;
	extern char *index();
	int k, ok;

	for (k = 0; k < nf; k += 2) {
		want = flds[k];
		ok = FAIL;
		while (ok != 0) {
			altern = index(want, '-');
			if (altern != NULL)
				*altern++ = NULLCHAR;
			ok = expect(want, fn);
			if (ok == 0)
				break;
			if (altern == NULL) {
				Uerror = SS_LOGIN_FAILED;
				logent(UERRORTEXT, "FAILED");
				return(FAIL);
			}
			want = index(altern, '-');
			if (want != NULL)
				*want++ = NULLCHAR;
			sendthem(altern, fn, phstr1, phstr2);
		}
		sleep(2);
		if (flds[k+1])
		    sendthem(flds[k+1], fn, phstr1, phstr2);
	}
	return(0);
}

#define MR 300

/***
 *	expect(str, fn)	look for expected string
 *	char *str;
 *
 *	return codes:
 *		0  -  found
 *		FAIL  -  lost line or too many characters read
 *		some character  -  timed out
 */

expect(str, fn)
char *str;
int fn;
{
	static char rdvec[MR];
	char *rp = rdvec;
	register int kr, c;
	char nextch;
	extern	errno;

	*rp = 0;

	CDEBUG(4, "expect: (", 0);
	for (c=0; kr=str[c]; c++)
		if (kr < 040) {
			CDEBUG(4, "^%c", kr | 0100);
		} else
			CDEBUG(4, "%c", kr);
	CDEBUG(4, ")\n", 0);

	if (EQUALS(str, "\"\"")) {
		CDEBUG(4, "got it\n", 0);
		return(0);
	}
	if (setjmp(Sjbuf)) {
		return(FAIL);
	}
	(void) signal(SIGALRM, alarmtr);
	alarm(maxexpecttime);
	while (notin(str, rdvec)) {
		/* XXX!  Need a way to specify failure cases to expect()
		 *	 so that we dont have to wait for the full alarm
		 *	 timeout time.
		 */
		if (busyhack && !notin("BUSY", rdvec)) {
		    alarm(0);
		    CDEBUG(4, " busy line\n", "");
		    return(FAIL);
		}
		errno = 0;
		kr = (*Read)(fn, &nextch, 1);
		if (kr <= 0) {
			alarm(0);
			CDEBUG(4, "lost line errno - %d\n", errno);
			logent("LOGIN", "LOST LINE");
			return(FAIL);
		}
		c = nextch & 0177;
		CDEBUG(4, "%s", c < 040 ? "^" : "");
		CDEBUG(4, "%c", c < 040 ? c | 0100 : c);
		if ((*rp = nextch & 0177) != NULLCHAR)
			rp++;
		if (rp >= rdvec + MR) {
			CDEBUG(4, "enough already\n", 0);
			alarm(0);
			return(FAIL);
		}
		*rp = NULLCHAR;
	}
	alarm(0);
	CDEBUG(4, "got it\n", 0);
	return(0);
}


/***
 *	alarmtr()  -  catch alarm routine for "expect".
 */

alarmtr()
{
	CDEBUG(6, "timed out\n", 0);
	longjmp(Sjbuf, 1);
}




/***
 *	sendthem(str, fn, phstr1, phstr2)	send line of chat sequence
 *	char *str, *phstr;
 *
 *	return codes:  none
 */

#define FLUSH() {\
	if (wrstr(fn, buf, bptr - buf, echocheck) != SUCCESS)\
		goto err;\
	bptr = buf;\
}

sendthem(str, fn, phstr1, phstr2)
char *str, *phstr1, *phstr2;
int fn;
{
	int sendcr = 1, echocheck = 0;
	register char	*sptr, *pptr, *bptr;
	char	buf[BUFSIZ];

	/* should be EQUALS, but previous versions had BREAK n for integer n */
	if (PREFIX("BREAK", str)) {
		/* send break */
		CDEBUG(5, "BREAK\n", 0);
		genbrk(fn);
		return;
	}

	if (EQUALS(str, "EOT")) {
		CDEBUG(5, "EOT\n", 0);
		(void) (*Write)(fn, EOTMSG, strlen(EOTMSG));
		return;
	}

	if (EQUALS(str, "\"\"")) {
		CDEBUG(5, "\"\"\n", 0);
		str += 2;
	}

	bptr = buf;
	CDEBUG(5, "sendthem (", 0);
	for (sptr = str; *sptr; sptr++) {
		if (*sptr == '\\') {
			switch(*++sptr) {

			/* adjust switches */
			case 'c':	/* no CR after string */
				if (sptr[1] == NULLCHAR) {
					CDEBUG(5, "<NO CR>", 0);
					sendcr = 0;
				} else
					CDEBUG(5, "<NO CR - MIDDLE IGNORED>",0);
				continue;
			}

			/* stash in buf and continue */
			switch(*sptr) {
			case 'D':	/* raw phnum */
				strcpy(bptr, phstr1);
				bptr += strlen(bptr);
				continue;
			case 'T':	/* translated phnum */
				strcpy(bptr, phstr2);
				bptr += strlen(bptr);
				continue;
			case 'N':	/* null */
				*bptr++ = 0;
				continue;
			case 's':	/* space */
				*bptr++ = ' ';
				continue;
			case '\\':	/* backslash escapes itself */
				*bptr++ = *sptr;
				continue;
			default:	/* send the backslash */
				*bptr++ = '\\';
				*bptr++ = *sptr;	

			/* flush buf, perform action, and continue */
			case 'E':	/* echo check on */
				FLUSH();
				CDEBUG(5, "ECHO CHECK ON ", 0);
				echocheck = 1;
				continue;
			case 'e':	/* echo check off */
				FLUSH();
				CDEBUG(5, "ECHO CHECK OFF ", 0);
				echocheck = 0;
				continue;
			case 'd':	/* sleep briefly */
				FLUSH();
				CDEBUG(5, "DELAY ", 0);
				sleep(2);
				continue;
			case 'p':	/* pause momentarily */
				FLUSH();
				CDEBUG(5, "PAUSE ", 0);
				nap(HZ/4);	/* approximately 1/4 second */
				continue;
			case 'K':	/* inline break */
				FLUSH();
				CDEBUG(5, "BREAK ", 0);
				genbrk(fn);
				continue;
			case 'M':	/* set CLOCAL */
				/* no FLUSH, or we'll lose the line */
				CDEBUG(5, "CLOCAL set ", 0);
				setclocal(fn, TRUE);
				continue;
			case 'm':	/* clear CLOCAL */
				FLUSH();
				CDEBUG(5, "CLOCAL clear ", 0);
				setclocal(fn, FALSE);
				continue;
			}
		} else
			*bptr++ = *sptr;
	}
	if (sendcr)
		*bptr++ = '\r';
	(void) wrstr(fn, buf, bptr - buf, echocheck);

err:
	CDEBUG(5, ")\n", 0);
	return;
}

#undef FLUSH

wrstr(fn, buf, len, echocheck)
char *buf;
{
	int 	i;
	char dbuf[BUFSIZ], *dbptr = dbuf;

	buf[len] = 0;
	if (echocheck)
		return(wrchr(fn, buf, len));

	if (Debug >= 5) {
		if (sysaccess() == 0) {	/* Systems file access ok */
			for (i = 0; i < len; i++) {
				*dbptr = buf[i];
				if (*dbptr < 040) {
					*dbptr++ = '^';
					*dbptr = buf[i] | 0100;
				}
				dbptr++;
			}
			*dbptr = 0;
		} else
			strcpy(dbuf, "????????");
		CDEBUG(5, dbuf, 0);
	}
	if ((*Write)(fn, buf, len) != len)
		return(FAIL);
	return(SUCCESS);
}

wrchr(fn, buf, len)
register int fn;
register char *buf;
{
	int 	i, saccess;
	char	cin, cout;

	saccess = (sysaccess() == 0);	/* protect Systems file */
	if (setjmp(Sjbuf))
		return(FAIL);
	(void) signal(SIGALRM, alarmtr);

	for (i = 0; i < len; i++) {
		cout = buf[i];
		if (saccess) {
			CDEBUG(5, "%s", cout < 040 ? "^" : "");
			CDEBUG(5, "%c", cout < 040 ? cout | 0100 : cout);
		} else
			CDEBUG(5, "?", 0);
		if (((*Write)(fn, &cout, 1)) != 1)
			return(FAIL);
		do {
			(void) alarm(maxexpecttime);
			if ((*Read)(fn, &cin, 1) != 1)
				return(FAIL);
			(void) alarm(0);
			cin &= 0177;
			if (saccess) {
				CDEBUG(5, "%s", cin < 040 ? "^" : "");
				CDEBUG(5, "%c", cin < 040 ? cin | 0100 : cin);
			} else
				CDEBUG(5, "?", 0);
		} while (cout != (cin & 0177));
	}
	return(SUCCESS);
}


/***
 *	notin(sh, lg)	check for occurrence of substring "sh"
 *	char *sh, *lg;
 *
 *	return codes:
 *		0  -  found the string
 *		1  -  not in the string
 */

static
notin(sh, lg)
char *sh, *lg;
{
	while (*lg != NULLCHAR) {
		if (PREFIX(sh, lg))
			return(0);
		else
			lg++;
	}
	return(1);
}


/*******
 *	ifdate(s)
 *	char *s;
 *
 *	ifdate  -  this routine will check F_TIME, a list of comma
 *	seperated limits, to see if the present time is with the 
 *	given limits.
 *	SIDE EFFECT - Retrytime is set to number following ";"
 *
 *	return codes:
 *		0  -  not within limits
 *		1  -  within limits
 */
static
ifdate(s)
register char *s;
{
    register char *p;
    register int ret, g;
    char *rindex(), *strpbrk();

    ret = FAIL;
    MaxGrade = '\0';
    Retrytime = RETRYTIME;	/* set default retry time */
    do {
	p = strpbrk(s, ",");
	if (p)
	    *p = '\0';
	g = ifadate(s);
	DEBUG(7,"ifadate returns %o\n", g);
	if (g != FAIL) {
	    ret = SUCCESS;
	    if (g > MaxGrade) {
		char *r;

		MaxGrade = g;
		/*
		 *	pick up retry time for failures
		 *	global variable Retrytime is set here
		 *	SIDE EFFECT: this picks up the retry time for the best
		 *		available grade.
		 */
		if ((r = rindex(s, ';')) != NULL)
		    if (isdigit(r[1])) {
			if (sscanf(r+1, "%d", &Retrytime) < 1) {
			    Retrytime = RETRYTIME;	/* error default */
			}
			else
			    Retrytime  *= 60;
		    }
	    }
	}
	if (p)
	    *p = ',';		/* perserve the string in case of error */
	s = p + 1;		/* next time field */
    } while (p);
    CDEBUG(4, "Retry time set to %d minutes\n", Retrytime/60);
    if (MaxGrade == '\0')
	MaxGrade = DefMaxGrade;
    if (isgraph(MaxGrade))
	CDEBUG(4, "Max Grade set to %c\n", MaxGrade);
    return (ret);
}

/*
 *	ifadate  -  this routine will check a string (s)
 *	like "MoTu0800-1730" to see if the present
 *	time is within the given limits.
 *	SIDE EFFECT - MaxGrade is set to char following "/"
 *
 *	String alternatives:
 *		Wk - Mo thru Fr
 *		zero or one time means all day
 *		Any - any day
 *		Evening - same as: Wk1700-0800,Sa,Su.
 *		Night - same as: Any2300-0800,Sa,Su0800-1700.
 *		ReachOut - same as: Any2200-0800,Sa,Su0800-1700.
 *		NonPeak - same as: Any1800-0700,Sa,Su.
 *
 *	return codes:
 *		FAIL      -  not within limits
 *		Maxgrade  -  within limits
 */
static
ifadate(s)
char *s;
{
    static char *days[] = {
	    "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa", 0
    };
    time_t	clock;
    int	t__now;
    char	*p, grade, *index();
    struct tm	*tp;

    time(&clock);
    tp = localtime(&clock);
    t__now = tp->tm_hour * 100 + tp->tm_min;	/* "navy" time */

    grade = ((p = index(s, '/')) == NULL) ? DefMaxGrade : p[1];
    while (*s) {
	int	i, dayok;

	for (dayok = 0; (!dayok) && isalpha(*s); s++) {
	    if (PREFIX("Any", s))
		dayok = 1;
	    else if (PREFIX("Wk", s)) {
		if (tp->tm_wday >= 1 && tp->tm_wday <= 5)
		    dayok = 1;
	    }
	    else if (PREFIX("Evening", s)) {
		/* Sat or Sun */
		if (tp->tm_wday == 6 || tp->tm_wday == 0
			|| tp->tm_hour >= 17 || tp->tm_hour < 8)
		    dayok = 1;
	    }
	    else if (PREFIX("Night", s)) {
		if (tp->tm_wday == 6  /* Sat */
			|| tp->tm_hour >= 23 || tp->tm_hour < 8
			/* Sunday before 5pm */
			|| (tp->tm_wday == 0 && tp->tm_hour < 17))
		    dayok = 1;
	    }
	    else if (PREFIX("ReachOut", s)) {
		if (tp->tm_wday == 6  /* Sat */
			|| tp->tm_hour >= 22 || tp->tm_hour < 8
			/* Sunday before 5pm */
			|| (tp->tm_wday == 0 && tp->tm_hour < 17))
		    dayok = 1;
	    }
	    else if (PREFIX("NonPeak", s)) { /* For Tymnet and PC Pursuit */
		/* Sat or Sun */
		if (tp->tm_wday == 6 || tp->tm_wday == 0
			|| tp->tm_hour >= 18 || tp->tm_hour < 7)
		    dayok = 1;
	    } else			/* check all possible days */
		for (i = 0; days[i]; i++)
		    if (PREFIX(days[i], s))
			if (tp->tm_wday == i)
			    dayok = 1;

	}
	if (dayok) {
	    int	t__low, t__high;

	    while (isalpha(*s))	/* flush remaining day stuff */
		s++;

	    if ((sscanf(s, "%d-%d", &t__low, &t__high) < 2)
		     || (t__low == t__high))
		return(grade);

	    /* 0000 crossover? */
	    if (t__low < t__high) {
		if (t__low <= t__now && t__now <= t__high)
		    return(grade);
	    } else if (t__low <= t__now || t__now <= t__high)
		return(grade);

	    /* aim at next time slot */
	    return (FAIL);
	}
	if (*s == '\0')
	    return (FAIL);
	s++;
    }
    return (FAIL);
}

/***
 *	char *
 *	fdig(cp)	find first digit in string
 *
 *	return - pointer to first digit in string or end of string
 */

char *
fdig(cp)
char *cp;
{
	char *c;

	for (c = cp; *c; c++)
		if (*c >= '0' && *c <= '9')
			break;
	return(c);
}


#ifdef FASTTIMER
/*	Sleep in increments of 60ths of second.	*/
nap (time)
register int time;
{
	static int fd;

	if (fd == 0)
		fd = open (FASTTIMER, 0);

	(*Read) (fd, 0, time);
}

#endif /* FASTTIMER */

#ifdef BSD

	/* nap(n) -- sleep for 'n' ticks of 1/60th sec each. */
	/* This version uses the select system call */


nap(n)
unsigned n;
{
	struct timeval tv;
	int rc;

	if (n==0)
		return;
	tv.tv_sec = n/60;
	tv.tv_usec = ((n%60)*1000000L)/60;
	rc = select(32, 0, 0, 0, &tv);
}

#endif /* BSD */

#ifdef NONAP

/*	nap(n) where n is ticks
 *
 *	loop using n/HZ part of a second
 *	if n represents more than 1 second, then
 *	use sleep(time) where time is the equivalent
 *	seconds rounded off to full seconds
 *	NOTE - this is a rough approximation and chews up
 *	processor resource!
 */

nap(n)
unsigned n;
{
	struct tms	tbuf;
	long endtime;
	int i;

	if (n > HZ) {
		/* > second, use sleep, rounding time */
		sleep( (int) (((n)+HZ/2)/HZ) );
		return;
	}

	/* use timing loop for < 1 second */
	endtime = times(&tbuf) + 3*n/4;	/* use 3/4 because of scheduler! */
	while (times(&tbuf) < endtime) {
	    for (i=0; i<1000; i++, i*i)
		;
	}
	return;
}


#endif /* NONAP */
