#ifndef lint
static char *sccsid = "$Id: dbg.c,v 1.2 1994/06/04 05:52:18 roger Exp $";
#endif

#include "dbg.h"
#include <ctype.h>
#include <stdio.h>

char  dbgflag = 1;	/* 0-9 are legal values */
char *dbgfile = 0;	/* Name of dbg output file */
FILE *dbgout  = 0;	/* Write dbg output here */
char *dbgtime();	/* Returns ASCII timestamp */
char *dbgtimp = 0;	/* ASCII version of time */
long  dbgtimv = 0;	/* Unix 32-bit timestamp */
#ifndef _FSTDIO		/* defined in bsd44 stdio.h */
extern char *sys_errlist;
extern int   sys_nerr;
#endif

/* Debugging output routine.
*/
dbgmsg(fmt,x0,x1,x2,x3,x4,x5,x6,x7,x8,x9)
	char *fmt;
{	int   r;

	if (dbgout == 0) 
		return 0;
	r = fprintf(dbgout,fmt,x0,x1,x2,x3,x4,x5,x6,x7,x8,x9);
	r+= fprintf(dbgout,"\n");
	fflush(dbgout);
	return r;
}
/* This routine decodes a "debug" option, which consists of a single-digit
** debug level, followed by a file name.  The file is opened as dbgout, and
** all debugging output goes there.  Note that we expect to be passed the
** address of the digit, which will usually be embedded in a longer string
** like "-X5/aud/fubar".
*/
dbgopt(ptr)
	char *ptr;
{
	if (isdigit(*ptr))
		 dbgflag = *ptr++ - '0';
	else dbgflag++;
	if (*ptr) 				/* There may be a file name specified */
		dbgfile = ptr;		/* If not, */
	if (dbgfile) {			/* there may be a default name */
		if (dbgout) fclose(dbgout);
		dbgout = fopen(dbgfile,"a");
		if (dbgout == 0) {
			fprintf(stderr,"Can't append to \"%s\"	[errno=%d]\n",
				dbgfile,errno);
			sleep(10);
			exit(1);
		}
		D1("+-----------------------+");
		D1("%s.",dbgtime());
		D3("Opened dbgfile \"%s\"",dbgfile);
	} else {
		/* If no debug file was specified, we might want to sent the
		** debug output to stderr, or we might just want to discard
		** it entirely.
		*/
		dbgout = stderr;	/* Let's send it to stderr */
	}
}
dbgtty(s)
	char *s;
{	int fd, saverr;

	saverr = errno;
	errno = 0;
	fd = open("/dev/tty",0);
	D2("open(\"/dev/tty\",0)=%d [errno=%d]",fd,errno);
	if (errno > 0 && errno < sys_nerr)
		D1("Can't open /dev/tty due to %s [%s]",sys_errlist,s);
	close(fd);
	errno = saverr;
}
/*
** Get the current local time, return pointer to the ASCII version.
*/
char *dbgtime()
{	char *ctime();

	time(&dbgtimv);
	dbgtimp = ctime(&dbgtimv);
	dbgtimp[24] = '\0';		/* We don't want the newline */
	return dbgtimp;
}
