
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/wait.h>

#include <netinet/in.h>

#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <netdb.h>
#include <fcntl.h>

int	errno;
int	reapchild();
struct	sockaddr_in sin = { AF_INET };
struct	passwd *getpwnam();
char	*index(), *rindex();
int	sprintf();
int	options;
/* VARARGS 1 */
int	error();
/*
 * remote shell server: Modified to run uucp.
 * command will be ignored, if host/user is equiv uucico will be run.
 *	remuser\0
 *	locuser\0
 *	command\0
 *	data
 */
main(argc, argv)
	int argc;
	char **argv;
{
	int f, linger;
	struct sockaddr_in from;
	struct servent *sp;

	sp = getservbyname("olduucp", "tcp");
	if (sp == 0) {
		fprintf(stderr, "olduucpd: tcp/olduucp: unknown service\n");
		exit(1);
	}
#ifndef DEBUG
	if (fork())
		exit(0);
	for (f = 0; f < 10; f++)
		(void) close(f);
	(void) open("/dev/console", O_WRONLY | O_APPEND);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
#endif
	sin.sin_port = sp->s_port;
	argc--, argv++;
	if (argc > 0 && !strcmp(argv[0], "-d")) {
		options |= SO_DEBUG;
		argc--, argv++;
	}
	if (argc > 0) {
		int port = atoi(argv[0]);

		if (port < 0) {
			fprintf(stderr, "%s: bad port #\n", argv[0]);
			exit(1);
		}
		sin.sin_port = htons((unsigned short)port);
		argc--, argv++;
	}
	f = socket(AF_INET, SOCK_STREAM, 0, 0);
	if (f < 0) {
		perror("uucpd: socket");
		exit(1);
	}
	if (options & SO_DEBUG && setsockopt(f, SOL_SOCKET, SO_DEBUG, 0, 0) < 0)
		perror("uucpd: setsockopt (SO_DEBUG)");
	if (setsockopt(f, SOL_SOCKET, SO_KEEPALIVE, 0, 0) < 0)
		perror("uucpd: setsockopt (SO_KEEPALIVE)");
	linger = 60;			/* XXX */
	if (setsockopt(f, SOL_SOCKET, SO_LINGER, &linger, sizeof(int)) < 0)
		perror("uucpd: setsockopt (SO_LINGER)");
	if (bind(f, (caddr_t)&sin, sizeof (sin), 0) < 0) {
		perror("uucpd: bind");
		exit(1);
	}
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGHUP, SIG_IGN);
	signal(SIGCLD, SIG_IGN);
	listen(f, 10);
	for (;;) {
		int g, len = sizeof (from);

		g = accept(f, &from, &len, 0);
		if (g < 0) {
			if (errno == EINTR)
				continue;
			perror("uucpd: accept");
			continue;
		}
		if (fork() == 0) {
			signal(SIGCLD, SIG_DFL);
			close(f);
			doit(g, &from);
		}
		close(g);
	}
}


char	username[20] = "USER=";
char	logname[23] = "LOGNAME=";
char	homedir[64] = "HOME=";
char	shell[64] = "SHELL=";
char	*envinit[] =
	    {homedir, shell, "PATH=:/usr/local/bin:/bin:/usr/bin:/etc", username, logname, 0};
char	**environ;

doit(f, fromp)
	int f;
	struct sockaddr_in *fromp;
{
	char cmdbuf[NCARGS+1], *cp;
	char locuser[16], remuser[16];
	struct passwd *pwd;
	struct hostent *hp;
	short port;
	int pv[2], pid, ready, readfrom, cc;
	char buf[BUFSIZ], sig;
	int one = 1;

	(void) signal(SIGINT, SIG_DFL);
	(void) signal(SIGQUIT, SIG_DFL);
	(void) signal(SIGTERM, SIG_DFL);
#ifdef DEBUG
	{ int t = open("/dev/tty", 2);
	  if (t >= 0) {
		(void) close(t);
	  }
	}
#endif
	fromp->sin_port = ntohs((unsigned short)fromp->sin_port);
	if (fromp->sin_family != AF_INET) {
		fprintf(stderr, "uucpd: malformed from address\n");
		exit(1);
	}
	(void) alarm(60);
	port = 0;
	for (;;) {
		char c;
		if (read(f, &c, 1) != 1) {
			perror("uucpd: read");
			shutdown(f, 1+1);
			exit(1);
		}
		if (c == 0)
			break;
		port = port * 10 + c - '0';
	}
	(void) alarm(0);
	dup2(f, 0);
	dup2(f, 1);
	dup2(f, 2);
	hp = gethostbyaddr(&fromp->sin_addr, sizeof (struct in_addr),
		fromp->sin_family);
	if (hp == 0) {
		error("Host name for your address unknown\n");
		exit(1);
	}
	getstr(remuser, sizeof(remuser), "remuser");
	getstr(locuser, sizeof(locuser), "locuser");
	getstr(cmdbuf, sizeof(cmdbuf), "command");
	setpwent();
	pwd = getpwnam(locuser);
	if (pwd == NULL) {
		error("Login incorrect.\n");
		exit(1);
	}
	endpwent();
	if (chdir(pwd->pw_dir) < 0) {
		error("No remote directory.\n");
		exit(1);
	}
	if (versys(hp->h_name) != 0 || pwd->pw_uid == 0) {
		error("Permission denied.\n");
		exit(1);
	}
	(void) write(2, "\0", 1);
	if (strcmp(pwd->pw_shell, "/usr/lib/uucp/uucico")) {
		error("Not nuucp");
		exit(1);
	}
	(void) close(f);
	(void) setgid(pwd->pw_gid);
	(void) setuid(pwd->pw_uid);
	environ = envinit;
	strncat(homedir, pwd->pw_dir, sizeof(homedir)-6);
	strncat(shell, pwd->pw_shell, sizeof(shell)-7);
	strncat(username, pwd->pw_name, sizeof(username)-6);
	strncat(logname, pwd->pw_name, sizeof(logname)-9);
	cp = rindex(pwd->pw_shell, '/');
	if (cp)
		cp++;
	else
		cp = pwd->pw_shell;
	execl(pwd->pw_shell, cp, 0);
	perror(pwd->pw_shell);
	exit(1);
protofail:
	error("uucp: protocol failure detected by remote\n");
	exit(1);
}

/* VARARGS 1 */
error(fmt)
	char *fmt;
{
	char buf[BUFSIZ];

	buf[0] = 1;
	(void) sprintf(buf+1, fmt);
	(void) write(2, buf, strlen(buf));
}

getstr(buf, cnt, err)
	char *buf;
	int cnt;
	char *err;
{
	char c;

	do {
		if (read(0, &c, 1) != 1)
			exit(1);
		*buf++ = c;
		if (--cnt == 0) {
			error("%s too long\n", err);
			exit(1);
		}
	} while (c != 0);
}
