
#ifndef lint
static char sccsid[] = "@(#)uucpd.c	5.4 (Berkeley) 6/23/85";
#endif

/*
 * CTIX TCP/IP server for uucico
 * uucico's TCP channel causes this server to be run at the remote end.
 */

#include "uucp.h"
#include <netdb.h>
#include <signal.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/in.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <pwd.h>

#define bzero(buf,len) memset(buf, 0, len)

struct	sockaddr_in hisctladdr;
int hisaddrlen = sizeof hisctladdr;
struct	sockaddr_in myctladdr;
int mypid;

char Username[64];
char *nenv[] = {
	Username,
	NULL,
};
extern char **environ;

main(argc, argv)
int argc;
char **argv;
{
#ifndef BSDINETD
	register int s, tcp_socket;
	struct servent *sp;
#endif /* !BSDINETD */
	extern int errno;
	int dologout();

	environ = nenv;
#ifdef BSDINETD
	close(1); close(2);
	dup(0); dup(0);
	hisaddrlen = sizeof (hisctladdr);
	if (getpeername(0, &hisctladdr, &hisaddrlen) < 0) {
		fprintf(stderr, "%s: ", argv[0]);
		perror("getpeername");
		_exit(1);
	}
	if (fork() == 0)
		doit(&hisctladdr);
	dologout();
	exit(1);
#else /* !BSDINETD */
	sp = getservbyname("uucp", "tcp");
	if (sp == NULL){
		perror("uucpd: getservbyname");
		exit(1);
	}
	if (fork())
		exit(0);
	setpgrp();

	bzero((char *)&myctladdr, sizeof (myctladdr));
	myctladdr.sin_family = AF_INET;
	myctladdr.sin_port = sp->s_port;

	tcp_socket = socket(AF_INET, SOCK_STREAM, 0);
	if (tcp_socket < 0) {
		perror("uucpd: socket");
		exit(1);
	}
	if (bind(tcp_socket, (char *)&myctladdr, sizeof (myctladdr)) < 0) {
		perror("uucpd: bind");
		exit(1);
	}
	listen(tcp_socket, 3);	/* at most 3 simultaneuos uucp connections */
	signal(SIGCLD, dologout);

	for(;;) {
		s = accept(tcp_socket, &hisctladdr, &hisaddrlen);
		if (s < 0){
			if (errno == EINTR) 
				continue;
			perror("uucpd: accept");
			exit(1);
		}
		if (fork() == 0) {
			close(0); close(1); close(2);
			dup(s); dup(s); dup(s);
			close(tcp_socket); close(s);
			doit(&hisctladdr);
			exit(1);
		}
		close(s);
	}
#endif	/* !BSDINETD */
}

doit(sinp)
struct sockaddr_in *sinp;
{
	char user[64], passwd[64];
	char *xpasswd, *crypt();
	struct passwd *pw, *getpwnam();

	alarm(60);
	printf("login: "); fflush(stdout);
	if (readline(user, sizeof user) < 0) {
		fprintf(stderr, "user read\n");
		return;
	}
	/* truncate username to 8 characters */
	user[8] = '\0';
	pw = getpwnam(user);
	if (pw == NULL) {
		fprintf(stderr, "user unknown\n");
		return;
	}
	if (strcmp(pw->pw_shell, UUCICO)) {
		fprintf(stderr, "Login incorrect.");
		return;
	}
	if (pw->pw_passwd && *pw->pw_passwd != '\0') {
		printf("Password: "); fflush(stdout);
		if (readline(passwd, sizeof passwd) < 0) {
			fprintf(stderr, "passwd read\n");
			return;
		}
		xpasswd = crypt(passwd, pw->pw_passwd);
		if (strcmp(xpasswd, pw->pw_passwd)) {
			fprintf(stderr, "Login incorrect.");
			return;
		}
	}
	alarm(0);
	sprintf(Username, "USER=%s", user);
	dologin(pw, sinp);
	setgid(pw->pw_gid);
	chdir(pw->pw_dir);
	setuid(pw->pw_uid);
	execl(UUCICO, "uucico", (char *)0);
	perror("uucico server: execl");
}

readline(p, n)
register char *p;
register int n;
{
	char c;

	while (n-- > 0) {
		if (read(0, &c, 1) <= 0)
			return(-1);
		c &= 0177;
		if (c == '\n' || c == '\r') {
			*p = '\0';
			return(0);
		}
		*p++ = c;
	}
	return(-1);
}

#include <utmp.h>

#define	SCPYN(a, b)	strncpy(a, b, sizeof (a))

struct	utmp utmp;

dologout()
{
	union wait status;
	int pid, wtmp;

#ifdef ATTSV
	pid=wait(&status);
	signal(SIGCLD, dologout);
	wtmp = open(WTMP_FILE, O_WRONLY|O_APPEND);
#else
#ifdef BSDINETD
	while ((pid=wait(&status)) > 0) {
#else  /* !BSDINETD */
	while ((pid=wait3(&status,WNOHANG,0)) > 0) {
#endif /* !BSDINETD */
		wtmp = open("/usr/adm/wtmp", O_WRONLY|O_APPEND);
#endif /* ATTSV */
		if (wtmp >= 0) {
			sprintf(utmp.ut_line, "uucp%.4d", pid);
#ifdef ATTSV
			utmp.ut_type = DEAD_PROCESS;
			SCPYN(utmp.ut_name, "uucpd");
			utmp.ut_pid = pid;
			utmp.ut_exit.e_termination = status.w_status & 0xff;
			utmp.ut_exit.e_exit = (status.w_status >> 8) & 0xff;
			utmp.ut_id[0] = 0;
#else /* ATTSV */
			SCPYN(utmp.ut_name, "");
			SCPYN(utmp.ut_host, "");
#endif /* ATTSV */
			(void) time(&utmp.ut_time);
			(void) write(wtmp, (char *)&utmp, sizeof (utmp));
			(void) close(wtmp);
		}
#ifndef ATTSV
	}
#endif /* ATTSV */
}

/*
 * Record login in wtmp file.
 */
dologin(pw, sin)
struct passwd *pw;
struct sockaddr_in *sin;
{
	char line[32];
	int wtmp, f;
#ifndef ATTSV
	char remotehost[32];
	struct hostent *hp;

	hp = gethostbyaddr(&sin->sin_addr, sizeof (struct in_addr), AF_INET);
	if (hp) {
		strncpy(remotehost, hp->h_name, sizeof (remotehost));
		endhostent();
	} else
		strncpy(remotehost, inet_ntoa(sin->sin_addr),
		    sizeof (remotehost));
	wtmp = open("/usr/adm/wtmp", O_WRONLY|O_APPEND);
#else /* ATTSV */
	wtmp = open(WTMP_FILE, O_WRONLY|O_APPEND);
#endif /* ATTSV */
	if (wtmp >= 0) {
		/* hack, but must be unique and no tty line */
		sprintf(line, "uucp%.4d", getpid());
		SCPYN(utmp.ut_line, line);
		SCPYN(utmp.ut_name, pw->pw_name);
#ifdef ATTSV
		utmp.ut_type = USER_PROCESS;
		utmp.ut_pid = getpid();
		utmp.ut_id[0] = 0;
#else /* ATTSV */
		SCPYN(utmp.ut_host, remotehost);
#endif
		time(&utmp.ut_time);
		(void) write(wtmp, (char *)&utmp, sizeof (utmp));
		(void) close(wtmp);
	}
#ifndef ATTSV
	if ((f = open(lastlog, 2)) >= 0) {
		struct lastlog ll;

		time(&ll.ll_time);
		lseek(f, (long)pw->pw_uid * sizeof(struct lastlog), 0);
		strcpy(line, remotehost);
		SCPYN(ll.ll_line, line);
		SCPYN(ll.ll_host, remotehost);
		(void) write(f, (char *) &ll, sizeof ll);
		(void) close(f);
	}
#endif /* ATTSV */
}
