#include "uucp.h"
VERSION("$Id: uuq.c,v 1.6 1993/02/26 13:32:56 roger Exp $");

/* LOCAL additions 
 *
 * Future enhancement: lookup STST and LCK files and add info into
 * [-L] listing for a complete picture.
 */
#define LOCAL
/* #define LOOKUP_BAUDRATE		/* really lookup baudrate in Systems */
#define SUBJOB			/* allow -L for detailing subjobs */
#define LOCK_CHECK		/* allow -p for detailing locks */
/*
 * uuq - looks at uucp queues
 *
 * Lou Salkind
 * New York University
 *
 * "uuq.c	4.6 (Berkeley) 10/9/85";
 */

#define	NOSYS		(struct sys *)0

#define W_TYPE		wrkvec[0]
#define W_FILE1		wrkvec[1]
#define W_FILE2		wrkvec[2]
#define W_USER		wrkvec[3]
#define W_OPTNS		wrkvec[4]
#define W_DFILE		wrkvec[5]
#define W_MODE		wrkvec[6]
#define WSUFSIZE 5	/* work file name suffix size */

#ifdef LOCAL	/* got tired of separating the options added... */
#  define OPTIONS    "Llhps:u:k:r:b:x:"
#  define	USAGE "usage: uuq [-l|-L] [-h] [-p] [-s system] [-u user] [-r spool] [-b baudrate] or [-k jobno]\n"
#else /* !LOCAL */
#  define OPTIONS    "lhs:u:k:r:b:x:"
#  define	USAGE "usage: uuq [-l] [-h] [-s system] [-u user] [-r spool] [-b baudrate] or [-k jobno]\n"
#endif /* LOCAL */

struct sys {
	char	s_name[MAXBASENAME];
	int	s_njobs;
	off_t	s_bytes;
#ifdef LOOKUP_BAUDRATE
	float	s_baudrate;		/* looked up in Systems */
#endif /* LOOKUP_BAUDRATE */
	struct job	*s_jobp;	/* jobs for this system */
	struct sys	*s_sysp;	/* next system with jobs */
};

#ifdef SUBJOB
struct subJob {				/* sub job, for multi file jobs. */
	char	j_fname[128];
	off_t	j_bytes;
	struct subJob	*sb_subjobp;
};
#endif /* SUBJOB */

struct job {
	int	j_files;
	int	j_flags;
	char	j_jobno[WSUFSIZE];
	char	j_user[22];
	char	j_fname[128];
	char	j_grade;
	off_t	j_bytes;
	time_t	j_date;
#ifdef SUBJOB
	struct subJob	*j_subjobp;	/* sub-jobs (detail multi-file jobs) */
#endif /* SUBJOB */
	struct job	*j_jobp;	/* next job for this system */
};

struct sys *syshead;
struct sys *getsys();
int jcompare();
static void kprocess(), gather();
#ifdef LOOKUP_BAUDRATE
static float sysToBaud();
static finds(), getto(), rddev(), classmatch();
#endif /* LOOKUP_BAUDRATE */

char *rmjob;
int hflag = 0;		/*  == 1 if -h specified */
int lflag = 0; 		/*  == 1 if -l specified */
short Kill;		/*  == 1 if -k specified */
short Uopt;		/*  == 1 if -u option specified */
short Sysopt;		/*  == 1 if -s option specified */
#ifdef SUBJOB
short Lopt;		/*  == 1 if -L option specified (implies -l) */
#endif /* SUBJOB */
#ifdef LOCK_CHECK
short Popt;		/*  == 1 if -p option specified */
#endif /* LOCK_CHECK */

char *malloc(), *calloc();
double atof();
static float Baudrate = 1200.;
static char Filename[BUFSIZ];
static int Maxulen = 0;

main(argc, argv)
char **argv;
{
    register i;
    register struct sys *sp;
    register struct job *jp;
    struct job **sortjob;
    int nsys, ret;
    char msg[BUFSIZ];

    User[0] = '\0';
    Rmtname[0] = '\0';
    strcpy(Progname, "uuq");
    Uid = getuid();
    Euid = geteuid();
    guinfo(Uid, Loginuser, msg);
#ifdef LOOKUP_BAUDRATE
    serviceFind ("uucico");	/* pretend */
#endif /* LOOKUP_BAUDRATE */

    while ((ret = getopt(argc, argv, OPTIONS)) != EOF) {
	switch (ret) {
#ifdef SUBJOB
	case 'L':
	    Lopt++;	/* fall_thru */
#endif /* SUBJOB */
	case 'l':
	    lflag++;
	    break;
	case 'h':
	    hflag++;
	    break;
	case 'r':
	    strcpy(Spool, optarg);
	    break;
	case 's':
	    (void) strncpy(Rmtname, optarg, MAXBASENAME);
	    Rmtname[MAXBASENAME] = '\0';
	    Sysopt = 1;
	    break;
	case 'u':
	    (void) strncpy(User, optarg, 8);
	    User[8] = '\0';
	    Uopt = 1;
	    break;
	case 'k':
	    rmjob = optarg;
	    Kill = 1;
	    break;
	case 'b':
	    Baudrate = (float)atof(optarg);
	    break;
	case 'x':
	    Debug = atoi(optarg);
	    if (Debug <= 0)
		Debug = 1;
	    break;
#ifdef LOCK_CHECK
	case 'p':	/* NOTE: unlike uustat, -p can be combined w/other */
	    Popt++;	/* options.  It just gets printed last. */
	    break;
#endif /* LOCK_CHECK */
	default:
	    fprintf(stderr, USAGE);
	    exit(2);
	}
    }

    if (!Uopt)
	strcpy(User, Loginuser);
    else if (!lflag)
	fprintf(stderr, "Warning: -u [user] ignored without -l flag\n");
    DEBUG(9, "Progname (%s): STARTED\n", Progname);
    DEBUG(9, "User=%s, ", User);
    DEBUG(9, "Loginuser=%s, ", Loginuser);
    DEBUG(9, "Jobid=%s, ", rmjob);
    DEBUG(9, "Rmtname=%s\n", Rmtname);

    ASSERT(chdir(Spool) == 0, Ct_CHDIR, Spool, errno);
    Baudrate *= 0.7;	/* reduce speed because of protocol overhead */
    Baudrate *= 6.; 	/* convert to chars/minute (60/10) */
    gather();
    nsys = 0;

    for (sp = syshead; sp; sp = sp->s_sysp) {
	float u_baudrate;

	if (sp->s_njobs == 0)
	    continue;
	if (!hflag && nsys++ > 0)
	    putchar('\n');
	printf("%s: %d %s", sp->s_name,
		    sp->s_njobs, sp->s_njobs > 1 ? "jobs" : "job");
	if (lflag || hflag) {
	    float minutes;
	    int hours;

#ifdef LOOKUP_BAUDRATE
	    u_baudrate = (sp->s_baudrate > 0.0) ? sp->s_baudrate : Baudrate;
#else
	    u_baudrate = Baudrate;
#endif /* LOOKUP_BAUDRATE */
	    /* The 80 * njobs is because of the uucp handshaking */
	    minutes = (float)(sp->s_bytes+80 * sp->s_njobs)/u_baudrate;
	    hours = minutes/60;
	    printf(", %d bytes", sp->s_bytes);
	    if (minutes > 60){
		printf(", %d hour%s",hours, hours > 1 ? "s": "");
		minutes -= 60 * hours;
	    }
	    printf(", %3.1f minutes (@ %d characters per second)",
			    minutes,(int)u_baudrate/60);
	}
	putchar('\n');
	if (hflag)
	    continue;
	/* sort them babies! */
	sortjob = (struct job **)calloc(sp->s_njobs, sizeof (struct job *));
	for (i=0, jp=sp->s_jobp; i < sp->s_njobs; i++, jp=jp->j_jobp)
	    sortjob[i] = jp;
	qsort(sortjob, sp->s_njobs, sizeof (struct job *), jcompare);
	for (i = 0; i < sp->s_njobs; i++) {
	    jp = sortjob[i];
	    if (lflag) {
#ifdef SUBJOB
		if (jp->j_files == 1 || !Lopt) {
#endif /* SUBJOB */
		    printf("%s %c %2d %-*s%7d%6.1f %-12.12s %c %.*s\n",
			    jp->j_jobno, jp->j_grade, jp->j_files, Maxulen, 
			    jp->j_user, jp->j_bytes, jp->j_bytes/u_baudrate,
			    ctime(&jp->j_date) + 4, jp->j_flags, 
			    sizeof (jp->j_fname), jp->j_fname);
#ifdef SUBJOB
		/* for subjob detailing, jobs_line_1 contains
		 * info about the entire job (jobno, grade, who, total_bytes),
		 * subsequent lines contain individual job file names.
		 */
		} else {
		    register struct subJob *subjp;

		    printf("%s %c %2d %-*s%7d%6.1f %-12.12s %c\n",
			    jp->j_jobno, jp->j_grade, jp->j_files, Maxulen, 
			    jp->j_user, jp->j_bytes, jp->j_bytes/u_baudrate,
			    ctime(&jp->j_date) + 4, jp->j_flags );
		    for (subjp = jp->j_subjobp; subjp != 0; 
			    subjp = subjp->sb_subjobp) {
			printf("%*s      %-*s%7d%6.1f %.*s\n",
				strlen(jp->j_jobno), " ", Maxulen, " ",
				subjp->j_bytes, subjp->j_bytes/u_baudrate,
				sizeof (subjp->j_fname), subjp->j_fname);
		    }
		}
#endif /* SUBJOB */
	    } else {
		printf("%s", jp->j_jobno);
		putchar((i+1)%10 ? '\t' : '\n');
	    }
	}
	if (!lflag && (sp->s_njobs%10))
	    putchar('\n');
    }
#ifdef LOCK_CHECK
    if (Popt)
	lckpid();	/* does not return */
#endif /* LOCK_CHECK */
    exit(0);
}

jcompare(j1, j2)
struct job **j1, **j2;
{
    int delta;

    delta = (*j1)->j_grade - (*j2)->j_grade;
    if (delta)
	return delta;
    return(!EQUALS((*j1)->j_jobno,(*j2)->j_jobno));
}

/*
**	Get all the command (C.*) filenames
*/
static void
gather()
{
    DIR *df, *sd;			/* df = dir, sd = subdir */
    char	f[256], name[256];

    /*
    ** Find all the spool files.  At the /usr/spool/uucp level there
    ** should only be directory entries.  Soooo...we will grab a directory
    ** name and then recursively travel downward and grab all the command
    ** filenames.
    */

    if ((df = opendir(Spool)) == NULL) {
	fprintf(stderr, "can't examine spooling area");
	exit(1);
    }
    /*
    ** here we are looking at directories...
    */
    while (gnamef(df, f) == TRUE) {
	if (DIRECTORY(f)) {
	    if ((sd = opendir(f)) != NULL) {
		while(gnamef(sd, name) == TRUE) {
		    if ((strlen(name) > 2) && (EQUALSN(name, "C.", 2))) {
			if (analjob(f, name) < 0) {
			    fprintf(stderr, "out of memory\n");
			    exit(1);
			}
		    }
		}
		closedir(sd);
	    } else {
		fprintf(stderr, "could not open '%s'\n", f);
		exit(1);
	    }
	}
    }
    closedir(df);
}

/*
**	analjob(f, filename)
**	char *f, filename;
**
**	"f" is the directory containing "filename".  "f" is relative
**	to /usr/spool/uucp.  The "f" parameter was added because 
**	Berkeley 'stock' UUCP would simply throw every single outgoing
**	UUCP chore in the /usr/spool/uucp directory;  HoneyDanBer creates
**	a separate directory for each system with work queued.
*/

analjob(f, filename)
char	*f;
char	*filename;
{
#ifdef	SUBJOB
    struct subJob *subjp;
#endif /* SUBJOB */
    struct job *jp;
    struct sys *sp;
    char sbuf[MAXBASENAME+1], str[256], nbuf[256];
    char rfullname[MAXFULLNAME], fullname[MAXFULLNAME], xfullname[MAXFULLNAME];
    char  *jptr, *wrkvec[20];
    char grade;
    FILE *fp, *df;
    struct stat statb;
    int files, gotname, i, first;
    off_t bytes;

    DEBUG(9, "analjob(%s, ", f);
    DEBUG(9, "%s);\n", filename);
    first = 1;
    strncpy(sbuf, filename, MAXBASENAME);
    sbuf[MAXBASENAME] = '\0';
    jptr = sbuf + strlen(sbuf) - WSUFSIZE;
    grade = *jptr;
    *jptr++ = 0;
    /*
     * sbuf+2 now points to sysname name (null terminated)
     * jptr now points to job number (null terminated)
     */
    if (Kill) {
	if (!EQUALS(rmjob, jptr))	/* not this one */
	    return(0);
    } else {
	if ((sp = getsys(f)) == NOSYS)
	    return(0);
	jp = (struct job *)malloc(sizeof(struct job));
	if (jp == (struct job *)0)
	    return(-1);
#ifdef SUBJOB
	jp->j_subjobp = 0;
#endif /* SUBJOB */
	if (!(lflag || hflag)) {
	    /* SHOULD USE A SMALLER STRUCTURE HERE */
	    strcpy(jp->j_jobno, jptr);
	    jp->j_jobp = sp->s_jobp;
	    jp->j_grade = grade;
	    sp->s_jobp = jp;
	    sp->s_njobs++;
	    return(1);
	}
    }

    sprintf(fullname, "%s/%s", f, filename);
    if ((fp = fopen(fullname, "r")) == NULL) {
	if (Kill) {
	    fprintf(stderr, "Can't read:%s, errno (%d)--can't kill it!\n",
		    fullname, errno);
	    exit(1);
	}
	DEBUG(4, "Can't open file (%s), ", fullname);
	DEBUG(4, "errno=%d -- skip it!\n", errno);
	return(0);
    }
    gotname = bytes = files = 0;
    while (fgets(str, sizeof str, fp)) {
	if (getargs(str, wrkvec, 20) <= 0)
	    continue;
	DEBUG(9, "type (%s), ", W_TYPE);
	DEBUG(9, "file1 (%s), ", W_FILE1);
	DEBUG(9, "file2 (%s), ", W_FILE2);
	DEBUG(9, "dfile (%s), ", W_DFILE);
	DEBUG(9, "user (%s), ", W_USER);
	DEBUG(9, "options (%s)\n", W_OPTNS);
	if (W_TYPE[0] == 'S')
	    sprintf(rfullname, "%s/%s", f, W_DFILE);
	if (Kill) {
	    if (first) {
	        if (Uid != 0 && !EQUALS(Loginuser, W_USER) ) {
		    /* not allowed - not owner or root */
		    fprintf(stderr, "Not owner or root - can't kill job %s\n",
    			    rmjob);
		    exit(1);
		}
		first = 0;
	    }
	    kprocess("data",W_DFILE,rfullname);
	    continue;
	}
	if (Uopt && (W_TYPE[0] == 'X' || !PREFIX(User, W_USER))) {
	    fclose(fp);
	    return(0);
	}
	files++;
	if (W_TYPE[0] == 'S') {
	    if (!EQUALS(W_DFILE, "D.0") && stat(rfullname, &statb) >= 0)
		bytes += statb.st_size;		/* Spool/machine/D.file */
	    else if (stat(W_FILE1, &statb) >= 0)
		bytes += statb.st_size;		/* source file */
	}
	/* for X file, show command instead of name of datafile */
	if (gotname == 0 && W_FILE2[0] == 'X') {
	    sprintf(xfullname, "%s/%s", f, W_FILE1);
	    if ((df = fopen(xfullname, "r")) == NULL) { /* program error */
		DEBUG(4, "Can't read %s, ", xfullname);
		DEBUG(4, "errno=%d -- skip it!\n", errno);
		continue;
	    }
	    while (fgets(nbuf, sizeof nbuf, df)) {
		nbuf[strlen(nbuf) - 1] = '\0';
		if (nbuf[0] == 'C' && nbuf[1] == ' ') {
		    strcpy(Filename, nbuf+2);
		    gotname++;
		}
	    }
	    fclose(df);
	}
#ifdef SUBJOB
	/* tuck away the individual job names and sizes */
	if (Lopt) {
	    subjp = (struct subJob *)malloc(sizeof(struct subJob));
	    if (subjp == (struct subJob *)0)
		return(-1);
	    strncpy(subjp->j_fname, W_FILE2[0] == 'X' ? Filename : W_FILE1,
		    sizeof jp->j_fname);
	    subjp->j_bytes = statb.st_size;
	    subjp->sb_subjobp = jp->j_subjobp;
	    jp->j_subjobp = subjp;
	}
#endif /* SUBJOB */
    }
    fclose(fp);
    if (Kill) {
	kprocess("command", filename, fullname);
	printf("Job: %s successfully killed\n", rmjob);
	exit(0);
    }
    if (files == 0) {
	static char *wtype = "X";
	static char *wfile = "forced poll";

	if (!EQUALS("POLL", &fullname[strlen(fullname)-4])) {
	     fprintf(stderr, "%.14s: empty command file\n", filename);
	     return(0);
	}
	W_TYPE = wtype;
	W_FILE1 = wfile;
    }
    strcpy(jp->j_jobno, jptr);
    jp->j_files = files;
    jp->j_bytes = bytes;
    jp->j_grade = grade;
    jp->j_flags = W_TYPE[0];
    strncpy(jp->j_user, W_TYPE[0]=='X' ? "---" : W_USER, 20 );
    jp->j_user[20] = '\0';
    i = strlen(jp->j_user);
    if (i > Maxulen)
	Maxulen = i;
    /* SHOULD ADD ALL INFORMATION IN THE WHILE LOOP */
    if (gotname)
	strncpy(jp->j_fname, Filename, sizeof jp->j_fname);
    else
	strncpy(jp->j_fname, W_FILE1, sizeof jp->j_fname);
    stat(fullname, &statb);
    jp->j_date = statb.st_mtime;
    jp->j_jobp = sp->s_jobp;
    sp->s_jobp = jp;
    sp->s_njobs++;
    sp->s_bytes += jp->j_bytes;
    return(1);
}

static void
kprocess(tfile,filename, rfullname)
char *tfile, *filename, *rfullname;
{
    int ret;

    ret = unlink(rfullname);
    if (ret != 0 && errno != ENOENT) {
	/* program error?? */
	fprintf(stderr,"Error: Can't kill, %s File (%s), errno (%d)\n",
		tfile, rfullname, errno);
	exit(1);
    } else {
	DEBUG(4, "Removed %s ", tfile);
	DEBUG(4, "file %s\n", filename);
    }
}

struct sys *
getsys(s)
register char *s;
{
    register struct sys *sp;

    for (sp = syshead; sp; sp = sp->s_sysp)
	if (!EQUALS(s, sp->s_name) == 0)
	    return(sp);

    if (Sysopt && (!EQUALSN(Rmtname, s, (strlen(Rmtname) < strlen(s)) ? 
		    strlen(Rmtname) : strlen(s))))
	return(NOSYS);
    sp = (struct sys *)malloc(sizeof(struct sys));
    if (sp == NOSYS)
	return(NOSYS);
    strcpy(sp->s_name, s, MAXBASENAME);
    sp->s_njobs = 0;
    sp->s_jobp = (struct job *)0;
    sp->s_sysp = syshead;
    sp->s_bytes = 0;
#ifdef LOOKUP_BAUDRATE
    sp->s_baudrate = (lflag || hflag) ? sysToBaud(s) : Baudrate;
/*     DEBUG(4, "sysToBaud returned (%f)\n", sp->s_baudrate); */
#endif /* LOOKUP_BAUDRATE */
    syshead = sp;
    return(sp);
}


/*
**	cleanup(value)
**	int	value;
**
**	This is here because many of the generic UUCP routines call
**	cleanup() versus just preforming an exit.  This very simple
**	routine was included primarily to prevent unresolved references
**	at link time.
*/
cleanup(value)
int	value;
{
    exit(value);
}

void systat(){}		/* to load utility.c */


#ifdef LOOKUP_BAUDRATE

static float
sysToBaud(system)
char *system;
{
    char *flds[F_MAX+1], *file;
    FILE *fsys = NULL;
    int findex=0, nf;
    float baudrate;

    DEBUG(4,"sysToBaud(%s)\n", system);
    if (( file = nameSysFile (O_SYSTEMS,&findex)) != NULL) {
	DEBUG(10, "use Systems: %s\n", file);
	fsys = fopen (file, "r");
    }
    ASSERT(fsys != NULL, Ct_OPEN, file, errno);
    if ((nf = finds(fsys, system, flds, F_MAX, &findex)) > 0) {
	/* compute baudrate */
	if (EQUALS(flds[F_CLASS], "Any")){
	    if (getto(flds) == FAIL){	/* sets flds[F_CLASS] upon success */
		DEBUG(4,"getto returned FAIL\n", "");
		return(0.0);
	    }
	}
	DEBUG(4, "Using baudrate of %s\n", flds[F_CLASS]);
	baudrate = (float)atof(flds[F_CLASS]);
	baudrate *= 0.75;	/* reduce speed because of protocol overhead */
	baudrate *= 6.; 	/* convert to chars/minute (60/10) */
	return(baudrate);
    } 
    DEBUG(4,"finds returned FAIL\n", "");
    return(0.0);
}

/*
 *	code from conn.c
 *	finds the first valid system entry (only restriction is that
 *	it must not have "Never" in the time field).
 *	Used for baudrate computations.
 */
static
finds(fsys, sysnam, flds, fldcount, findex)
char *sysnam, *flds[];
FILE *fsys;
int *findex;
{
    static char info[BUFSIZ];
    int na;
    char *file;

    /* format of fields
     *	0 name;
     *	1 time
     *	2 acu/hardwired
     *	3 speed
     *	etc
     */
    Uerror = 0;
    for (;;){
	while (fgets(info, BUFSIZ, fsys) != NULL) {
	    if (info[0] == '#')
		continue;
	    na = getargs(info, flds, fldcount);
/*	    bsfix(flds);	/* replace \X fields */
	    if (!EQUALSN(sysnam, flds[F_NAME], SYSNSIZE))
		continue;
	    if (PREFIX("Never",flds[F_TIME]))
		continue;
	    /* found a good entry */
	    fclose (fsys);
	    return(na);	/* FOUND OK LINE */
	}
	/* if we didn't find the system, try the next systems file */
	if (( file = nameSysFile (O_SYSTEMS,findex)) != NULL) {
	    fclose (fsys);
	    DEBUG(10, "use Systems: %s\n", file);
	    fsys = fopen (file, "r");
	}
	if (fsys != NULL && file != NULL)
	    continue;

	/* no more systems files, back out here */
	if (!Uerror)
	    Uerror = SS_BADSYSTEM;
	return(FAIL);
    }
    /* NOTREACHED */
}

/*
 *	code from conn.c
 *	finds a valid device line.  Only restriction is that
 *	classmatch() must succeed.
 */
static
getto(flds)
char *flds[];
{
    struct caller	*ca;
    char 	dcname[20], *s;
    int		nargs, dh, i;
    int		findex=0;
    FILE	*dfp = NULL;
    char 	*dev[D_MAX+1], *file;
    static char	devbuf[BUFSIZ];

    /*
     *	find device type F_LINE with the correct speed in DEVFILE
     */
    CDEBUG(1, "Device Type %s wanted\n", flds[F_LINE]);
    if (( file = nameSysFile (O_DEVICES,&findex)) != NULL) {
	DEBUG(10, "use Devices: %s\n", file);
	dfp = fopen (file, "r");
    }
    ASSERT(dfp != NULL, Ct_OPEN, file, errno);
    while ((nargs = rddev(dfp,flds[F_LINE],dev,devbuf,D_MAX,&findex)) != FAIL){
	/* check class, check (and possibly set) speed */
	if (classmatch(flds, dev) != SUCCESS)
	    continue;
	return(SUCCESS);
    }
    fclose(dfp);
    return(FAIL);
}

static int
rddev(fp, type, dev, buf, devcount, findex)
FILE *fp;
char *type;
char *dev[];
char *buf;
int *findex;
{
    int na;
    char *file;

    for (;;) {
	while (fgets(buf, BUFSIZ, fp) != NULL) {
	    if (buf[0] == ' ' || buf[0] == '\t' || buf[0] == '#' ||
				buf[0] == '\0')
		continue;
	    na = getargs(buf, dev, devcount);
	    ASSERT(na >= 5, "BAD LINE", buf, na);

/*	    bsfix(dev);	/* replace \X fields */
	    if (EQUALS(dev[D_TYPE], type))
		return(na);
	}
	/* if we didn't find a good device, try the next devices file */
	if (( file = nameSysFile (O_DEVICES,findex)) != NULL) {
	    fclose (fp);
	    DEBUG(10, "use Devices: %s\n", file);
	    fp = fopen (file, "r");
	}
	if (fp != NULL && file != NULL)
	    continue;

	/* no more devices files, back out here */
	CDEBUG(1, "No Device Available\n", 0);
	return(FAIL);
    }
    /* NOTREACHED */
}

static int
classmatch(flds, dev)
char	*flds[], *dev[];
{
	/* check class, check (and possibly set) speed */
	CDEBUG(4, "classmatch(%s, ", flds[F_CLASS]);
	CDEBUG(4, "%s)\n", dev[D_CLASS]);
	if (EQUALS(flds[F_CLASS], "Any")) {
		if (EQUALS(dev[D_CLASS], "Any"))
			dev[D_CLASS] = flds[F_CLASS] = DEFAULT_BAUDRATE;
		else
			flds[F_CLASS] = dev[D_CLASS];
	} else if ((!EQUALS(dev[D_CLASS], "Any"))
		&& (!EQUALS(flds[F_CLASS], dev[D_CLASS])))
			return(FAIL);
	return(SUCCESS);
}
#endif /* LOOKUP_BAUDRATE */

#ifdef LOCK_CHECK
/* code from uustat.c
 */
#define MAXLOCKS 100	/* Maximum number of lock files this will handle */

lckpid()
{
    register i;
    long pid, ret, fd;
#ifdef ASCIILOCKS
    char alpid[SIZEOFPID+2];	/* +2 for '\n' and null */
#endif
    long list[MAXLOCKS];
    char buf[BUFSIZ], f[MAXBASENAME];
    char *c, lckdir[BUFSIZ];
    DIR *dir;
    int header=0;

    DEBUG(9, "lckpid() - entered\n", "");
    printf("\nSystem locks:");
    for (i=0; i<MAXLOCKS; i++)
	list[i] = -1;
    (void) strcpy(lckdir, LOCKPRE);
    *strrchr(lckdir, '/') = '\0';
    DEBUG(9, "lockdir (%s)\n", lckdir);

    /* open lock directory */
    if (chdir(lckdir) != 0 || (dir = opendir(lckdir)) == NULL)
		exit(101);		/* good old code 101 */
    while (gnamef(dir, f) == TRUE) {
	/* find all lock files */
	DEBUG(9, "f (%s)\n", f);
	if (EQUALSN("LCK.", f, 4)) {
	    if (!header){
		printf("\n");
		header = 1;
	    }
	    /* read LCK file */
	    fd = open(f, O_RDONLY);
	    printf("%s: ", f);
#ifdef ASCIILOCKS
	    ret = read(fd, alpid, SIZEOFPID+2); /* +2 for '\n' and null */
	    pid = atoi(alpid);
#else
	    ret = read(fd, &pid, sizeof (int));
#endif
	    (void) close(fd);
	    if (ret != -1) {
		printf("%d\n", pid);
		for(i=0; i<MAXLOCKS; i++) {
		    if (list[i] == pid)
			break;
		    if (list[i] == -1) {
		        list[i] = pid;
		        break;
		    }
		}
	    }
	    else
		printf("????\n");
	}
    }
    fflush(stdout);
    *buf = NULLCHAR;
    for (i=0; i<MAXLOCKS; i++) {
	if( list[i] == -1)
		break;
#ifdef BSD4_4
	sprintf (buf, "/bin/ps -lp %d%s", list[i],
		i ? "| /usr/bin/tail -1" : "");
	system(buf);
#else
	(void) sprintf(&buf[strlen(buf)], "%d ", list[i]);
#endif
    }
#ifdef BSD4_4
    exit(0);	/* at this point we are done */
#endif

    if (!header)		/* didn't finish the header, so no locks */
	printf(" NONE\n");
    if (i > 0)
#ifdef V7
	execl("/bin/ps", "uustat-ps", buf, CNULL);
#else
	execl("/bin/ps", "ps", "-flp", buf, CNULL);
#endif
    exit(0);
}

#endif /* LOCK_CHECK */
