
#include "uucp.h"
VERSION("$Id: versys.c,v 1.2 1990/08/23 22:33:36 roger C_3 $")

/*
 * verify system name
 * input:
 *	name	-> system name
 * returns:  
 *	0	-> success
 *	FAIL	-> failure
 */
versys(name)
char *name;
{
	register char *iptr;
	char line[300];

	if (name == 0 || *name == 0)
		return(FAIL);

#ifdef mc68k
	if (EQUALSN(name, Myname, CTSYSNAMELEN))
#else
	if (EQUALS(name, Myname))
#endif /* mc68k */
		return(0);

	while (getsysline(line, sizeof(line))) {
		if((line[0] == '#') || (line[0] == ' ') || (line[0] == '\t') || 
			(line[0] == '\n'))
			continue;

		if ((iptr=strpbrk(line, " \t")) == NULL)
		    continue;	/* why? */
		*iptr = '\0';
#ifdef mc68k
		if (EQUALSN(name, line, CTSYSNAMELEN)) {
#else
		if (EQUALS(name, line)) {
#endif /* mc68k */
			sysreset();
			return(0);
		}
	}
	sysreset();
	return(FAIL);
}
