/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header: /usr/src/usr.ibm/aedtest/RCS/vikst.h,v 1.4 1994/06/01 16:07:37 md Exp $ */
/* $ACIS:vikst.h 12.0$ */
/* $Source: /usr/src/usr.ibm/aedtest/RCS/vikst.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidvikst = "$Header: /usr/src/usr.ibm/aedtest/RCS/vikst.h,v 1.4 1994/06/01 16:07:37 md Exp $";
#endif

/* vikst.h 
*/

#define BUSWAIT 1

#ifdef BSD
#include <stdio.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <machine/aedioctl.h>
#define delay(A) {register i;for(i=0;i<A;i++) ioctl(v_control,AEDDELAY);}
#define DELAY(A) {extern v_control; delay(A)}
#else
#include "stdio.h"
#include "display.h"
#include "delay.h" 
#endif

#define vread(X,Y,Z)  { delay(BUSWAIT); bcopy(0xf40a0000+Z, X, Y+Y);  }
#define vwrite(X,Y,Z) bcopy(X, (0xf40a0000+Z), Y+Y) 
#define INT16  short
#define UINT16  unsigned   short
#define INT32  int
#define UINT32 unsigned int
#define PRINTF printf 
#define FPRINTF fprintf


#define FALSE 0
#define TRUE -1
#define SR 0x4000
#define VIKCONT vwrite(&zero,1,0x4000); delay(BUSWAIT) 

#ifdef BSD
#define vikrun ioctl(v_control,AEDSTART)
#define vikstop ioctl(v_control,AEDRESET)
#else
#define vikrun  vread(&zero,1,0x4000); delay(BUSWAIT)
#define vikstop vread(&zero,1,0); delay(BUSWAIT)
#endif

#define bad -1

#define chkpt	0xee00
#define chk30	0xee00

#define false 0
#define ok 0

#ifdef BSD /**********************/
#define abortb(A) { fprintf(out,A);    \
			dumpspool(); \
		    fprintf(stderr,A); \
		    exit(); }
#define a2b(A,B) { fprintf(out,A,B); \
			dumpspool();	\
		   fprintf(stderr,A,B); \
		    exit(); }
#else
#define abortb(A) { printf(A);\
		    printf("stopping"); for(;;); }
#define a2b(A,B) {  printf(A,B);   \
		    printf("stopping"); for(;;); }
#endif /*************************/

#ifdef BSD
#define p4b(A,B,C,D) {fprintf(spool,A,B,C,D);}
#define p3b(A,B,C)   {fprintf(spool,A,B,C); }
#define p2b(A,B)     {fprintf(spool,A,B); }
#define p1b(A)	     {fprintf(spool,A); }
#define p4m(A,B,C,D)  fprintf(spool,A,B,C,D);
#define p3m(A,B,C)    fprintf(spool,A,B,C);
#define p2m(A,B)      fprintf(spool,A,B);
#define p1m(A)	      fprintf(spool,A);
#else
#define p4b(A,B,C,D) {printf(A,B,C,D);}
#define p3b(A,B,C)   {printf(A,B,C); }
#define p2b(A,B)     {printf(A,B); }
#define p1b(A)	     {printf(A); }
#define p4m(A,B,C,D)  printf(A,B,C,D);
#define p3m(A,B,C)    printf(A,B,C);
#define p2m(A,B)      printf(A,B);
#define p1m(A)	      printf(A);
#endif

#ifdef BSD /*********************/
#define p4d(A,B,C,D) {fprintf(spool,A,B,C,D);  fprintf(out,A,B,C,D); }
#define p3d(A,B,C)   {fprintf(spool,A,B,C);  fprintf(out,A,B,C);  }
#define p2d(A,B)     {fprintf(spool,A,B);  fprintf(out,A,B); }
#define p1d(A)	     {fprintf(spool,A);  fprintf(out,A); }
#else
#define p4d(A,B,C,D) {printf(A,B,C,D); }
#define p3d(A,B,C)   {printf(A,B,C);}
#define p2d(A,B)     {printf(A,B);}
#define p1d(A)	     {printf(A);}
#endif /**************************/

#define steps 20
#define true  -1
#define vikdone 0xffff
