/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:vspram.c 12.0$ */
/* $ACIS:vspram.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/aedtest/RCS/vspram.c,v $ */

#ifndef lint
static char *rcsid = "$Header:vspram.c 12.0$";
#endif

/* vspram.c */
#include "vikst.h"
typedef struct cnode { INT16 bit[4];
		       INT16 unum; } err;
static err chip[4];
static INT16 a;

#ifdef BSD
  extern FILE *out,*spool;
	extern dumpspool();
	extern int v_control;
#endif

spram()
{ INT16 k;
  UINT16 addr,bits;
  UINT16 finished,j;
  extern UINT16 zero;

  load("scpad.vkt");
  chip[0].unum = 37;  chip[1].unum = 36;
  chip[2].unum = 50;  chip[3].unum = 49;
  for (a=0; a<4; a++)
      for (k=0; k<4; k++) chip[k].bit[a] = 0;
  finished = false;
  a=false;
  while( finished == false)
     { if (look(&addr,&bits,&k))
#ifndef NOTIMEOUT
	 abortb("Time out in Scratchpad RAM\n");
#else
	{
	 p1d("\007Time out in Scratchpad RAM -- continuing\n");
	p2d("look returned %x\n",addr);
	dumptime();
	return(0);
	}
#endif
       switch(addr)
	  { case vikdone: finished=true; break;
	    case chkpt:   VIKCONT; break;   /* tell viking to continue */
	    default:	  sperr(bits);	VIKCONT; break;
	  }
     }
  if (a == false) return(false);
  p3d("%4s\n%7s"," ","chip ->");
  for (k=0; k<4; k++)
      p3d("%10s%2d","U",chip[k].unum);
  p1d("\n");
  for (k=0; k<4; k++)
      { p3d("%-4s%-3d","bit",k);
	p3d("%12d%12d",chip[0].bit[k],chip[1].bit[k]);
	p3d("%12d%12d",chip[2].bit[k],chip[3].bit[k]);
	p1d("\n");
      }
  return(a);
}

sperr(bits)
UINT16 bits;
{ UINT16 b;
  a = true;
  if (bits &	 1) chip[0].bit[0] += 1;
  if (bits &	 2) chip[0].bit[1] += 1;
  if (bits &	 4) chip[0].bit[2] += 1;
  if (bits &	 8) chip[0].bit[3] += 1;
  if (bits &	16) chip[1].bit[0] += 1;
  if (bits &	32) chip[1].bit[1] += 1;
  if (bits &	64) chip[1].bit[2] += 1;
  if (bits &   128) chip[1].bit[3] += 1;
  if (bits &   256) chip[2].bit[0] += 1;
  if (bits &   512) chip[2].bit[1] += 1;
  if (bits &  1024) chip[2].bit[2] += 1;
  if (bits &  2048) chip[2].bit[3] += 1;
  if (bits &  4096) chip[3].bit[0] += 1;
  if (bits &  8192) chip[3].bit[1] += 1;
  if (bits & 16384) chip[3].bit[2] += 1;
  if (bits & 32768) chip[3].bit[3] += 1;
}
