/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:dumpaed.c 12.0$ */
/* $ACIS:dumpaed.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/bitprt_ca/RCS/dumpaed.c,v $ */

#ifndef lint
static char *rcsid = "$Header:dumpaed.c 12.0$";
#endif

/* 
 * dumpaed -- copies the bitmap contents 
 *	of the aed screen to standard out
 * 	for use by subsequent filters 
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/errno.h>

extern int errno, perror();
#define SCANLINES 800
#define LPIXELS 1024
#define LBYTES (LPIXELS/8)
#define BLOCKSIZE 4096
#define READLINES (BLOCKSIZE/LBYTES)
#define AED_SHAREDRAM 0xf40a0000
#define WHIM_FIRST 0xd188001e

main(argc,argv)
int argc; 
char *argv[];
{
	int wd,ht,i;
	int dumpdev;
	int *whereaed;
	char buf[BLOCKSIZE];
	struct  {
		int screenwidth;
		int screenheight;
	} 
	screensize;
#ifdef DEBUG
	fprintf(stderr,"dumpaed started.\n");
#endif DEBUG

	dumpdev = fileno(stdout);
	if (argc > 1)
	{
		fprintf(stderr,"dumpaed takes no argument\n");
	}
	screensize.screenwidth = LPIXELS;
	screensize.screenheight = SCANLINES;
	write(dumpdev,&screensize,sizeof(screensize));
	/* first fill the screen buffer */
	/* initialize subroutine package. */
	if ((open("/dev/aed",O_RDONLY)) > 0)
	{
		VI_Init(&wd,&ht);
	}
	/* see if it's already open */
	else if (errno == EBUSY)
	{
		if (open("/dev/bus",O_RDONLY) < 0) 
		{
			perror("/dev/bus");
			exit(2);
		}
		whereaed = (int *) AED_SHAREDRAM;
		if (*whereaed != WHIM_FIRST)/* first instruction in whim.aed */
		{
			fprintf(stderr,"whim.aed is not loaded\n");
			exit(2);
		}
	}
	else
	{
		perror("cannot access aed");
		exit(2);
	}
	for (i=0;i<SCANLINES;i+=READLINES)
	{
		VI_MRead(0,i,LPIXELS,READLINES,buf);
		VI_Force();
		/* now write out the buffer */
		if (write(dumpdev,buf,BLOCKSIZE) < 0)
		{
#ifdef DEBUG
			fprintf(stderr,"dumpdev=%d\n",dumpdev);
#endif DEBUG
			perror("could not write to file");
			exit(2);
		}
	}
	exit(0);
}
