/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:main_dit3812.c 12.0$ */
/* $ACIS:main_dit3812.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/ditroff/dit3812/RCS/main_dit3812.c,v $ */

#ifndef lint
static char *rcsid = "$Header:main_dit3812.c 12.0$";
#endif

/***===================================================================***/

#define SJ_DEFAULT_TYPE(e)	"ditroff-output"
#define SJ_ARG_PARSER(c,v,i,e)	d3_ParseArg(c,v,i,e)

#include <spooljob.c>
#include <pmp/pmp.h>
#include "setup_dit3812.h"

/***===================================================================***/

extern int d3_debug;
extern int ln_debug;
extern int mn_debug;
extern int ff_debug;
extern int if_debug;
extern int tr_debug;

/***===================================================================***/

#ifdef DEBUG_UTILS
u_debug_arg debug_args[] ={
    "d3",	&d3_debug,
    "ff",	&ff_debug,
    "if",	&if_debug,
    "tr",	&tr_debug,
    NULL,	NULL
};

#endif /* DEBUG_UTILS */

/***===================================================================***/

d3_ParseArg(argc,argv,ind,env)
register1 int      argc;
register2 char    *argv[];
register3 int      ind;
register4 environ *env;
{
extern int   optind;
extern int   optional;
extern char *optarg;
register5 int ch;
register6 int old= optional;

    D_ENTRY4(d3_debug,"d3_ParseArg(%d,0x%x,%d,0x%x)\n",argc,argv,ind,env);
    optind= ind;
    optional= TRUE;
    ch= getopt(argc,argv,"D:x:y:");
    optional= old;
    switch (ch) {
#ifdef DEBUG_UTILS
	when 'D':	if (optarg) p_set_debug(optarg);
			else        p_set_debug("a");
#else
	when 'D':	warning("debugging arguments disabled\n");
			action("-D flag ignored\n");
#endif /* DEBUG_UTILS */
	case 'x':	break;
	case 'y':	break;
	default:	warning1("Unknown flag '%c'\n",ch);
			action("ignored\n");
			optind++;
			RETURN(FALSE);
    }
    RETURN(TRUE);
}

/***===================================================================***/

FILE *
d3_Output(env)
register1 environ *env;
{
register2 char *host;
register3 char *user;
char cmd[100];

    D_ENTRY1(d3_debug,"OpenOutput(0x%x)\n",env);
    host= env_String(env,"host",DFL_HOST);
    user= env_String(env,"user",DFL_USER);
    sprintf(cmd,"%s ",DIT_OUTPUT_NAME);
    if (user) {
	strcat(cmd,"-n ");
	strcat(cmd,user);
	if (host) {
	    strcat(cmd," -h ");
	    strcat(cmd,host);
	}
    }
    RETURN(u_popen(cmd,"w"));
}

/***===================================================================***/

d3_Cleanup(in,out)
register1 FILE *in;
register2 FILE *out;
{
    D_ENTRY2(d3_debug,"d3_Cleanup(0x%x,0x%x)\n",in,out);
    p_eject(TRUE);
    RETURN(TRUE);
}

/***============================================================***/

d3_Cancel()
{
extern int d3_bail;

    D_ENTRY(d3_debug,"d3_Cancel()\n");
    action("all right! all right! I'm leaving\n");
    d3_bail= TRUE;
    RETURN(SJ_EXIT_PENDING);
}

/***===================================================================***/

extern int   d3812();

sj_jobtype sj_types[]= {
    { "ditroff-output", NULL,d3_Output,NULL,d3812,d3_Cleanup,d3_Cancel },
    { NULL,NULL,NULL,NULL,NULL,NULL  }
};

