/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:fonts.h 12.0$ */
/* $ACIS:fonts.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/h/RCS/fonts.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidfonts = "$Header:fonts.h 12.0$";
#endif

/*
 * fonts.h - C type defintions for processing font information
 */

#ifndef _FONTS
#define _FONTS

/*-----------------------Font Face Classes-------------------------*/
/* The following classes are defined

    "unassigned",
    "roman",
    "bold",
    "italic",
*/

/*-----------------------Font Weight Classes-----------------------*/
/* The following classes are defined:

    "unassigned",
    "ultra_light",
    "extra_light",
    "light",
    "semi_light",
    "medium",
    "semi_bold",
    "bold",
    "extra_bold",
    "ultra_bold",
*/

/*--------------------------------Font Width Classes------------------------*/
/* The following classes are defined

    "unassigned",
    "ultra_condensed",
    "extra_condensed",
    "condensed",
    "semi_condensed",
    "medium",
    "semi_expanded",
    "expanded",
    "extra_expanded",
    "ultra_expanded",
*/

/*-----------------------order pairs definition-------------------------*/
typedef struct {
    int h;
    int v;
} itc_opair_type;

/*---------------------per character data-------------------------------*/
typedef struct {
    string name;
    string character_set;
    string source;
    itc_opair_type bounding_box;
    itc_opair_type origin;
    itc_opair_type spaceing_type;
    string image_type;
    byte *raster_image;
} itc_c_entry_type;

/*--------------------character_sets entry-------------------------------*/

typedef struct {
    string name; 		/* a short unique id for this font descriptor*/
    string family;		/* e.g. times, helvetica */
    string typeface;		/* e.g. roman, italic */
    natural size;		/* Tenths of points, nominal design target */
    string width;		/* width class (see comments above) */
    string weight;		/* weight class (see comments above) */
    natural rotation;		/* Tenths of degrees measured clockwise from
				   the print direction */
    natural print_direction;	/* Tenths of degrees measured clockwise from
				   normal */
    string device;		/* sxxx, where s is for square pixel 
				   arrangement and xxx is the resolution */
    string alphabet;		/* e.g. English, Hebrew, ... */
    string source;		/* ownership/copyright info */
    natural resolution;		/* pixel per inch (assums sq. arrangement) */
    string spaceing;		/* Kerned or Fixed_width */
    itc_opair_type  max_box;	/* Max pattern box */
    itc_opair_type lowest;	/* lowest desender  */
    itc_opair_type highest;	/* highest asender  */
    itc_opair_type interline;	/* baseline to baseline design point */
    itc_opair_type em_space;	/* space for an m */
    itc_opair_type en_space;	/* space for an n */
    itc_opair_type figure_space;/* space for any digit */
} itc_cs_entry_type;

#endif	_FONTS
