/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:strhash.c 12.0$ */
/* $ACIS:strhash.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/lib/src/RCS/strhash.c,v $ */

#ifndef lint
static char *rcsid = "$Header:strhash.c 12.0$";
#endif

/*************************************************************\
* 							      *
*  strhash: a routine to hash strings			      *
* 							      *
*  Parameters are:					      *
* 							      *
*  string(in): the string to be hashed			      *
* 							      *
*  size(in): the hash value returned will be >= 0 and < size  *
* 							      *
*  value(out): the hash value				      *
* 							      *
\*************************************************************/

int strhash (string, size, value)
  char *string;
  unsigned int size;
  unsigned int *value;
{
    unsigned int    temp_sum;
    temp_sum = 0;
    while (*string) {
	temp_sum = (temp_sum * 31) + (*string - 31);
				/* overflow is ignored */
	string++;
    }
    *value = temp_sum % size;
    return;
}
