/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pmp_utils.c 12.0$ */
/* $ACIS:pmp_utils.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/pmp_utils.c,v $ */

#ifndef lint
static char *rcsid = "$Header:pmp_utils.c 12.0$";
#endif

#include <stdio.h>
#include <utils.h>
#include <pmp_utils.h>
#include <pmp_commands.h>
#include <char.h>
#include <font.h>
#include <rp.h>
#include <printer.h>


/***============================================================***/

int pu_debug;

#define get_byte(w,n)	(((w)>>((n)*8))&0xff)
#define set_byte(w,n,b)	((w)|=(((b)&0xff)<<((n)*8)))

/***============================================================***/

int16
u_get16(fil)
register2 FILE *fil;
{
register1 int   word=0;

    D_ENTRY1(pu_debug,"u_get16(0x%x)\n",fil);
    set_byte(word,1,getc(fil));
    set_byte(word,0,getc(fil));
    RETURN(word);
}

/***============================================================***/

int
u_get24(fil)
register1 FILE *fil;
{
register1 int   word=0;

    D_ENTRY1(pu_debug,"u_get24(0x%x)\n",fil);
    set_byte(word,2,getc(fil));
    set_byte(word,1,getc(fil));
    set_byte(word,0,getc(fil));
    RETURN(word);
}

/***============================================================***/

int
u_put16(word,fil)
register1 int	word;
register2 FILE	*fil;
{

    D_ENTRY2(pu_debug,"u_put16(0x%x,0x%x)\n",word,fil);
    putc(get_byte(word,1),fil);
    RETURN(putc(get_byte(word,0),fil));
}
/***============================================================***/

int32
u_put24(word,fil)
register1 int32	 word;
register2 FILE	*fil;
{

    D_ENTRY2(pu_debug,"u_put24(0x%x,0x%x)\n",word&0xffffff,fil);
    putc(get_byte(word,2),fil);
    putc(get_byte(word,1),fil);
    RETURN(putc(get_byte(word,0),fil));
}

/***============================================================***/

int
u_direction(old_orient,new_orient)
register1 int	old_orient;
register2 int	new_orient;
{
    D_ENTRY2(pu_debug,"u_direction(0x%x,0x%x)\n",old_orient,new_orient);
    if (old_orient==new_orient) 
	RETURN(U_ROT_NOT);
    switch (old_orient) {		/* from OLD orientation */
	when P_PORTRAIT:	/* to NEW orientation	*/
		switch (new_orient) {
		    case P_RIGHT_LANDSCAPE:	RETURN(U_ROT_LEFT);
		    case P_INVERTED:		RETURN(U_ROT_INVERT);
		    case P_LEFT_LANDSCAPE:	RETURN(U_ROT_RIGHT);
		}
	when P_INVERTED:
		switch (new_orient) {
		    case P_PORTRAIT:		RETURN(U_ROT_INVERT);
		    case P_RIGHT_LANDSCAPE:	RETURN(U_ROT_RIGHT);
		    case P_LEFT_LANDSCAPE:	RETURN(U_ROT_LEFT);
		}
	when P_RIGHT_LANDSCAPE:
		switch (new_orient) {
		    case P_PORTRAIT:		RETURN(U_ROT_RIGHT);
		    case P_INVERTED:		RETURN(U_ROT_LEFT);
		    case P_LEFT_LANDSCAPE:	RETURN(U_ROT_INVERT);
		}
	when P_LEFT_LANDSCAPE:
		switch (new_orient) {
		    case P_PORTRAIT:		RETURN(U_ROT_LEFT);
		    case P_RIGHT_LANDSCAPE:	RETURN(U_ROT_INVERT);
		    case P_INVERTED:		RETURN(U_ROT_RIGHT);
		}
    }
    RETURN(U_ROT_ILLEGAL);
}

/***============================================================***/

int
u_rotatecoord(direction,width,height,x,y)
register6 int	 direction;
register3 int	 width;
register4 int	 height;
register1 int	*x;
register2 int	*y;
{
register5 int	 tmp;

    D_ENTRY5(pu_debug,"u_rotatecoord(%d,%d,%d,%d)\n",direction,width,height,
								     *x,*y);
    switch (direction) {
	case U_ROT_LEFT:
		tmp=	*x;
		*x=	*y;
		*y=	width-tmp;
		break;
	case U_ROT_RIGHT:
		tmp=	*x;
		*x=	height-*y;
		*y=	tmp;
		break;
	case U_ROT_INVERT:
		*x=	width-*x;
		*y=	height-*y;
		break;
	case U_ROT_NOT:
		RETURN(TRUE);
	case U_ROT_ILLEGAL:
		error("u_rotatecoord can't rotate U_ROT_ILLEGAL\n");
		action("ignored\n");
		RETURN(FALSE);
	default:
		WSGO1("u_rotatecoord -- unknown direction 0x%x\n",direction);
		action("ignored\n");
		RETURN(FALSE);
    }
    RETURN(TRUE);
}
